<?php

  /*
   *  Secure Login Plugin
   *  By Graham Norbury <gnorbury@bondcar.com>
   *  Changes by Paul Lesneiwski <pdontthink@angrynerds.com>
   *  v1.0 (c) 2002 (GNU GPL - see ../../COPYING)
   *
   *  This is a very simple plugin which enforces use of SSL security for logins.
   *
   *  If you need help with this, or see improvements that can be made, please
   *  email one or both of us directly at the addresses above.
   *
   *  NOTE: If you are using the show_ssl_link plugin, it is liable to
   *        override these settings, so either make sure you synch its
   *        "$go_back_to_http_after_login" setting with the desired
   *        behavior you expect for your site or disable it when using
   *        this plugin (this plugin makes show_ssl_link unnecessary...)
   *
   */
   global $change_back_to_http_after_login, $remain_in_https_if_logged_in_using_https,
          $allVirtualDomainsUnderOneSSLHost, $securePort;


//##################################################################################
//                          USER-DEFINED CONFIG SETTINGS


   // if you want user sessions to remain in SSL for their entire duration, 
   // set the following to zero:
   //
   $change_back_to_http_after_login = 1;


   // if you want user sessions to remain in SSL only if they originally came
   // in thru SSL (this plugin didn't need to redirect them), set the following 
   // to one:
   //
   $remain_in_https_if_logged_in_using_https = 0;


   // for those that host virtual domains off of a single SSL tree, set this
   // value to the root of that tree... for example 'www.mainssldomain.com/'
   // the end result would look something like:
   // https://www.mainssldomain.com/virtualdomain.com/mail
   // where "https://" is added for you automatically, "www.mainssldomain.com/"
   // is the value you set here, and "virtualdomain.com/mail" is the URL that the
   // user originally used to get here
   //
   $allVirtualDomainsUnderOneSSLHost = '';


   // by default, https requests are made without explicitly defining the
   // port number.  if you use a non-standard port for serving http requests, 
   // that port will be preserved for the https redirection, which may break
   // your squirrelmail.
   // 
   // if your server listens for https requests on a non-standard port or
   // the above situation applies to you, you can specify a non-standard 
   // https port number here (or remove it, forcing the browser use the
   // default port (443)).
   // 
   // if you use this setting, remember to remove the slashes in front of it
   //
   // $securePort = '';
   // $securePort = '888';


//##################################################################################

?>
