<?php
// $Id: sasql_api.php,v 1.7 2006/08/22 21:53:25 perlstalker Exp $

/**
 * API for talking to sasql from other plugins.
 * 
 * @package sasql_api.php
 */ 

/*
API functions:
o Check addresses against the white/blacklists (stubbed)
o Add/remove addresses to the lists (stubbed)
o Get/set preferences (stubbed)
o Purge spam folder (done)
o Add address book with whitelist (done; but should be changed to allow
  one to remove whitelist entries not in the address book.)
*/

if (!defined('SM_PATH')) { define('SM_PATH' , '../../'); }

include_once(SM_PATH.'include/load_prefs.php');
include_once(SM_PATH.'plugins/sasql/sasql_conf.php');
include_once(SM_PATH.'plugins/sasql/sasql_db.php');
include_once(SM_PATH.'plugins/sasql/sasql_hooks.php');

// From sasql_conf.php
global $spam_folder;

// from SM
global $username;

// Modified from src/empty_trash.php.
/**
 * Delete the contents of the user's Spam folder and all sub folders.
 *
 * @global string $username
 * @global string $spam_folder
 *
 * @param string $folder If not passed, the global variable,
 * {@link $spam_folder}, will be used.
 *
 * @return boolean Always returns true.
 */
function sasql_purgeSpam ($folder = '')
{
  global $username, $imapServerAddress, $imapPort;
  if ($folder == '') {
    global $spam_folder;
    $folder = $spam_folder;
  }

  include_once(SM_PATH.'functions/imap.php');
  include_once(SM_PATH.'functions/tree.php');
  /* get those globals */

  sqgetGlobalVar('username', $username, SQ_SESSION);
  sqgetGlobalVar('key', $key, SQ_COOKIE);
  sqgetGlobalVar('delimiter', $delimiter, SQ_SESSION);
  sqgetGlobalVar('onetimepad', $onetimepad, SQ_SESSION);

  /* finished globals */
  
  $imap_stream = sqimap_login($username, $key, $imapServerAddress, $imapPort, 0);

  sqimap_mailbox_list($imap_stream);

  global $folder_prefix, $optional_delimiter;
  $mailbox = $folder_prefix.$folder;
  $boxes = sqimap_mailbox_list($imap_stream);
  
  /*
   * According to RFC2060, a DELETE command should NOT remove inferiors (sub folders)
   *    so lets go through the list of subfolders and remove them before removing the
   *    parent.
   */
  
  /** First create the top node in the tree **/
  $numboxes = count($boxes);
  for ($i = 0; $i < $numboxes; $i++) {
    if (($boxes[$i]['unformatted'] == $mailbox) && (strlen($boxes[$i]['unformatted']) == strlen($mailbox))) {
      $foldersTree[0]['value'] = $mailbox;
      $foldersTree[0]['doIHaveChildren'] = false;
      continue;
    }
  }
  /*
   * Now create the nodes for subfolders of the parent folder
   * You can tell that it is a subfolder by tacking the mailbox delimiter
   *    on the end of the $mailbox string, and compare to that.
   */
  $j = 0;
  for ($i = 0; $i < $numboxes; $i++) {
    if (substr($boxes[$i]['unformatted'], 0, strlen($mailbox . $delimiter)) == ($mailbox . $delimiter)) {
      addChildNodeToTree($boxes[$i]['unformatted'], $boxes[$i]['unformatted-dm'], $foldersTree);
    }
  }

  // now lets go through the tree and delete the folders
  walkTreeInPreOrderEmptyTrash(0, $imap_stream, $foldersTree);
  sqimap_logout($imap_stream);

  sasql_autocreate_spam_folder();

  return true;
}

/**
 */
function sasql_addressInWBList ($username, $address, $list) {
}

/**
 */
function sasql_syncABookWithWList ($username, $remove = 0) {
  include_once(SM_PATH.'functions/addressbook.php');

  global $SqlDSN, $SqlTable;

  $dbh = sasql_DBConnect($SqlDSN);
  if (DB::isError($dbh)) {
    return false;
  } else {
    $abook = addressbook_init(true, true);
    $book_addrs = $abook->list_addr();

    // Whitelist all addresses in the address book
    foreach ($book_addrs as $addr) {
      // Add address to the whitelist if it's not there
      if (! sasql_AddrInWBList ($dbh, $SqlTable, $username,
				'w', $addr['email'])) {
	sasql_AddPref ($dbh, $SqlTable, $username,
		       'whitelist_from', $addr['email']);
      }

      // Remove from blacklist if it exists
      if (sasql_AddrInWBList ($dbh, $SqlTable, $username,
			      'b', $addr['email'])) {
	sasql_DelPref_value ($dbh, $SqlTable, $username,
			     'blacklist_from', $addr['email']);
      }
    }
  }
}

/**
 */
function sasql_addAddressToWBList($username, $address, $list) {
}

/**
 */
function sasql_removeAddressFromWBList($username, $address, $list) {
}

/**
 */
function sasql_getPreference($username, $preference) {
}

/**
 */
function sasql_getPreference_multiple($username, $preference) {
}

/**
 */
function sasql_setPreference($username, $preference, $value) {
}

/**
 */
function sasql_setPreference_multiple($username, $preference, $values) {
}

?>