<?php
// Set sasql gettext domain
if (!defined('SM_PATH')) { define('SM_PATH', '../..'); }
bindtextdomain ('sasql', SM_PATH . 'locale');
textdomain ('sasql');
?>

<a name="greylisting"></a><h1><?php echo _("Greylisting"); ?></h1>
<h2><?php echo _("What is Greylisting?"); ?></h2>
<p>
<?php
 echo _("Greylisting is a method of filtering spam that relies on the fact that most spammers use software that does not behave like a regular email program. Instead of retrying when it receives a \"temporary error\" from a mail server, the spammer's software will give up on the message and keep going through their list. Because legitimate servers will attempt to resend the message after a temporary error, no legitimate mail is blocked.");
?>
</p>
<h2><?php echo _("Email Delays") ?></h2>
<p>
<?php
 echo _("Greylisting tells the sending server to retry before the message is allowed in. Most servers will retry within five minutes but may take longer depending on the amount of mail to be sent. It is not surprising to see mail delayed for as much as an hour, though such delays are uncommon.");
?>
</p>
<p>
 <b><?php echo _("Warning: "); ?></b>
 <?php echo _("Do not enable greylisting if you require immediate delivery of email."); ?>
</p>

<?php
// Set gettext domain back to squirrelmail.
bindtextdomain ('squirrelmail', SM_PATH . 'locale');
textdomain ('squirrelmail');
?>