<?php

/**
 * move_to.php
 *
 * Copyright (c) 1999-2004 The SquirrelMail Project Team
 * Licensed under the GNU GPL. For full terms see the file COPYING.
 *
 * Enables message moving between folders on the IMAP server.
 *
 * $Id: move_to.php,v 1.2 2004/12/13 21:01:24 perlstalker Exp $
 */

/* Path for SquirrelMail required files. */
define('SM_PATH','../../');

/* SquirrelMail required files. */
require_once(SM_PATH . 'include/validate.php');
require_once(SM_PATH . 'functions/global.php');
require_once(SM_PATH . 'functions/display_messages.php');
require_once(SM_PATH . 'functions/imap.php');
require_once(SM_PATH . 'functions/html.php');

global $compose_new_win;

if ( !sqgetGlobalVar('composesession', $composesession, SQ_SESSION) )
{
	$composesession = 0;
}

/* get globals */
sqgetGlobalVar('key',       $key,           SQ_COOKIE);
sqgetGlobalVar('username',  $username,      SQ_SESSION);
sqgetGlobalVar('onetimepad',$onetimepad,    SQ_SESSION);
sqgetGlobalVar('delimiter', $delimiter,     SQ_SESSION);
sqgetGlobalVar('base_uri',  $base_uri,      SQ_SESSION);

sqgetGlobalVar('composesession',    $composesession,    SQ_SESSION);
sqgetGlobalVar('lastTargetMailbox', $lastTargetMailbox, SQ_SESSION);

sqgetGlobalVar('moveButton',      $moveButton,      SQ_FORM);
sqgetGlobalVar('targetMailbox',   $targetMailbox,   SQ_FORM);
sqgetGlobalVar('mailbox',   $mailbox,   SQ_FORM);
sqgetGlobalVar('startMessage',   $startMessage,   SQ_FORM);
sqgetGlobalVar('sort',   $sort,   SQ_FORM);
sqgetGlobalVar('move_id',   $move_id,   SQ_FORM);
sqgetGlobalVar('location',        $location,        SQ_FORM);
//sqgetGlobalVar('',   $,   SQ_FORM);

/* end of get globals */

$imapConnection = sqimap_login($username, $key, $imapServerAddress, $imapPort, 0);
$mbx_response=sqimap_mailbox_select($imapConnection, $mailbox);

$location = set_url_var($location,'composenew',0,false);
$location = set_url_var($location,'composesession',0,false);
$location = set_url_var($location,'session',0,false);

/* remember changes to mailbox setting */
if (!isset($lastTargetMailbox))
{
	$lastTargetMailbox = 'INBOX';
}
if ($targetMailbox != $lastTargetMailbox)
{
	$lastTargetMailbox = $targetMailbox;
	sqsession_register($lastTargetMailbox, 'lastTargetMailbox');
}
$exception = false;

// Move messages

if (isset($move_id))
{
	sqimap_msgs_list_copy($imapConnection,$move_id,$targetMailbox);
	if ($auto_expunge)
	{
		$cnt = sqimap_mailbox_expunge($imapConnection, $mailbox, true);
	}
	else
	{
		$cnt = 0;
	}

	$location = set_url_var($location,'startMessage',$startMessage, false);
	$location = set_url_var($location,'mailbox',$mailbox, false);
}
else
{
	$exception = true;
}

// Log out this session
sqimap_logout($imapConnection);
if ($exception)
{
	displayPageHeader($color, $mailbox);
	error_message(_("No messages were selected."), $mailbox, $sort, $startMessage, $color);
}
else
{
	header("Location: $location");
	exit;
//	echo "header: " . $location;
}
?>
</BODY></HTML>
