<?php

/** Rootly News plugin for squirrelmail
    Written by Jesse Johnson
    Copyright 2007 Coreroot Inc
    The Rootly News Plugin for Squirrelmail is free software.
    you can redistribute it and/or modify it under the terms of version 2 of
    the GNU General Public License as published by the Free Software Foundation.
    See the COPYING file for more information
**/

/** Plugin hooks */
function squirrelmail_plugin_init_rootly_news() {
    global $squirrelmail_plugin_hooks;
    $squirrelmail_plugin_hooks
        ['template_construct_left_main.tpl']['rootly_news'] = 'plugin_rootly_news_both';
    $squirrelmail_plugin_hooks
        ['left_main_after']['rootly_news']                  = 'plugin_rootly_news_bottom';
    $squirrelmail_plugin_hooks
        ['left_main_before']['rootly_news']                 = 'plugin_rootly_news_top';
    $squirrelmail_plugin_hooks
        ['optpage_register_block']['rootly_news']           = 'rootly_news_options_block';
    $squirrelmail_plugin_hooks
        ['options_display_save']['rootly_news']             = 'rootly_news_save_options';
}

/** Plugin Info */
function rootly_news_info() {
    return array (
        'english_name'             => 'Rootly News',
        'version'                  => '1.0.0',
        'required_sm_version'      => '1.4.0', 
        'summary'                  => 'A customizable news list from Rootly. ',
        'details'                  => 'This plugin allows users to display news based on topic categories and keyword searches.',
        'requires_configuration'   => 0,
        'requires_source_patch'    => 0,
        'per_version_requirements' => array(
                '1.5.2' => array(
                   'required_plugins' => array()
                ),
                '1.5.0' => array(
                   'required_plugins' => array(
                      'compatibility' => array(
                         'version' => '2.0.7',
                         'activate' => FALSE,
                      )
                   )
                ),
                '1.4.10' => array(
                   'required_plugins' => array()
                ),
                '1.4.0' => array(
                   'required_plugins' => array(
                      'compatibility' => array(
                         'version' => '2.0.7',
                         'activate' => FALSE,
                      )
                   )
                ),
             ),

    );
} 

/** Plugin Version */
function rootly_news_version() {
    $info = rootly_news_info();
    return $info['version'];
}

/** News list above folders */
function plugin_rootly_news_top() {
    include_once(SM_PATH . 'plugins/rootly_news/functions.php');
    plugin_rootly_news_do(1);
}

/** News list for 1.5 */
function plugin_rootly_news_both() {
    include_once(SM_PATH . 'plugins/rootly_news/functions.php');
    return plugin_rootly_news_do();
}
/** News list below folders */
function plugin_rootly_news_bottom() {
    include_once(SM_PATH . 'plugins/rootly_news/functions.php');
    plugin_rootly_news_do(2);
}

/** Plugin Preferences */
function rootly_news_options_block() {
   include_once(SM_PATH . 'plugins/rootly_news/functions.php');
    plugin_rootly_config_do();
}
