<?php

/* Squirrelmail page init stuff */
if (file_exists('../../include/init.php')) {
     include_once('../../include/init.php');
}
elseif (file_exists('../../include/validate.php')) {
     define('SM_PATH', '../../');
    include_once(SM_PATH . 'include/validate.php');
}
else {
    chdir('..');
    define('SM_PATH', '../');
    include_once(SM_PATH . 'src/validate.php');
}
global $plugins;
if (!in_array('rootly_news', $plugins)) {
   exit;
}

/* Print Title Bar */
sq_change_text_domain('squirrelmail');
displayPageHeader($color, 'None');
sq_change_text_domain('rootly_news');

/* category data */
$categories = array(2 => _("Sports"),  3 => _("Technology"), 11 => _("Science"), 4 => _("Business"), 1 => _("World"), 10 => _("Entertainment"));
$World = array( 18 => _("Africa"), 23 => _("Asia-Pacific"), 120 => _("Canada"), 24 => _("Europe"), 25 => _("Middle East"), 26 => _("South Asia"), 27 => _("UK"), 28 => _("US"));
$Sports = array( 57 => _("American Football"), 51 => _("Athletics"), 58 => _("Badminton"), 59 => _("Baseball"), 60 => _("Basketball"), 50 => _("Boxing"),
                 23 => _("College basketball"),45 => _("Cricket"), 54 => _("Cycling"), 44 => _("Football"), 48 => _("Golf"), 53 => _("Horse Racing"),
                 63 => _("Ice Hockey"), 49 => _("Motorsport"), 56 => _("Olympics"),46 => _("Rugby"), 47 => _("Tennis"), 67 => _("Winter sports"));
$Technology = array(29 => _("Apple"), 91 => _("Automobiles"), 31 => _("Design"), 86 => _("Digital Music"), 122=>_("Gadgets"), 32=>_("Gaming"), 
                    33=>_("Hardware"), 34=>_("Linux/Unix"), 116=>_("Microsoft"),37=>_("Nanotechnology"), 38=>_("Programming"), 117=>_("SearchEngines"),
                    41=>_("Security"), 13=>_("Software"), 43=>_("Web2.0"));
$Entertainment = array(119=>_("Arts"), 88=>_("Celebrities"), 89=>_("Fun"), 83=>_("Gossip"), 85=>_("Movies"), 87=>_("Music"), 90=>_("Opinion"), 84=>_("TV"), 125=>_("Weird"));
$Science = array(68=>_("Agriculture"), 121=>_("Animals"), 69=>_("Archaeology"), 71=>_("AtmosphericScience"), 72=>_("Biology"), 73=>_("Biotechnology"), 
                 74=>_("Chemistry"), 76=>_("EarthScience"), 77=>_("Education"), 78=>_("Mathematics"), 79=>_("MedicineandHealth"), 80=>_("Nature"),
                 75=>_("Physics"), 81=>_("PolicyandEthics"), 82=>_("SocialandBehavior"), 70=>_("Space &amp; Astronomy"));
$Business = array(105=>_("Bonds"), 113=>_("Careers"), 103=>_("CIO"), 92=>_("Commerce"), 106=>_("Currencies"), 98=>_("E-business"), 107=>_("Economy"), 
                  108=>_("EmergingMarkets"), 93=>_("Energy"),99=>_("Enterprise"), 109=>_("Finance"), 94=>_("HealthCare"), 101=>_("Infoimaging"),
                  110=>_("LawandTaxation"), 95=>_("Logistics"), 112=>_("Management"), 96=>_("Manufacturing"), 114=>_("PersonalFinance"), 115=>_("RealEstate"),
                  111=>_("SalesandMarketing"), 97=>_("Services"), 100=>_("Tech"), 102=>_("Wireless"));

/* update and location dropdown options */
$news_interval = array(0=>'No automatic updates', 2=>'Update with new headlines only',1=>'Random news for the last 24 hours.',
                       3=>'Random news for the last 48 hours.', 4=>'Random news for the last 7  days.');
$update_frequencies = array(60=>'1 minute', 300=>'5 minutes', 900=>'15 minutes', 1800=>'30 minutes');
$widget_position = array(0 => 'None', 1=>'Above folders', 2=>'Below folders');

/* get the user prefs */
$pref_position         = getPref($data_dir, $username, 'position');
$pref_topics           = getPref($data_dir, $username, 'rootly_topics');
$pref_update           = getPref($data_dir, $username, 'update');
$pref_update_frequency = getPref($data_dir, $username, 'update_frequency');
$keywords1             = getPref($data_dir, $username, 'keywords1');
$keywords2             = getPref($data_dir, $username, 'keywords2');
$keywords3             = getPref($data_dir, $username, 'keywords3');
$topics_array          = explode(",", $pref_topics);

/* default data for the template */
$notice = false;

/* check for update button */
if (sqgetGlobalVar('rootly_update', $form_submitted, SQ_FORM) && $form_submitted) {
    
    /* defaults in case submitted values are unacceptable */
    $topics_string = false;
    $topics = '';
    $position = 0;
    $update = 0;
    $update_frequency = 0;
    $keywords1 = '';
    $keywords2 = '';
    $keywords3 = '';

    /* check form */
    sqgetGlobalVar('topics', $topics, SQ_FORM);
    sqgetGlobalVar('position', $position, SQ_FORM);
    sqgetGlobalVar('update', $update, SQ_FORM);
    sqgetGlobalVar('update_frequency', $update_frequency, SQ_FORM);
    sqgetGlobalVar('keywords1', $keywords1, SQ_FORM);
    sqgetGlobalVar('keywords2', $keywords2, SQ_FORM);
    sqgetGlobalVar('keywords3', $keywords3, SQ_FORM);

    $pref_update = (int) $update;
    $pref_position = (int) $position;
    $pref_update_frequency = (int) $update_frequency;
    if (is_array($topics) && !empty($topics)) {
        $topics_string =  implode(",", $topics);
        $topics_array = $topics;
    }
    setPref($data_dir, $username, 'rootly_topics', $topics_string);
    setPref($data_dir, $username, 'keywords1', $keywords1);
    setPref($data_dir, $username, 'keywords2', $keywords2);
    setPref($data_dir, $username, 'keywords3', $keywords3);
    setPref($data_dir, $username, 'position', $pref_position);
    setPref($data_dir, $username, 'update', $pref_update);
    setPref($data_dir, $username, 'update_frequency', $pref_update_frequency);

    $notice = _("Settings Updated");
}

if (check_sm_version(1, 5, 2)) {
    global $oTemplate;
    $oTemplate->assign('color', $color);
    $oTemplate->assign('pref_position', $pref_position);
    $oTemplate->assign('pref_topics', $pref_topics);
    $oTemplate->assign('pref_update', $pref_update);
    $oTemplate->assign('pref_update_frequency', $pref_update_frequency);
    $oTemplate->assign('keywords1', htmlspecialchars($keywords1));
    $oTemplate->assign('keywords2', htmlspecialchars($keywords2));
    $oTemplate->assign('keywords3', htmlspecialchars($keywords3));
    $oTemplate->assign('topics_array', $topics_array);
    $oTemplate->assign('categories', $categories);
    $oTemplate->assign('notice', $notice);
    $oTemplate->assign('World', $World);
    $oTemplate->assign('Sports', $Sports);
    $oTemplate->assign('Technology', $Technology);
    $oTemplate->assign('Entertainment', $Entertainment);
    $oTemplate->assign('Science', $Science);
    $oTemplate->assign('Business', $Business);
    $oTemplate->assign('news_interval', $news_interval);
    $oTemplate->assign('update_frequencies', $update_frequencies);
    $oTemplate->assign('widget_position', $widget_position);
    $oTemplate->display('plugins/rootly_news/options.tpl');
    $oTemplate->display('footer.tpl');
}
else {
    $t = array();
    $keywords1 = htmlspecialchars($keywords1);
    $keywords2 = htmlspecialchars($keywords2);
    $keywords3 = htmlspecialchars($keywords3);
    include_once(SM_PATH . 'plugins/rootly_news/templates/default/options.tpl');
    echo '</body></html>';
}
