<?php

/**
  * SquirrelMail Rewrap Compose Text Plugin
  * Copyright (c) 2003-2004 Justus Pendleton <justus@ryoohki.net>
  * Copyright (c) 2008 Paul Lesniewski <paul@squirrelmail.org>
  * Licensed under the GNU GPL. For full terms see the file COPYING.
  *
  * @package plugins
  * @subpackage rewrap
  *
  */



/**
  * Register this plugin with SquirrelMail
  *
  */
function squirrelmail_plugin_init_rewrap()
{

   global $squirrelmail_plugin_hooks;


   // Include JavaScript that accomplishes the rewrap functionality
   //
   $squirrelmail_plugin_hooks['generic_header']['rewrap']
      = 'rewrap_add_script';


   // Add the "Rewrap" button to the compose screen (1.4.x)
   //
   $squirrelmail_plugin_hooks['compose_button_row']['rewrap']
      = 'rewrap_add_button';


   // Add the "Rewrap" button to the compose screen (1.5.x)
   //
   $squirrelmail_plugin_hooks ['template_construct_compose_buttons.tpl']['rewrap']
      = 'rewrap_add_button';

}



/**
  * Returns info about this plugin
  *
  */
function rewrap_info()
{

   return array(
                 'english_name' => 'Rewrap Compose Text',
                 'authors' => array(
                    'Justus Pendleton' => array(
                       'email' => 'justus@ryoohki.net',
                    ),
                    'Paul Lesniewski' => array(
                       'email' => 'paul@squirrelmail.org',
                       'sm_site_username' => 'pdontthink',
                    ),
                 ),
                 'version' => '1.3',
                 'required_sm_version' => '1.4.0',
                 'requires_configuration' => 0,
                 'requires_source_patch' => 0,
                 'summary' => 'Adds a button to the compose screen that reformats the message body text.',
                 'details' => 'This plugin adds a button to the compose screen which, when clicked, will reformat the message body text being edited.  The reformating respects citation markers and blank lines.  For example, when replying to an email that has lines like:<br /><br />> One line broken<br />> into two short lines.<br /><br />They will be transformed into one line as such:<br /><br />> One line broken into two short lines.',
                 'per_version_requirements' => array(
                    '1.5.2' => array(
                       'required_plugins' => array(),
                    ),
                    '1.5.0' => array(
                       'required_plugins' => array(
                          'compatibility' => array(
                             'version' => '2.0.7',
                             'activate' => FALSE,
                          )
                       )
                    ),
                    '1.4.10' => array(
                       'required_plugins' => array(),
                    ),
                    '1.4.0' => array(
                       'required_plugins' => array(
                          'compatibility' => array(
                             'version' => '2.0.7',
                             'activate' => FALSE,
                          )
                       )
                    ),
                 ),
               );

}



/**
  * Returns version info about this plugin
  *
  */
function rewrap_version()
{
   $info = rewrap_info();
   return $info['version'];
}



/**
  * Include JavaScript that accomplishes the rewrap functionality
  *
  */
function rewrap_add_script($args)
{
   include_once(SM_PATH . 'plugins/rewrap/functions.php');
   rewrap_add_script_do($args);
}



/**
  * Add the "Rewrap" button to the compose screen
  *
  */
function rewrap_add_button()
{
   include_once(SM_PATH . 'plugins/rewrap/functions.php');
   return rewrap_add_button_do();
}



