<?php /*

#
#   Sample sending restrictions table
#
#   One user or domain per line - usernames will be matched against
#   actual IMAP logins, domain will be matched against the current
#   domain that the user is logged in to (if usernames are full
#   email addresses, the two could indicate different domains, so
#   choose your restrictions appropriately).
#
#   A user is indicated by "user:", while a domain is indicated by
#   "domain:" (without quotes).  The user name or domain name should
#   follow, after which should be a list of allowable and unallowable
#   destinations.  This list should be separated from the user name 
#   or domain name by whitespace and should be formatted as such:
#
#      allow:domain1.com deny:user@domain2.com allow
#
#   That is, allowable destinations are prefixed with the text "allow:" 
#   and restricted destinations are prefixed with the text "deny:".  
#   The list should end with just the word "allow" or "deny", which 
#   indicates what to do with any destination that was not matched in 
#   the preceding list.  Order of the list is important; the first match
#   wins.  Please make sure that each list item is separated from
#   the other items by whitespace.
#
#   Also note that user names or domain names (as well as destination 
#   addresses) can contain the wildcards * and ? which indicate "any 
#   number of (or zero) characters" and "one alphanumeric character" 
#   respectively.  
#
#   For example, the username "jose_r*@domain.com" would match the 
#   username "jose_rodriguez@domain.com" as well as "jose_riviera@domain.com".  
#   "jose?@domain.com" would match "jose5@domain.com", but not 
#   "jose@domain.com", although the pattern "jose*@domain.com" would 
#   match both "jose5@domain.com" and "jose@domain.com".  
#
#   "domain.*" would match "domain.com", "domain.ca" as well as "domain.net", 
#   while "domain.??" would match "domain.ca" but not "domain.com" nor 
#   "domain.net".
#
#   Note that the order of usernames and domains listed herein is 
#   also significant; the first match wins.  If a particular user
#   has special send permissions/restrictions that are more detailed
#   than those of the rest of the domain's users, you should list
#   that user first.
#
#   Finally, the last line in the file should contain just "allow"
#   or "deny".  Any user that was not caught by the usernames and
#   domains listed herein will either be allowed to send or not,
#   depending on which word you place at the end of the file.
#   WARNING: if you do not specify anything here, "allow" is default,
#   which lets all mail through.
#
#   Some examples:
#   
#      Let jose@my.domain.net send email ONLY to my.domain.net:
#
#         user: jose@my.domain.net   allow:my.domain.net deny
#
#      Let all users logged in to my.domain.net send email to 
#      anywhere EXCEPT spam.domain.com and usa.com:
#
#         domain: my.domain.net   deny:spam.domain.com deny:usa.com allow
#
#      Don't let anyone with a username that includes "george" send any mail:
#
#         user: *george*   deny
#
#      Only allow mail to hasib@example.org and the "abuse" account 
#      at any domain for users in the domain tatoe.net:
#
#         domain: tatoe.net   allow:hasib@example.org allow:support@* deny
#
#      Allow a user called akiko to send mail only to domains that
#      start with "example.", such as example.com, exmaple.net,
#      example.co.uk, example.br, etc.:
#
#         user: akiko   allow:example.* deny
#
#      Let users logged into free.org, free.net, free.com (and whatever 
#      other "free" top level domains you might own) send to anyone:
#
#         domain: free.*   allow
#
#      Don't let any users starting with an "a" send mail to 
#      support@tatoe.org:
#
#         user: a*   deny:support@tatoe.org allow
#
#      Allow all other users of SquirrelMail to send mail freely
#
#         allow
#

## Please make sure to remove these examples when creating your own list!:
##
user: jose@my.domain.net   allow:my.domain.net deny
domain: my.domain.net      deny:spam.domain.com deny:usa.com allow
user: *george*             deny
domain: tatoe.net          allow:hasib@example.org allow:support@* deny
user: akiko                allow:example.* deny
domain: free.*             allow
user: a*                   deny:support@tatoe.org allow
allow



*/
