<?php

/**
  * SquirrelMail Restrict Senders Plugin
  * Copyright (c) 2004-2005 Paul Lesneiwski <pdontthink@angrynerds.com>
  * Licensed under the GNU GPL. For full terms see the file COPYING.
  *
  * @package plugins
  * @subpackage restrict_senders
  *
  */


/**
  * Register this plugin with SquirrelMail
  *
  */
function squirrelmail_plugin_init_restrict_senders() 
{

   global $squirrelmail_plugin_hooks;

   $squirrelmail_plugin_hooks['compose_send']['restrict_senders'] = 'check_restrict_senders';
   $squirrelmail_plugin_hooks['generic_header']['restrict_senders'] = 'display_error_on_compose_screen';

}



/** @ignore */
if (!defined('SM_PATH'))
   define('SM_PATH', '../');



/**
  * Returns version info about this plugin
  *
  */
function restrict_senders_version() 
{

   return '1.1';

}



/**
  * Displays any errors that blocked email from 
  * sending back on top of compose screen
  *
  */
function display_error_on_compose_screen() 
{

   include_once(SM_PATH . 'plugins/restrict_senders/functions.php');
   display_error_on_compose_screen_do();

}



/**
  * Checks send restrictions when sending an email
  *
  */
function check_restrict_senders(&$argv) 
{

   include_once(SM_PATH . 'plugins/restrict_senders/functions.php');
   return check_restrict_senders_do($argv);

}



?>
