<?php

// include compatibility plugin
//
if (defined('SM_PATH'))
   include_once(SM_PATH . 'plugins/compatibility/functions.php');
else if (file_exists('../plugins/compatibility/functions.php'))
   include_once('../plugins/compatibility/functions.php');
else if (file_exists('./plugins/compatibility/functions.php'))
   include_once('./plugins/compatibility/functions.php');



// display errors
//
function display_error_on_compose_screen_do()
{

   // get global variable for versions of PHP < 4.1
   //
   if (!compatibility_check_php_version(4,1)) {
      global $HTTP_SERVER_VARS;
      $_SERVER = $HTTP_SERVER_VARS;
   }


   // only want to do this on the compose page
   //
   if (stristr($_SERVER['SCRIPT_NAME'], 'compose.php'))
   {

      // error when all To: recipients are disallowed
      //
      global $restrict_senders_error_too_many_recipients, $color;
      compatibility_sqextractGlobalVar('restrict_senders_error_too_many_recipients');
      if ($restrict_senders_error_too_many_recipients)
      {

         // TODO: not sure if this will work with all
         // PHP versions, especially 4.3.x....
         //
         // Need to avoid endless loops (plain_error_message()
         // ends up calling to displayPageHeader(), which is
         // where the current hook call is located, so this 
         // code gets called recursively if we don't stop it
         // here...
         //
         include_once (SM_PATH . 'plugins/restrict_senders/data/config.php');
         global $countMe, $restrictNumberOfRecipients;
         if (!$countMe)
         {
            $countMe = 1;
            plain_error_message( _("Too Many Outgoing Recipients.  Please Limit Number Of Recipients To ") . $restrictNumberOfRecipients . '.', $color);
            return;
         }

      }


      // error when all To: recipients are disallowed
      //
      global $restrict_senders_error_no_to_recipients, $color;
      compatibility_sqextractGlobalVar('restrict_senders_error_no_to_recipients');
      if ($restrict_senders_error_no_to_recipients)
      {

         // TODO: not sure if this will work with all
         // PHP versions, especially 4.3.x....
         //
         // Need to avoid endless loops (plain_error_message()
         // ends up calling to displayPageHeader(), which is
         // where the current hook call is located, so this 
         // code gets called recursively if we don't stop it
         // here...
         //
         global $countMe;
         if (!$countMe)
         {
            $countMe = 1;
            plain_error_message( _("All recipients in the To: field are illegal destinations."), $color);
            return;
         }

      }

   }

}



// remove an array element (by numeric 
// index) and renumber the array
//
function unset_and_renumber_array($theArray, $index)
{

   $size = sizeof($theArray);

   for ($j = $index; $j < $size - 1; $j++)
      $theArray[$j] = $theArray[$j+1];

   unset($theArray[$size - 1]);

   return $theArray;

}



// parses a table that lists domains and/or users that are
// to be restricted to send only to certain domains 
//
function check_restrict_senders_do(&$argv)
{

   global $restrictDomains, $restrictNumberOfRecipients, 
          $restrict_sender_rules, $username, $domain, $blockedAddresses;


   include_once (SM_PATH . 'plugins/restrict_senders/data/config.php');


   // grab TO, CC, and BCC fields from message
   //
   $message = &$argv[1];
   $toDomains = array();
   $ccDomains = array();
   $bccDomains = array();

   // need to keep track of index values (so don't use
   // foreach) so we make sure to block the correct 
   // ones later on
   //
   for ($i = 0; $i < sizeof($message->rfc822_header->to); $i++)
      $toDomains[$i] = $message->rfc822_header->to[$i]->host;
   for ($i = 0; $i < sizeof($message->rfc822_header->cc); $i++)
      $ccDomains[$i] = $message->rfc822_header->cc[$i]->host;
   for ($i = 0; $i < sizeof($message->rfc822_header->bcc); $i++)
      $bccDomains[$i] = $message->rfc822_header->bcc[$i]->host;



   // limit number of outgoing recipients if necessary
   //
   if ($restrictNumberOfRecipients 
      && $restrictNumberOfRecipients < sizeof($toDomains) + sizeof($ccDomains) + sizeof($bccDomains))
   {

      global $color, $send_to, $send_to_cc, $send_to_bcc, $subject, $body,
             $variable_sent_folder;
      sqgetGlobalVar('variable_sent_folder', $variable_sent_folder);

      header('Location: ../src/compose.php?send_to=' . urlencode($send_to) 
         . '&send_to_cc=' . urlencode($send_to_cc) . '&send_to_bcc=' 
         . urlencode($send_to_bcc) . '&subject=' . urlencode($subject) 
         . '&restrict_senders_error_too_many_recipients=1&body=' . urlencode($body)
         . rs_buildQueryString('mailprio') . rs_buildQueryString('delete_draft') 
         . rs_buildQueryString('identity') 
         // doesn't pull default so just forget it! . rs_buildQueryString('variable_sent_folder') 
         . rs_buildQueryString('session') 
         // makes query string too big . rs_buildQueryString('restoremessages') 
         . rs_buildQueryString('request_mdn') . rs_buildQueryString('request_dr') 
         . rs_buildQueryString('passed_id') . rs_buildQueryString('custom_from') 
         . rs_buildQueryString('mailbox') . rs_buildQueryString('passed_ent_id') 
             // SM 1.2.x : reply_id and forward_id
         . rs_buildQueryString('startMessage') . rs_buildQueryString('reply_id') 
         . rs_buildQueryString('forward_id'));

      exit;

   }



   // limit send domains?
   //
   if (!$restrictDomains)
   {

      // check if the sent_confirmation plugin
      // is installed and if so, if it was delayed
      // in order for this plugin to run first
      //
      global $plugins;

      if (in_array('sent_confirmation', $plugins))
      {
         global $restrict_senders_finished, $sent_confirmation_was_delayed;

         $restrict_senders_finished = 1;

         if ($sent_confirmation_was_delayed)
            sent_conf_message_sent_do();

      }

      return;

   }



   // check if we've been here before - is the user's restrict
   // info already in the session?  if so, use it
   //
   compatibility_sqextractGlobalVar('restrict_sender_rules');



   // didn't find it in the session; parse it out of the data file
   //
   if (empty($restrict_sender_rules))
   {

      $restrict_sender_rules = parseSenderRules();

      // put it in the session
      //
      compatibility_sqsession_register($restrict_sender_rules, 'restrict_sender_rules');

   }
   

   // now find out which addresses are not allowable
   //
   list($toResults, $ccResults, $bccResults) 
         = filterAddresses($toDomains, $ccDomains, $bccDomains, $restrict_sender_rules);



   // eliminate disallowed addresses from message
   //
   // loop thru return results of filter function and call my custom func
   //
   $blockedAddresses = array();
   $badAddrs = 0;
   for ($i = 0; $i < sizeof($toResults); $i++)
      if (!$toResults[$i])
      {
         $blockedAddresses[] = $message->rfc822_header->to[$i - $badAddrs]->mailbox . '@'
                             . $message->rfc822_header->to[$i - $badAddrs]->host;
         $message->rfc822_header->to = unset_and_renumber_array($message->rfc822_header->to, 
                                                                $i - $badAddrs);
         $badAddrs++;
      }

   $badAddrs = 0;
   for ($i = 0; $i < sizeof($ccResults); $i++)
      if (!$ccResults[$i])
      {
         $blockedAddresses[] = $message->rfc822_header->cc[$i - $badAddrs]->mailbox . '@'
                             . $message->rfc822_header->cc[$i - $badAddrs]->host;
         $message->rfc822_header->cc = unset_and_renumber_array($message->rfc822_header->cc, 
                                                                $i - $badAddrs);
         $badAddrs++;
      }

   $badAddrs = 0;
   for ($i = 0; $i < sizeof($bccResults); $i++)
      if (!$bccResults[$i])
      {
         $blockedAddresses[] = $message->rfc822_header->bcc[$i - $badAddrs]->mailbox . '@'
                             . $message->rfc822_header->bcc[$i - $badAddrs]->host;
         $message->rfc822_header->bcc = unset_and_renumber_array($message->rfc822_header->bcc, 
                                                                $i - $badAddrs);
         $badAddrs++;
      }



   // check message for at least one address in the TO field
   //
   if (sizeof($message->rfc822_header->to) == 0)
   {
      global $color, $send_to, $send_to_cc, $send_to_bcc, $subject, $body,
             $variable_sent_folder;
      sqgetGlobalVar('variable_sent_folder', $variable_sent_folder);

      header('Location: ../src/compose.php?send_to=' . urlencode($send_to) 
         . '&send_to_cc=' . urlencode($send_to_cc) . '&send_to_bcc=' 
         . urlencode($send_to_bcc) . '&subject=' . urlencode($subject) 
         . '&restrict_senders_error_no_to_recipients=1&body=' . urlencode($body)
         . rs_buildQueryString('mailprio') . rs_buildQueryString('delete_draft') 
         . rs_buildQueryString('identity') 
         // doesn't pull default so just forget it! . rs_buildQueryString('variable_sent_folder') 
         . rs_buildQueryString('session') 
         // makes query string too big . rs_buildQueryString('restoremessages') 
         . rs_buildQueryString('request_mdn') . rs_buildQueryString('request_dr') 
         . rs_buildQueryString('passed_id') . rs_buildQueryString('custom_from') 
         . rs_buildQueryString('mailbox') . rs_buildQueryString('passed_ent_id') 
             // SM 1.2.x : reply_id and forward_id
         . rs_buildQueryString('startMessage') . rs_buildQueryString('reply_id') 
         . rs_buildQueryString('forward_id'));

      exit;
   }



   // put blocked addresses into session so they can be displayed
   // by sent_confirmation (or other)
   //
   compatibility_sqsession_register($blockedAddresses, 'blockedAddresses');



   // check if the sent_confirmation plugin
   // is installed and if so, if it was delayed
   // in order for this plugin to run first
   //
   global $plugins;

   if (in_array('sent_confirmation', $plugins))
   {
      global $restrict_senders_finished, $sent_confirmation_was_delayed;

      $restrict_senders_finished = 1;

      // sent_confirmation gets its information from the 
      // $send_to, $send_to_cc, and $send_to_bcc variables,
      // so as much of a pain as it is, we need to reset
      // them now
// TODO: doing this means we lose formatting of email addresses 
//       like "Joe Smith" <joe@smith.com>  and so forth.  It 
//       is harder, but we could parse up these variables in
//       the same way as we do the message itself above, in
//       order to preserve this formatting
      //
      global $send_to, $send_to_cc, $send_to_bcc;

      $send_to = '';
      for ($i = 0; $i < sizeof($message->rfc822_header->to); $i++)
      {
         if ($i > 0) $send_to .= ', ';
         $send_to .= $message->rfc822_header->to[$i]->mailbox . '@' . $message->rfc822_header->to[$i]->host;
      }


      $send_to_cc = '';
      for ($i = 0; $i < sizeof($message->rfc822_header->cc); $i++)
      {
         if ($i > 0) $send_to_cc .= ', ';
         $send_to_cc .= $message->rfc822_header->cc[$i]->mailbox . '@' . $message->rfc822_header->cc[$i]->host;
      }


      $send_to_bcc = '';
      for ($i = 0; $i < sizeof($message->rfc822_header->bcc); $i++)
      {
         if ($i > 0) $send_to_bcc .= ', ';
         $send_to_bcc .= $message->rfc822_header->bcc[$i]->mailbox . '@' . $message->rfc822_header->bcc[$i]->host;
      }


      if ($sent_confirmation_was_delayed)
         sent_conf_message_sent_do();

   }



   // return the message
   //
   return $message;


}



// build up location string
// note that it always prepends & and
// thus won't work for the first item
// in the query string
//
// the variable will be renamed in the
// query string if $queryName is given
//
function rs_buildQueryString($varName, $queryName = '')
{
   global $$varName;
   ////if (isset($$varName))
   if (isset($$varName) && !empty($$varName))
      return '&' . (!empty($queryName) ? $queryName : $varName) . '=' . $$varName;
   else
      return '';
}



// returns sender rules for the current user
//
function parseSenderRules()
{

   global $username, $domain;

   $lineNo = 0;


   if ($RESTRICTTABLE = @fopen (SM_PATH . 'plugins/restrict_senders/data/send_restrictions.dat', 'r'))
   {

      while (!feof($RESTRICTTABLE))
      {

         $line = fgets($RESTRICTTABLE, 4096);
         $line = trim($line);
         $lineNo++;


         // skip blank lines and comment lines
         //
         if (strpos($line, '#') === 0 || strlen($line) < 3)
            continue;


         // is this a domain line?
         //
         if (preg_match('/^\s*domain:\s*(\S+)\s+(.*)$/', $line, $matches))
         {

            // check for match with hostname, return restrictions if so
            //
            if (preg_match('/^' . str_replace(array('?', '*'), array('\w{1}', '.*?'), 
                          strtoupper($matches[1])) . '$/', strtoupper($domain)))
            {
               fclose($RESTRICTTABLE);
               return $matches[2];
            }

         }


         // is this a user line?
         //
         else if (preg_match('/^\s*user:\s*(\S+)\s+(.*)$/', $line, $matches))
         {

            // check for match with username, return restrictions if so
            //
            if (preg_match('/^' . str_replace(array('?', '*'), array('\w{1}', '.*?'), 
                          strtoupper($matches[1])) . '$/', strtoupper($username)))
            {
               fclose($RESTRICTTABLE);
               return $matches[2];
            }

         }


         // is this a catchall line?
         //
         else if (preg_match('/^\s*(allow|deny)\s*$/', $line, $matches))
         {

            // just return the restriction
            //
            fclose($RESTRICTTABLE);
            return $matches[1];

         }


         // line format not understood
         //
         else
         {

            global $color;
            plain_error_message( '"<b>restrict_senders</b>" ' . _("plugin is not configured correctly.") . '<br />' . _("Error on data/send_restrictions.dat line number ") . $lineNo . '<br /><center>' . _("Message not sent") . '</center>', $color);
            exit;
////////////      plain_error_message(_("The") . ' "<b>restrict_send</b>" ' . _("plugin has not been set up correctly.") . '<br />' . _("actual error message here.....") . '<br />' . _("advice to read instructions here......"), $color);

         }

      }


      // nothing found, so allow everything
      //
      fclose($RESTRICTTABLE);
      return 'allow';

   }
   else
   {

      global $color;
      plain_error_message( '"<b>restrict_senders</b>" ' . _("plugin could not open its restriction table") . '<br /><center>' . _("Message not sent") . '</center>', $color);
      exit;
////////////      plain_error_message(_("The") . ' "<b>restrict_send</b>" ' . _("plugin has not been set up correctly.") . '<br />' . _("actual error message here.....") . '<br />' . _("advice to read instructions here......"), $color);

   }

}



// figures out which addresses are OK, 
// which are bad based on the provided rules
//
function filterAddresses($toDomains, $ccDomains, $bccDomains, $restrict_sender_rules)
{

   $theRules = preg_split('/\s+/', $restrict_sender_rules);
   $toResults = array();
   $ccResults = array();
   $bccResults = array();


   // loop thru TO: domains
   // 
   for ($i = 0; $i < sizeof($toDomains); $i++)
   {


      // loop thru each rule
      //
      for ($j = 0; $j < sizeof($theRules); $j++)
      {

         if ($theRules[$j] == 'allow') 
         {
            $toResults[$i] = 1;
            continue 2;
         }
         else if ($theRules[$j] == 'deny') 
         {
            $toResults[$i] = 0;
            continue 2;
         }
         else if (preg_match('/(allow|deny):' . $toDomains[$i] . '/', $theRules[$j], $matches))
         {
            $toResults[$i] = ($matches[1] == 'allow' ? 1 : 0);
            continue 2;
         }

      }

   }



   // loop thru CC: domains
   // 
   for ($i = 0; $i < sizeof($ccDomains); $i++)
   {


      // loop thru each rule
      //
      for ($j = 0; $j < sizeof($theRules); $j++)
      {

         if ($theRules[$j] == 'allow') 
         {
            $ccResults[$i] = 1;
            continue 2;
         }
         else if ($theRules[$j] == 'deny') 
         {
            $ccResults[$i] = 0;
            continue 2;
         }
         else if (preg_match('/(allow|deny):' . $ccDomains[$i] . '/', $theRules[$j], $matches))
         {
            $ccResults[$i] = ($matches[1] == 'allow' ? 1 : 0);
            continue 2;
         }

      }

   }



   // loop thru BCC: domains
   // 
   for ($i = 0; $i < sizeof($bccDomains); $i++)
   {


      // loop thru each rule
      //
      for ($j = 0; $j < sizeof($theRules); $j++)
      {

         if ($theRules[$j] == 'allow') 
         {
            $bccResults[$i] = 1;
            continue 2;
         }
         else if ($theRules[$j] == 'deny') 
         {
            $bccResults[$i] = 0;
            continue 2;
         }
         else if (preg_match('/(allow|deny):' . $bccDomains[$i] . '/', $theRules[$j], $matches))
         {
            $bccResults[$i] = ($matches[1] == 'allow' ? 1 : 0);
            continue 2;
         }

      }

   }


   // return results
   //
   return array($toResults, $ccResults, $bccResults);

}



?>
