<?php


/**
  * SquirrelMail Reply Button Plugin
  * Copyright (c) 2005 Paul Lesneiwski <pdontthink@angrynerds.com>
  * Licensed under the GNU GPL. For full terms see the file COPYING.
  *
  * @package plugins
  * @subpackage reply_buttons
  *
  */


/**
  * Register this plugin with SquirrelMail
  *
  */
function squirrelmail_plugin_init_reply_buttons()
{

   global $squirrelmail_plugin_hooks;

   $squirrelmail_plugin_hooks['mailbox_display_buttons']['reply_buttons']  = 'rb_mailbox_list_buttons';
   $squirrelmail_plugin_hooks['move_before_move']['reply_buttons']  = 'rb_reply_action_14';
   $squirrelmail_plugin_hooks['generic_header']['reply_buttons']  = 'rb_reply_action_15';
   $squirrelmail_plugin_hooks['optpage_loadhook_display']['reply_buttons'] = 'rb_show_options';

}


/** @ignore */
if (!defined('SM_PATH'))
   define('SM_PATH', '../');



/**
  * Returns version info about this plugin
  *
  */
function reply_buttons_version()
{
   return '1.0';
}



/**
  * Adds reply button to mailbox listing
  *
  */
function rb_mailbox_list_buttons()
{

   include_once(SM_PATH . 'plugins/reply_buttons/functions.php');
   rb_mailbox_list_buttons_do();

}



/**
  * Redirects to compose page when button was pressed for
  * SquirrelMail 1.5.x and above
  *
  */
function rb_reply_action_15()
{

   include_once(SM_PATH . 'plugins/reply_buttons/functions.php');
   rb_reply_action_15_do();

}



/**
  * Redirects to compose page when button was pressed for
  * SquirrelMail 1.4.x and below
  *
  */
function rb_reply_action_14()
{

   include_once(SM_PATH . 'plugins/reply_buttons/functions.php');
   rb_reply_action_14_do();

}



/**
  * Build user options for display on "Display Preferences" page
  *
  */
function rb_show_options()
{

   include_once(SM_PATH . 'plugins/reply_buttons/functions.php');
   rb_show_options_do();

}



?>
