<?php

   // include compatibility plugin
   //
   if (defined('SM_PATH'))
      include_once(SM_PATH . 'plugins/compatibility/functions.php');
   else if (file_exists('../plugins/compatibility/functions.php'))
      include_once('../plugins/compatibility/functions.php');
   else if (file_exists('./plugins/compatibility/functions.php'))
      include_once('./plugins/compatibility/functions.php');



// This is the text that appears on the option page
//
function quicksave_options() {

    global $username, $data_dir, $javascript_on;

    $frequency = getPref($data_dir, $username, 'quicksave_frequency', '1');
    $units = getPref($data_dir, $username, 'quicksave_units', 'seconds');
    $encryption = getPref($data_dir, $username, 'quicksave_encryption', 'none');

    echo "<TR><TD COLSPAN=\"2\">&nbsp;</TD></TR>\n"
       . "<TR><TD ALIGN=CENTER VALIGN=MIDDLE COLSPAN=2 NOWRAP><B>"
       . _("QuickSave Auto Message Save and Recovery") . "</B></TD></TR>\n"
       . "<tr><td align=right valign=top>\n".
         _("Message Save Frequency:<br>(set to zero to turn off)") . "</td>\n".
         "<td><input type='text' name='quicksave_frequency' size='3' value='". $frequency;
    if ($javascript_on) 
       echo "' onChange='a=this.value; b=\"\"; for (i=0;i<a.length;i++) { if (a.charAt(i)>=\"0\" && a.charAt(i)<=\"9\") b += a.charAt(i); } this.value=b;";
    echo "'>\n".
         "<input type='radio' value='seconds' name='quicksave_units' ";
    if ($units == 'seconds') echo "CHECKED";
    echo ">" . _("seconds") . "\n".
         "<input type='radio' value='miliseconds' name='quicksave_units' ";
    if ($units == 'miliseconds') echo "CHECKED";
    echo ">" . _("miliseconds") . "\n".
         "</td></tr>\n";
    echo "<tr><td align=right valign=top>\n".
         _("Cookie Encryption Level:") . "</td>\n".
         "<td><input type='radio' value='none' name='quicksave_encryption' ";
    if ($encryption == 'none') echo "CHECKED";
    echo ">" . _("none") . "\n".
         "<input type='radio' value='low' name='quicksave_encryption' ";
    if ($encryption == 'low') echo "CHECKED";
    echo ">" . _("low") . "\n".
         "<input type='radio' value='medium' name='quicksave_encryption' ";
    if ($encryption == 'medium') echo "CHECKED";
    echo ">" . _("medium") . "\n".
         "<input type='radio' value='moderate' name='quicksave_encryption' ";
    if ($encryption == 'moderate') echo "CHECKED";
    echo ">" . _("moderate") . "\n".
         "</td></tr>\n";


}



// Very simple place to indicate that the message was sent
//
function quicksave_message_sent_do() {

   compatibility_sqsession_register('sent', 'quicksave_message_sent_status');

}



// Here we save the user's quicksave preferences
//
function quicksave_options_save() {

      global $data_dir, $username, $quicksave_frequency, $quicksave_units, $quicksave_encryption;

      compatibility_sqextractGlobalVar('quicksave_frequency');
      compatibility_sqextractGlobalVar('quicksave_units');
      compatibility_sqextractGlobalVar('quicksave_encryption');

      setPref($data_dir, $username, 'quicksave_frequency', $quicksave_frequency);
      setPref($data_dir, $username, 'quicksave_units', $quicksave_units);
      setPref($data_dir, $username, 'quicksave_encryption', $quicksave_encryption);

}



// turn off quicksave active status if flag is set
//
function quicksave_turn_off() {

    global $quicksave_message_sent_status, $username;
    compatibility_sqextractGlobalVar('quicksave_message_sent_status');
    $qs_username = preg_replace('/[\.@_]/', '', $username);
    if (isset($quicksave_message_sent_status) && $quicksave_message_sent_status == 'sent')
    {

?>

<script type="text/javascript" language="javascript">
<!--

     function QuickSave_left_frame_exists()
     {
              // this checks to make sure the left frame has loaded...
             var quicksave_exists = false;

             if ( parent.left && parent.left.document.forms )
             {
                     for ( var i = 0 ; i < parent.left.document.forms.length ; i++ )
                     {
                             if ( parent.left.document.forms[i].name == "quicksave" )
                             {
                                     quicksave_exists = true;
                             }
                     }
             }

             return quicksave_exists;

     }


     // -- Previous Message Was Sent; Deactivate QuickSave Cookie --
     if ( QuickSave_left_frame_exists() )
         parent.left.document.quicksave.is_active.value = "0"
     document.cookie = escape("QS<?php echo $qs_username ?>") + "is_active=0; expires=Thu, 01-Jan-70 00:00:01 GMT";

//-->
</script>

<?php

        $quicksave_message_sent_status = 'not_sent';
        compatibility_sqsession_register($quicksave_message_sent_status, 'quicksave_message_sent_status');

    }

}



// this is where we store all the information for retrieval using the
// form as the storage mechanism.. I imagine there are better ways to do this,
// but I'll be darned if I know what they are
function quicksave_build_form()
{

?>

        <!-- start -- QuickSave plugin -->
<form name="quicksave">
        <input type="hidden" value="" name="send_to">
        <input type="hidden" value="" name="send_to_cc">
        <input type="hidden" value="" name="send_to_bcc">
        <input type="hidden" value="" name="subject">
        <input type="hidden" value="" name="body">
        <input type="hidden" value="0" name="is_active">
</form>
        <!-- end -- QuickSave plugin -->

<?php

} // end quicksave_build_form() function




 // this is where we put the 'cancel' button, if they have javascript.
 // otherwise, they can't use this plugin, so there's no reason to show it
function build_quicksave_cancel_button()
{

        // we need this to send us back to the right mailbox or message ;)
        global $mailbox, $sort, $reply_id, $forward_id, $compose_new_win;

        // if they're composing in a new window...
        if ( $compose_new_win == '1' ) {
                $quick_save_return_url = '::CLOSE::';
        }
        // if they're forwarding an email...
        elseif ( $forward_id > 0 )
        {
                $quick_save_return_url = 'read_body.php'
                        . '?passed_id=' . $forward_id
                        . '&sort=' . $sort
                        . '&startMessage=1'
                        . '&mailbox=' . htmlspecialchars($mailbox)
                        . '&show_more=0';
        }
        // or if they're replyinging to an email...
        elseif ( $reply_id > 0 )
        {
                $quick_save_return_url = 'read_body.php'
                        . '?passed_id=' . $reply_id
                        . '&sort=' . $sort
                        . '&startMessage=1'
                        . '&mailbox=' . htmlspecialchars($mailbox)
                        . '&show_more=0';
        }
        // or if they're just composing from anywhere else, we return to the list
        else
        {
                $quick_save_return_url = 'right_main.php'
                        . '?use_mailbox_cache=0'
                        . '&sort=' . $sort
                        . '&startMessage=1'
                        . '&mailbox=' . htmlspecialchars($mailbox);
        }

?>

<script language=Javascript>
<!--
document.write("<input type=\"button\" name=\"QScancel\" value=\"<?php echo _("Cancel"); ?>\" onClick=\"QuickSave_cancel_button('<?php echo $quick_save_return_url; ?>');\">");
//-->
</script>

<?php

} // end build_quicksave_cancel_button() function



// basically, this is the meat of the code.
// Currently it adds an extra 8.5k to this page's download time.
// That needs to be trimmed back A LOT
//
function quicksave_compose_functions()
{

    global $quicksave_cookie_days, $quicksave_cookie_hours, $quicksave_cookie_minutes;
    global $maxCookieLength, $maxCookies, $useMultipleCookies, $maxSingleCookieLength;
    global $username, $data_dir;
    $qs_username = preg_replace('/[\.@_]/', '', $username);

    if (compatibility_check_sm_version(1, 3))
       include_once(SM_PATH . 'plugins/quicksave/config.php');
    else
       include_once('../plugins/quicksave/config.php');

    $encryption = getPref($data_dir, $username, 'quicksave_encryption', 'none');

?>

	<!-- start -- QuickSave plugin -->


<form name="QSstopsign">
	<input type="hidden" name="mailsent" value="0">
</form>

<script language=Javascript>
<!--


var maxSingleCookieLength = <?php echo $maxSingleCookieLength ?>;
var maxCookieLength = <?php echo $maxCookieLength ?>;
var maxCookies = <?php echo $maxCookies ?>;



function QuickSave_left_frame_exists()
{
	 // this checks to make sure the left frame has loaded...
	var quicksave_exists = false;

	if ( parent.left && parent.left.document.forms )
	{
		for ( var i = 0 ; i < parent.left.document.forms.length ; i++ )
		{
			if ( parent.left.document.forms[i].name == "quicksave" )
			{
				quicksave_exists = true;
			}
		}
	}

	return quicksave_exists;

}


<?php


   global $compose_new_win, $mail_sent;
   compatibility_sqextractGlobalVar('mail_sent');

   // if they're composing in a new window or have otherwise just
   // sent a message and come back to the compose screen instead
   // of the message index, need to check if message had been sent 
   if ( $compose_new_win == '1' || (isset($mail_sent) && $mail_sent == 'yes'))
   {

      global $quicksave_message_sent_status;
      compatibility_sqextractGlobalVar('quicksave_message_sent_status');
      if (isset($quicksave_message_sent_status) && $quicksave_message_sent_status == 'sent')
      {

?>

   // -- Previous Message Was Sent; Deactivate QuickSave Cookie --
   if ( QuickSave_left_frame_exists() )
      parent.left.document.quicksave.is_active.value = "0"
   document.cookie = escape("QS<?php echo $qs_username ?>") + "is_active=0; expires=Thu, 01-Jan-70 00:00:01 GMT";

<?php

         $quicksave_message_sent_status = 'not_sent';
         compatibility_sqsession_register($quicksave_message_sent_status, 'quicksave_message_sent_status');

      }
   }

?>


function QuickSave_swap(from_form, to_form, write_empty)
{
	if ( !from_form )
		from_form = document.compose;
	if ( !to_form && QuickSave_left_frame_exists() )
		to_form = parent.left.document.quicksave;

	 // gotta make sure we haven't posted already
	if ( document.QSstopsign.mailsent && document.QSstopsign.mailsent.value == 0 )
	{

		 // this is the form-based storage system
		if ( QuickSave_left_frame_exists() && from_form && to_form )
		{
			if ( from_form.send_to && to_form.send_to )
				if ( from_form.send_to.value.length >= 1 || write_empty == 1 )
					to_form.send_to.value = from_form.send_to.value;
			if ( from_form.send_to_cc && to_form.send_to_cc )
				if ( from_form.send_to_cc.value.length >= 1 || write_empty == 1 )
					to_form.send_to_cc.value = from_form.send_to_cc.value;
			if ( from_form.send_to_bcc && to_form.send_to_bcc )
				if ( from_form.send_to_bcc.value.length >= 1 || write_empty == 1 )
					to_form.send_to_bcc.value = from_form.send_to_bcc.value;
			if ( from_form.subject && to_form.subject )
				if ( from_form.subject.value.length >= 1 || write_empty == 1 )
					to_form.subject.value = from_form.subject.value;
			if ( from_form.body && to_form.body )
				if ( from_form.body.value.length >= 1 || write_empty == 1 )
					to_form.body.value = from_form.body.value;
		}

	 	
                var expiration = new Date();
                expiration.setTime(expiration.getTime() + (<?php
                        echo ($quicksave_cookie_days * 24 * 60 * 60 * 1000)
                                . ' + ' . ($quicksave_cookie_hours * 60 * 60 * 1000)
                                . ' + ' . ($quicksave_cookie_minutes * 60 * 1000) ?>));


	 	// this is the cookie-based storage system, which really takes precedence
		if ( document.compose.send_to )
  <?php 
        if ($encryption == 'none') {
           ?>
			QuickSave_cookie_shove("send_to=" + escape(document.compose.send_to.value), expiration);
		if ( document.compose.send_to_cc )
			QuickSave_cookie_shove("send_to_cc=" + escape(document.compose.send_to_cc.value), expiration);
		if ( document.compose.send_to_bcc )
			QuickSave_cookie_shove("send_to_bcc=" + escape(document.compose.send_to_bcc.value), expiration);
		if ( document.compose.subject )
			QuickSave_cookie_shove("subject=" + escape(document.compose.subject.value), expiration);
		if ( document.compose.body )
			QuickSave_cookie_shove("body=" + escape(document.compose.body.value), expiration);
           <?php
        } else {
           ?>
			QuickSave_cookie_shove("send_to=" + QuickSave_encrypt(escape(document.compose.send_to.value)), expiration);
		if ( document.compose.send_to_cc )
			QuickSave_cookie_shove("send_to_cc=" + QuickSave_encrypt(escape(document.compose.send_to_cc.value)), expiration);
		if ( document.compose.send_to_bcc )
			QuickSave_cookie_shove("send_to_bcc=" + QuickSave_encrypt(escape(document.compose.send_to_bcc.value)), expiration);
		if ( document.compose.subject )
			QuickSave_cookie_shove("subject=" + QuickSave_encrypt(escape(document.compose.subject.value)), expiration);
		if ( document.compose.body )
			QuickSave_cookie_shove("body=" + QuickSave_encrypt(escape(document.compose.body.value)), expiration);
           <?php
        }
  ?>
	 	
		QuickSave_activate(true, expiration);
	}
	return true;
} // end QuickSave_swap()

function QuickSave_activate(do_we_save, expiration)
{
	if ( do_we_save )
	{
		if ( QuickSave_left_frame_exists() )
			parent.left.document.quicksave.is_active.value = 1;
		QuickSave_cookie_shove("is_active=1", expiration);
	}
	else
	{
		document.QSstopsign.mailsent.value = 1;
		QuickSave_clear_storage();
	}
	return true;
} // end QuickSave_activate()

function QuickSave_cancel_button(message_list)
{

	if ( message_list )
	{
		document.QSstopsign.mailsent.value = 1;
		QuickSave_clear_storage();
		if ( message_list == "::CLOSE::" )
		{
			return window.close();
		}
		else
		{
			document.location = message_list;
		}
	}

	return true;

} // end QuickSave_cancel_button

function QuickSave_clear_storage()
{

	if ( QuickSave_left_frame_exists() )
	{
		var storage = parent.left.document.quicksave;
		storage.is_active.value = "0";
		storage.send_to.value = "";
		storage.send_to_cc.value = "";
		storage.send_to_bcc.value = "";
		storage.subject.value = "";
		storage.body.value = "";
	} // if this fails, it's not a problem cause there wasn't anything there anyway
	
	QuickSave_cookie_shove("is_active=0; expires=Thu, 01-Jan-70 00:00:01 GMT");
	QuickSave_cookie_shove("send_to=; expires=Thu, 01-Jan-70 00:00:01 GMT");
	QuickSave_cookie_shove("send_to_cc=; expires=Thu, 01-Jan-70 00:00:01 GMT");
	QuickSave_cookie_shove("send_to_bcc=; expires=Thu, 01-Jan-70 00:00:01 GMT");
	QuickSave_cookie_shove("subject=; expires=Thu, 01-Jan-70 00:00:01 GMT");
	QuickSave_cookie_shove("body=; expires=Thu, 01-Jan-70 00:00:01 GMT");
	
	return true;
} // end QuickSave_clear_storage()


<?php

   if (!$useMultipleCookies)
   {

?>


// ##########
// original shove function without size compensation
// ##########
//cookie_value == "subject=0" || cookie_value == "body0; expires Thu, 01-Jan-70 00:00:01 GMT"
function QuickSave_cookie_shove(cookie_value, expiration)
{

        // put an expiration on if not specified; value is
        // configurable by sysadmin
        if (cookie_value.indexOf("expires") == -1)
        {
                cookie_value = cookie_value + "; expires=" + expiration.toGMTString();
        }


	cookieData = cookie_value.substring(cookie_value.indexOf("=") + 1, cookie_value.indexOf(";"));


	if (cookieData.length > maxSingleCookieLength)
	{
		cookieName = cookie_value.substring(0, cookie_value.indexOf("="));
        	cookieInfo = cookie_value.substring(cookie_value.indexOf(";") + 1);
		cookie_value = cookieName + "=" + cookieData.substring(0, maxSingleCookieLength) 
			+ ";" + cookieInfo;
	}

	document.cookie = escape("QS<?php echo $qs_username?>") + cookie_value;

} // end QuickSave_cookie_shove




// ##########
// original pull function without size compensation
// ##########
 // much of this here function(QS_cookie_pull) was ripped from javascript.com
function QuickSave_cookie_pull(var_name)
{
        var cookie_str = document.cookie;

        // we tack on 'QS' plus username here to keep from having GPC orders
        // interefere with Squirrel's regular functioning
        //
        var prefix = escape("QS<?php echo $qs_username ?>") + var_name + "=";
        var begin = cookie_str.indexOf("; " + prefix);
        if (begin == -1)
        {
                begin = cookie_str.indexOf(prefix);
                if (begin != 0)
                        return null;
        }
        else
        {
            begin += 2;
        }
        var end = document.cookie.indexOf(";", begin);
        if (end == -1)
    end = cookie_str.length;
        return unescape(cookie_str.substring(begin + prefix.length, end));
} // end QuickSave_cookie_pull()



<?php
 
    }
    else
    {

?>

function QuickSave_cookie_shove(cookie_value, expiration)
{

	// put an expiration on if not specified; value is 
	// configurable by sysadmin
	//
	if (cookie_value.indexOf("expires") == -1)
	{
		cookie_value = cookie_value + "; expires=" + expiration.toGMTString();
	}



	// anything that isn't "body" gets written as usual
	//
        cookieName = cookie_value.substring(0, cookie_value.indexOf("="));
        cookieData = cookie_value.substring(cookie_value.indexOf("=") + 1, cookie_value.indexOf(";"));
	if (cookieName != "body")
	{
		if (cookieData.length > maxSingleCookieLength)
		{
        		cookieInfo = cookie_value.substring(cookie_value.indexOf(";") + 1);
			cookie_value = cookieName + "=" + cookieData.substring(0, maxSingleCookieLength) 
				+ ";" + cookieInfo;
		}
		document.cookie = escape("QS<?php echo $qs_username?>") + cookie_value;
		return;
	}



	// cookies small enough just get written
	//
	if (cookieData.length <= maxCookieLength)
	{
		document.cookie = escape("QS<?php echo $qs_username; ?>") + cookie_value;
		document.cookie = escape("QS<?php echo $qs_username; ?>") + 
			cookieName + "1=; expires=Thu, 01-Jan-70 00:00:01 GMT";
// too time consuming... locks up browser
//		for (i = 1; i <= maxCookies; i++)
//		{
//			document.cookie = escape("QS<?php echo $qs_username; ?>") + 
//				cookieName + i + "=; expires=Thu, 01-Jan-70 00:00:01 GMT";
//		}
		return;
	}



	// limit size of each cookie
	//
        cookieInfo = cookie_value.substring(cookie_value.indexOf(";") + 1);
	cookieCount = 1;

	// clear nonsuffixed cookie
	//
	document.cookie = escape("QS<?php echo $qs_username; ?>") + cookieName
		+ "=; expires=Thu, 01-Jan-70 00:00:01 GMT";

	while (cookieData.length > maxCookieLength && cookieCount < maxCookies)
	{
		document.cookie = escape("QS<?php echo $qs_username; ?>") + cookieName 
			+ (cookieCount++) + "=" + cookieData.substring(0, maxCookieLength) + "; " + cookieInfo;
		cookieData = cookieData.substring(maxCookieLength);
	}
	document.cookie = escape("QS<?php echo $qs_username; ?>") + cookieName 
		+ cookieCount + "=" + cookieData.substring(0, maxCookieLength) + "; " + cookieInfo;
	document.cookie = escape("QS<?php echo $qs_username; ?>") + 
		cookieName + (cookieCount + 1) + "=; expires=Thu, 01-Jan-70 00:00:01 GMT";
// too time consuming... locks up browser
//	for (i = cookieCount + 1; i <= maxCookies; i++)
//	{
//		document.cookie = escape("QS<?php echo $qs_username; ?>") + 
//			cookieName + i + "=; expires=Thu, 01-Jan-70 00:00:01 GMT";
//	}
	


} // end QuickSave_cookie_shove



function QuickSave_multi_cookie_pull(var_name)
{
        var cookie_str = document.cookie;

        // we tack on 'QS' plus username here to keep from having GPC orders
        // interefere with Squirrel's regular functioning
        //
        var prefix = escape("QS<?php echo $qs_username ?>") + var_name + "=";
        var begin = cookie_str.indexOf("; " + prefix);
        if (begin == -1)
        {
                begin = cookie_str.indexOf(prefix);
                if (begin != 0)
                        return null;
        }
        else
        {
            begin += 2;
        }
        var end = document.cookie.indexOf(";", begin);
        if (end == -1)
    end = cookie_str.length;
        return unescape(cookie_str.substring(begin + prefix.length, end));
} // end QuickSave_multi_cookie_pull()



function QuickSave_cookie_pull(var_name)
{

	var cookie_value = QuickSave_multi_cookie_pull(var_name);

	if (cookie_value == null || cookie_value == '')
	{

		var cookieCount = 1;
		cookie_value = "";

		var cookie_crumb = QuickSave_multi_cookie_pull(var_name + cookieCount);

		while (cookie_crumb != null && cookie_crumb != '')
		{

			cookie_value += cookie_crumb;
			cookie_crumb = QuickSave_multi_cookie_pull(var_name + (++cookieCount));

		}

	}

	if (cookie_value == "")
		return null;

	return cookie_value;

}


<?php

    }
    if ($encryption == 'moderate')
    {

?>

// pretty good XOR encryption (but in NO way uncrackable) script
// taken from javascript.com:  http://javascript.internet.com/passwords/xor-encryption4.html
// Copyright 2001 by Terry Yuen.
// Email: kaiser40@yahoo.com
// Last update: July 15, 2001
//
// Encrypts a given string
//
function QuickSave_encrypt(str)
{
  pwd = '<?php global $username; echo $username; ?>';
  if(pwd == null || pwd.length <= 0) {
    alert('<?php echo _("QuickSave Error - No encryption password given.  Please contact your system administrator."); ?>');
    return null;
  }
  var prand = "";
  for(var i=0; i<pwd.length; i++) {
    prand += pwd.charCodeAt(i).toString();
  }
  var sPos = Math.floor(prand.length / 5);
  var mult = parseInt(prand.charAt(sPos) + prand.charAt(sPos*2) + prand.charAt(sPos*3) + prand.charAt(sPos*4) + prand.charAt(sPos*5));
  var incr = Math.ceil(pwd.length / 2);
  var modu = Math.pow(2, 31) - 1;
  if(mult < 2) {
    alert('<?php echo _("QuickSave Error - Algorithm cannot find a suitable hash; bad password.\\nPlease contact your system administrator."); ?>');
    return null;
  }
  var salt = Math.round(Math.random() * 1000000000) % 100000000;
  prand += salt;
  while(prand.length > 10) {
    prand = (parseInt(prand.substring(0, 10)) + parseInt(prand.substring(10, prand.length))).toString();
  }
  prand = (mult * prand + incr) % modu;
  var enc_chr = "";
  var enc_str = "";
  for(var i=0; i<str.length; i++) {
    enc_chr = parseInt(str.charCodeAt(i) ^ Math.floor((prand / modu) * 255));
    if(enc_chr < 16) {
      enc_str += "0" + enc_chr.toString(16);
    } else enc_str += enc_chr.toString(16);
    prand = (mult * prand + incr) % modu;
  }
  salt = salt.toString(16);
  while(salt.length < 8)salt = "0" + salt;
  enc_str += salt;
  return enc_str;
}



// pretty good XOR encryption (but in NO way uncrackable) script
// taken from javascript.com:  http://javascript.internet.com/passwords/xor-encryption4.html
// Copyright 2001 by Terry Yuen.
// Email: kaiser40@yahoo.com
// Last update: July 15, 2001
//
// Decrypts a given string
//
function QuickSave_decrypt(str)
{
  pwd = '<?php global $username; echo $username; ?>';
  if(str == null || str.length < 8) {
    alert('<?php echo _("QuickSave Error - A salt value could not be extracted from the encrypted message\\nbecause it\'s length is too short.  The message cannot be decrypted.\\nPlease contact your system administrator."); ?>');
    return;
  }
  if(pwd == null || pwd.length <= 0) {
    alert('<?php echo _("QuickSave Error - No decryption password given.  Please contact your system administrator."); ?>');
    return;
  }
  var prand = "";
  for(var i=0; i<pwd.length; i++) {
    prand += pwd.charCodeAt(i).toString();
  }
  var sPos = Math.floor(prand.length / 5);
  var mult = parseInt(prand.charAt(sPos) + prand.charAt(sPos*2) + prand.charAt(sPos*3) + prand.charAt(sPos*4) + prand.charAt(sPos*5));
  var incr = Math.round(pwd.length / 2);
  var modu = Math.pow(2, 31) - 1;
  var salt = parseInt(str.substring(str.length - 8, str.length), 16);
  str = str.substring(0, str.length - 8);
  prand += salt;
  while(prand.length > 10) {
    prand = (parseInt(prand.substring(0, 10)) + parseInt(prand.substring(10, prand.length))).toString();
  }
  prand = (mult * prand + incr) % modu;
  var enc_chr = "";
  var enc_str = "";
  for(var i=0; i<str.length; i+=2) {
    enc_chr = parseInt(parseInt(str.substring(i, i+2), 16) ^ Math.floor((prand / modu) * 255));
    enc_str += String.fromCharCode(enc_chr);
    prand = (mult * prand + incr) % modu;
  }
  return enc_str;
}

<?php

    }
    else if ($encryption == 'medium')
    { 
  
?>
    
// basic/simple ascii encryption
// script taken and slightly modified 
// from javascript.com:  http://javascript.internet.com/passwords/ascii-encryption.html
// Original:  David Salsinha (david.salsinha@popsi.pt)
//  
// Encrypts a given string
//    
function QuickSave_encrypt(str)
{   

   if (str == "" || str == null) return "";

   output = new String;
   Temp = new Array();
   Temp2 = new Array();
   TextSize = str.length;
   for (i = 0; i < TextSize; i++) {
      rnd = Math.round(Math.random() * 122) + 68;
      Temp[i] = str.charCodeAt(i) + rnd;
      Temp2[i] = rnd;
   }
   for (i = 0; i < TextSize; i++) {
      output += String.fromCharCode(Temp[i], Temp2[i]);
   }
   return escape(output);

}



// basic/simple ascii encryption
// script taken and slightly modified
// from javascript.com:  http://javascript.internet.com/passwords/ascii-encryption.html
// Original:  David Salsinha (david.salsinha@popsi.pt)
//
// Decrypts a given string
//
function QuickSave_decrypt(str)
{

   if (str == "" || str == null) return "";

   str = unescape(str);

   output = new String;
   Temp = new Array();
   Temp2 = new Array();
   TextSize = str.length;
   for (i = 0; i < TextSize; i++) {
      Temp[i] = str.charCodeAt(i);
      Temp2[i] = str.charCodeAt(i + 1);
   }
   for (i = 0; i < TextSize; i = i+2) {
      output += String.fromCharCode(Temp[i] - Temp2[i]);
   }
   return output;

}

<?php

    }
    else if ($encryption == 'low')
    {

?>

// basic/simple ascii encryption
// script taken and slightly modified 
// from javascript.com:  http://javascript.internet.com/passwords/character-encoder.html
// Original:  Mike McGrath (mike_mcgrath@lineone.net) 
// Web Site:  http://website.lineone.net/~mike_mcgrath/ 
//
// Encrypts a given string
//
function QuickSave_encrypt(str)
{

   if (str == "" || str == null) return "";

   enc_str = "";

   for(i = 0; i < str.length; i++) {
      enc_str += str.charCodeAt(i) - 23;
   }
   return enc_str;

}



// basic/simple ascii encryption
// script taken and slightly modified 
// from javascript.com:  http://javascript.internet.com/passwords/character-encoder.html
// Original:  Mike McGrath (mike_mcgrath@lineone.net) 
// Web Site:  http://website.lineone.net/~mike_mcgrath/ 
//
// Decrypts a given string
//
function QuickSave_decrypt(str)
{

   if (str == "" || str == null) return "";

   enc_str = "";

   for(i = 0; i < str.length; i += 2) {
      num_in = parseInt(str.substr(i,[2])) + 23;
      num_in = unescape('%' + num_in.toString(16));
      enc_str += num_in;
   }
   return enc_str;

}

<?php

    }

?>



// calling this function just drops the cookie values into the form...
function QuickSave_cookie_restore()
{
	
  <?php 
        if ($encryption == 'none') {
           ?>
		var QScr_send_to = QuickSave_cookie_pull("send_to");
		var QScr_send_to_cc = QuickSave_cookie_pull("send_to_cc");
		var QScr_send_to_bcc = QuickSave_cookie_pull("send_to_bcc");
		var QScr_subject = QuickSave_cookie_pull("subject");
		var QScr_body = QuickSave_cookie_pull("body");
           <?php
        } else {
           ?>
		var QScr_send_to = unescape(QuickSave_decrypt(QuickSave_cookie_pull("send_to")));
		var QScr_send_to_cc = unescape(QuickSave_decrypt(QuickSave_cookie_pull("send_to_cc")));
		var QScr_send_to_bcc = unescape(QuickSave_decrypt(QuickSave_cookie_pull("send_to_bcc")));
		var QScr_subject = unescape(QuickSave_decrypt(QuickSave_cookie_pull("subject")));
		var QScr_body = unescape(QuickSave_decrypt(QuickSave_cookie_pull("body")));
           <?php
        } 
  ?>
	
	if ( QScr_send_to && QScr_send_to.length >= 1 )
		document.compose.send_to.value = QScr_send_to;
	if ( QScr_send_to_cc && QScr_send_to_cc.length >= 1 )
		document.compose.send_to_cc.value = QScr_send_to_cc;
	if ( QScr_send_to_bcc && QScr_send_to_bcc.length >= 1 )
		document.compose.send_to_bcc.value = QScr_send_to_bcc;
	if ( QScr_subject && QScr_subject.length >= 1 )
		document.compose.subject.value = QScr_subject;
	if ( QScr_body && QScr_body.length >= 1 )
		document.compose.body.value = QScr_body;
	return true;
} // end QuickSave_cookie_restore()

// test if a given string equals one of the user's signatures
function QuickSave_equalsSig(str)
{

	if (!str || str.length <= 0)
		return false;


<?php
	global $username, $data_dir, $prefix_sig;

	echo 'var sigs = [';

	$sig = getSig($data_dir, $username, 'g');
	if (empty($sig)) echo '];';

	else
	{
		$sig = preg_replace("/(\015\012)|(\015)|(\012)/", "", $sig);
		$sig = preg_replace("/\"/", "\\\"", $sig);
		echo '"' . ($prefix_sig == true ? '-- ' : '') . $sig . '"';

		$num = 1;
		$sig = getSig($data_dir, $username, $num);

		while (!empty($sig))
		{
			$sig = preg_replace("/(\015\012)|(\015)|(\012)/", "", $sig);
			echo ', "' . ($prefix_sig == true ? '-- ' : '') . $sig . '"';
			$num++;
			$sig = getSig($data_dir, $username, $num);
		}
		
		echo '];';
	}

?>

	for (i = 0; i < sigs.length; i++)
	{
                sig = sigs[i];
		if (trim(str) == trim(sig))
			return true;
	}

	return false;

} // end QuickSave_equalsSig

// replace double quotes in a string with single quotes
function convertQuotes(str)
{
   if (str == null) return null;

   var returnStr = "";
   for (i = 0; i < str.length; i++)
   {
      if (str.charAt(i) == "\"")
         returnStr += "'";
      else
         returnStr += str.charAt(i);
   }
   return returnStr;
}


// take off whitespace from front and tail of string, also removes all newlines
function trim(stringToTrim)
{
        if (stringToTrim == null) return null;

        for (i = 0; i < stringToTrim.length; i++)
        {
                while (stringToTrim.charAt(0) == ' ' 
			|| stringToTrim.charAt(0) == '\n' 
			|| stringToTrim.charAt(0) == '\t' 
			|| stringToTrim.charAt(0) == '\f' 
			|| stringToTrim.charAt(0) == '\r')
                        stringToTrim = stringToTrim.substring(1, stringToTrim.length);

                while (stringToTrim.charAt(stringToTrim.length - 1) == ' ' 
			|| stringToTrim.charAt(stringToTrim.length - 1) == '\n' 
			|| stringToTrim.charAt(stringToTrim.length - 1) == '\t' 
			|| stringToTrim.charAt(stringToTrim.length - 1) == '\f' 
			|| stringToTrim.charAt(stringToTrim.length - 1) == '\r')
                        stringToTrim = stringToTrim.substring(0, stringToTrim.length - 1);
        }

	var returnString = "";
        for (i = 0; i < stringToTrim.length; i++)
        {
		if (stringToTrim.charAt(i) != "\n" && stringToTrim.charAt(i) != "\r")
			returnString += stringToTrim.charAt(i);
        }

        return returnString;
}


<?php

   //
   // check if user was just appending a signature or getting addresses or attachments
   //

   // get global variables for versions of PHP < 4.1
   //
   if (!compatibility_check_php_version(4, 1)) {
      global $HTTP_POST_VARS;
      $_POST = $HTTP_POST_VARS;
   }

   if ($encryption == 'none') {
      ?>
         var bodyCheck = QuickSave_cookie_pull("body");
         var subjectCheck = QuickSave_cookie_pull("subject");
         var sendToCheck = QuickSave_cookie_pull("send_to");
         var sendToCcCheck = QuickSave_cookie_pull("send_to_cc");
         var sendToBccCheck = QuickSave_cookie_pull("send_to_bcc");
      <?php
   } else {
      ?>
         var bodyCheck = unescape(QuickSave_decrypt(QuickSave_cookie_pull("body")));
         var subjectCheck = unescape(QuickSave_decrypt(QuickSave_cookie_pull("subject")));
         var sendToCheck = unescape(QuickSave_decrypt(QuickSave_cookie_pull("send_to")));
         var sendToCcCheck = unescape(QuickSave_decrypt(QuickSave_cookie_pull("send_to_cc")));
         var sendToBccCheck = unescape(QuickSave_decrypt(QuickSave_cookie_pull("send_to_bcc")));
      <?php
   }

?>

   var bodyFromPost = "<?php if (isset($_POST['body'])) 
                                echo str_replace('"', '\'', 
                                     preg_replace("/(\015\012)|(\015)|(\012)/", "", $_POST['body'])) 
                       ?>";
   var subjectFromPost = "<?php if (isset($_POST['subject'])) echo str_replace('"', '\'', $_POST['subject']) ?>";
   var sendToFromPost = "<?php if (isset($_POST['send_to'])) echo str_replace('"', '\'', $_POST['send_to']) ?>";
   var sendToCcFromPost = "<?php if (isset($_POST['send_to_cc'])) echo str_replace('"', '\'', $_POST['send_to_cc']) ?>";
   var sendToBccFromPost = "<?php if (isset($_POST['send_to_bcc'])) echo str_replace('"', '\'', $_POST['send_to_bcc']) ?>";

   var newBodyCheck = convertQuotes(trim(bodyCheck)); 

   if (newBodyCheck != null)
   {
      // see below for why we take off the last char
      newBodyCheck = newBodyCheck.substring(0, newBodyCheck.length - 1); 

      // body from POST can often be longer than what is able to be saved 
      // in cookies (and often, because of this, the last character from 
      // the cookie is junk)
      // also, the quotes already converted by php
      bodyFromPost = trim(bodyFromPost).substring(0, newBodyCheck.length);
   }

   var newSubjectCheck = convertQuotes(subjectCheck);
   var newSendToCheck = convertQuotes(sendToCheck);
   var newSendToCcCheck = convertQuotes(sendToCcCheck);
   var newSendToBccCheck = convertQuotes(sendToBccCheck);


   if ( (bodyFromPost == newBodyCheck || (bodyCheck == null && bodyFromPost == ''))
        && (subjectFromPost == newSubjectCheck || (subjectCheck == null && subjectFromPost == ''))
        && (sendToFromPost == newSendToCheck || (sendToCheck == null && sendToFromPost == ''))
        && (sendToCcFromPost == newSendToCcCheck || (sendToCcCheck == null && sendToCcFromPost == ''))
        && (sendToBccFromPost == newSendToBccCheck || (sendToBccCheck == null && sendToBccFromPost == '')) )
   {
      // -- Previous Message Is Still Available; Deactivate QuickSave Cookie --
      if ( QuickSave_left_frame_exists() )
         parent.left.document.quicksave.is_active.value = "0"
      document.cookie = escape("QS<?php echo $qs_username ?>") + "is_active=0; expires=Thu, 01-Jan-70 00:00:01 GMT";
   }




// -- Start Restoration Process --
 // we check to see if we restore, but we only do this once (so no function)
if ( QuickSave_cookie_pull("is_active") == "1") // cookies stored?
{
	var showTo = new String(''+sendToCheck+'');
	var showSub = new String(''+subjectCheck+'');

	if ( showTo.length > 40 )
		showTo = showTo.substr(0,35) + '...';
	else if (showTo.toString() == 'null' || showTo.toString() == null || showTo.toString() == '')
		showTo = new String('<none>');


	if ( showSub.length > 50 )
		showSub = showSub.substr(0,45) + '...';
	else if (showSub.toString() == 'null' || showSub.toString() == null || showSub.toString() == '')
		showSub = new String('<none>');


	// only offer to restore if there was any data there
	//
	if (!( showTo.toString() == '<none>' && showSub.toString() == '<none>' 
	     && (!bodyCheck || bodyCheck.length <= 0 || QuickSave_equalsSig(bodyCheck))
	     && (!sendToCcCheck || sendToCcCheck.length <= 0)
	     && (!sendToBccCheck || sendToBccCheck.length <= 0) ))
	{
		if ( confirm('<?php echo _("WARNING: The following email was interrupted and was never sent!"); ?>\n\n  <?php echo _("To:"); ?> ' + showTo.toString() + '\n  <?php echo _("Subject:"); ?> ' + showSub.toString() + '\n\n<?php echo _("Do you wish to restore it?  (Press cancel to discard message)"); ?>') )
		{
			QuickSave_cookie_restore();
			//alert('<?php echo _("Email restored!"); ?>\n\n<?php echo _("Please remember to press Send when finished typing your message."); ?>');
		}
		else if ( QuickSave_left_frame_exists() )
	 	{
			QuickSave_swap(document.compose, parent.left.document.quicksave, 1);
	  	}
	}
	else if ( QuickSave_left_frame_exists() )
	{
		QuickSave_swap(document.compose, parent.left.document.quicksave, 1);
  	}
}
 // if no cookies stored (for whatever reason) we check the backup form on the left side)
else if ( QuickSave_left_frame_exists() )
{

	left_form = parent.left.document.quicksave;

	if ( left_form.is_active && left_form.is_active.value == 1 )
	{
	
		var showTo = new String(''+left_form.send_to.value+'');

		if ( showTo.length > 40 )
			showTo = showTo.substr(0,35) + '...';
		else if (showTo.toString() == 'null' || showTo.toString() == null || showTo.toString() == '')
			showTo = new String('<none>');

		var showSub = new String(''+left_form.subject.value+'');

		if ( showSub.length > 50 )
			showSub = showSub.substr(0,45) + '...';
		else if (showSub.toString() == 'null' || showSub.toString() == null || showSub.toString() == '')
			showSub = new String('<none>');

		// only offer to restore if there was any data there
		//
		if (!(showTo.toString() == '<none>' && showSub.toString() == '<none>' 
		     && (!left_form.body || left_form.body.value.length <= 0 || QuickSave_equalsSig(left_form.body.value))
		     && (!left_form.send_to_cc || left_form.send_to_cc.value.length <= 0)
		     && (!left_form.send_to_bcc || left_form.send_to_bcc.value.length <= 0) ))
		{

			if ( confirm('<?php echo _("WARNING: The following email was interrupted and was never sent!"); ?>\n\n'
						+'  <?php echo _("To:"); ?> ' + showTo.toString() + '\n'
						+'  <?php echo _("Subject:"); ?> ' + showSub.toString() + '\n\n'
						+'<?php echo _("Do you wish to restore it?  (Press cancel to discard message)"); ?>') )
			{
				QuickSave_swap(left_form.quicksave, document.compose, 0);
				//alert('<?php echo _("Email restored!"); ?>\n\n<?php echo _("Please remember to press Send when finished typing your message."); ?>');
			}
			else
			{
				QuickSave_swap(document.compose, left_form.quicksave, 1);
	 		}
		}
		else
		{
			QuickSave_swap(document.compose, left_form.quicksave, 1);
		}
	}
	else
	{
		QuickSave_swap(document.compose, left_form.quicksave, 0);
	}
}


// this should set us on the path to glory...
<?php

    $frequency = getPref($data_dir, $username, 'quicksave_frequency', '1');
    $units = getPref($data_dir, $username, 'quicksave_units', 'seconds');

    if ($frequency > 0)
    {
        if ($units == 'seconds') $frequency = $frequency * 1000;
        echo 'setInterval(\'QuickSave_swap(false, false, 0)\', ' . $frequency . ');';
    }
    else echo '// -- QuickSave is turned off... reenable in Display Preferences page';

    echo "\n\n";
?>
	
// -- End Restoration Process --
//-->
</script>
	<!-- end -- QuickSave plugin -->
<?php
} // end quicksave_compose_functions()


?>
