<?php


// initialize QuickSave - register hooks 
//
function squirrelmail_plugin_init_quicksave()
{

	global $squirrelmail_plugin_hooks;

	$squirrelmail_plugin_hooks['left_main_after']['quicksave']          = 'quicksave_left_main_after';
	$squirrelmail_plugin_hooks['compose_bottom']['quicksave']           = 'quicksave_compose_bottom';

        $squirrelmail_plugin_hooks ['compose_send']['quicksave']            = 'quicksave_message_sent';
        $squirrelmail_plugin_hooks ['right_main_after_header']['quicksave'] = 'quicksave_set_inactive';

	$squirrelmail_plugin_hooks['compose_button_row']['quicksave']       = 'quicksave_cancel_button';
        $squirrelmail_plugin_hooks['options_display_inside']['quicksave']   = 'quicksave_show_options';
        $squirrelmail_plugin_hooks['options_display_save']['quicksave']     = 'quicksave_save_options';


} // end squirrelmail_plugin_init_quicksave() function



// This is the text that appears on the option page
//
function quicksave_show_options() {

    if (defined('SM_PATH'))
       include_once(SM_PATH . 'plugins/quicksave/functions.php');
    else
       include_once('../plugins/quicksave/functions.php');

    quicksave_options();

}



// Here we save the user's quicksave preferences
//
function quicksave_save_options() {

    if (defined('SM_PATH'))
       include_once(SM_PATH . 'plugins/quicksave/functions.php');
    else
       include_once('../plugins/quicksave/functions.php');

    quicksave_options_save();

}



// set flag indicating message was sent
function quicksave_message_sent() {

    if (defined('SM_PATH'))
       include_once(SM_PATH . 'plugins/quicksave/functions.php');
    else
       include_once('../plugins/quicksave/functions.php');

    quicksave_message_sent_do();

}



// turn off quicksave active status if flag is set
//
function quicksave_set_inactive() {

    if (defined('SM_PATH'))
       include_once(SM_PATH . 'plugins/quicksave/functions.php');
    else
       include_once('../plugins/quicksave/functions.php');

    quicksave_turn_off();

}



// this is where we store all the information for retrieval using the
// form as the storage mechanism.. I imagine there are better ways to do this,
// but I'll be darned if I know what they are
function quicksave_left_main_after()
{

    if (defined('SM_PATH'))
       include_once(SM_PATH . 'plugins/quicksave/functions.php');
    else
       include_once('../plugins/quicksave/functions.php');

    quicksave_build_form();

} // end quicksave_left_main_after() function



 // this is where we put the 'cancel' button, if they have javascript.
 // otherwise, they can't use this plugin, so there's no reason to show it
function quicksave_cancel_button()
{

    if (defined('SM_PATH'))
       include_once(SM_PATH . 'plugins/quicksave/functions.php');
    else
       include_once('../plugins/quicksave/functions.php');

    build_quicksave_cancel_button();

} // end quicksave_cancel_button() function



// basically, this is the meat of the code.
// Currently it adds an extra 8.5k to this page's download time.
// That needs to be trimmed back A LOT
//
function quicksave_compose_bottom()
{

    if (defined('SM_PATH'))
       include_once(SM_PATH . 'plugins/quicksave/functions.php');
    else
       include_once('../plugins/quicksave/functions.php');

    quicksave_compose_functions();

} // end quicksave_compose_bottom() function


?>
