<?php
/**
 * plugins/qmailadmin_login/setup.php -- Main setup script
 *
 * Copyright (c) 2004-2005 Tomas Kuliavas <tokul@users.sourceforge.net>
 * This file is part of SquirrelMail QmailAdmin Login plugin.
 *
 * QmailAdmin Login plugin is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * QmailAdmin Login plugin is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with QmailAdmin Login plugin; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * @version $Id: setup.php,v 1.7 2005/07/27 16:08:20 tokul Exp $
 * @package sm-plugins
 * @subpackage qmailadmin_login
 */

/**
 * make sure SM_PATH is defined
 * @ignore
 */
if (!defined('SM_PATH')) define('SM_PATH','../');

/**
 * init function
 */
function squirrelmail_plugin_init_qmailadmin_login() {
    global $squirrelmail_plugin_hooks;

    $squirrelmail_plugin_hooks['optpage_register_block']['qmailadmin_login'] = 'qmlogin_options';
}

/**
 * inserts option data into SquirrelMail options
 */
function qmlogin_options() {
    include_once(SM_PATH . 'plugins/qmailadmin_login/functions.php');
    qmlogin_options_function();
}

/**
 * shows plugin's version
 * @return string
 */
function qmailadmin_login_version() {
    return '1.1';
}
?>