<?php
/*******************************************************************************

    Author ......... Jimmy Conner
    Contact ........ jimmy@advcs.org
    Home Site ...... http://www.advcs.org/
    Program ........ Plugin Updates
    Version ........ 0.6
    Purpose ........ Check your currently installed plugins for updates

*******************************************************************************/



   chdir("..");
   if (!defined('SM_PATH'))
      define('SM_PATH','../');
   if (file_exists(SM_PATH . 'include/validate.php')) {
      include_once(SM_PATH . 'include/validate.php');
   } else {
      if (file_exists(SM_PATH . 'src/validate.php'))
         include_once(SM_PATH . 'src/validate.php');
   }

   $update = new PUpdate;

   require_once (SM_PATH . 'plugins/pupdate/config.php');

   if ($username != $update->adminusername)
      header("Location:../../src/right_main.php?startMessage=1&mailbox=INBOX");

   displayPageHeader($color, "None");

   global $_GET, $_POST;
   if (isset($_GET['do']))
      $do = $_GET['do'];
   if (isset($_GET['vvv']))
      $vvv = $_GET['vvv'];
   if (isset($_POST['vvv']))
      $vvv = $_POST['vvv'];
   if (isset($_GET['dname']))
      $dname = $_GET['dname'];
   if (isset($_GET['pversion']))
      $pversion = $_GET['pversion'];
   if (isset($_GET['name2']))
      $name2 = $_GET['name2'];
   if (isset($_POST['dname']))
      $dname = $_POST['dname'];
   if (isset($_POST['name2']))
      $name2 = $_POST['name2'];

   if ($do  == 'edit')
      $update->ChangeVersion($name2, $pversion, $dname);

   if ($vvv != '')
      $update->WriteVersion($dname, $vvv, $name2);

   if ($do == 'pluginlist' && !$update->dontupdate)
      $update->UpdateFile('pluginlist');

   if ($do =='defaultdirs' && !$update->dontupdate)
      $update->UpdateFile('defaultdirs');

   if ($do == 'core' && !$update->dontupdate) 
      $update->UpdateFile('core');

   $update->ShowOptions($color);

   $update->ShowVersion($version);

   if (!$update->stablehide)
      $update->ShowStable();

   if (!$update->dontupdate)
      $update->CheckUpdates();

   sort($plugins);
   global $display;
   foreach ($plugins as $key => $value){
      $extra = '';
      $dname = trim($plugins[$key]);
      $update->GetPluginInfo($dname);

      $display = false;

      if ($update->pluginversion) {
         $pluginfile = fopen(SM_PATH ."plugins/pupdate/udata/pluginlist.dat", r);
         $a = -1;
         while (!feof($pluginfile)) {
            $a++;
            $plugin = trim(strip_tags(fgets($pluginfile, 150)));
            if ($plugin == $update->pluginname){
               // Checks for core programs here
               $cinfo = $update->isitcore($a, $version);
               if ($cinfo == ''){
                  $update->DisplayPluginInfo($dname, $plugin, $a, $update->pluginversion);   
               }else{
                  $update->DisplayCoreInfo($dname, $plugin, $cinfom, $update->pluginversion);
               }
            }
         }
         fclose($pluginfile);

         if ($update->pluginversion == 0 && $update->unofficialhide) {
            # Plugins that either aren't set up correctly or aren't supported
            $display = true;
            $extra = $extra . "<dd><font size=-1>Not an official plugin or on the Plugin Page?</font></dd></dl>\n";
         }
      } else {
         $display = true;
         if ($update->pluginname != '') {
            $extra = "<dd><font size=-1>No Version in version file (refresh)</font></dd></dl>\n";
            $update->pluginversion = 'Unknown';
            $update->WriteVersion($dname, $update->pluginversion, $update->pluginname);
         } else {
            $extra = "<dd><font size=-1>Unsupported, may not be the default install directory?</font></dd></dl>\n";
            $update->pluginversion = 'Unknown';
            $update->WriteVersion($dname, $update->pluginversion, $update->pluginname);
         }
      }
      if ($display) {
         if (!$update->plink)
            $update->plink = $update->pluginversion;
         print "<dl><dt><b>$update->pluginname</b> $update->plink</dt>\n";
         if (!$update->locationhide)
            print "<dd><font size=-1><b>Location</b>: /plugins/$dname</font></dd>";
         print "$extra</dl>";
      }

   }

   class PUpdate {

      var $adminusername = 'jimmy@advcs.org';
      var $dontupdate = 0;
      var $cvshide = 1;
      var $stablehide = 0;
      var $uptodatehide = 0;
      var $unofficialhide = 0;
      var $corehide = 0;
      var $locationhide = 1;
      var $autoupdate = 1;
      var $pulp = '';
      var $pulp2 = '';
      var $pluginname = '';
      var $pluginversion = '';
      var $plink = '';

      function GetPluginInfo($dname) {
         $this->pluginname = '';
         $this->pluginversion = 0;
         $func = $dname . '_version';
         if (@function_exists($func)) {
            $this->pluginversion = $func();
            $this->GetPluginName($dname);
         } else {
            @chmod (SM_PATH . "plugins/$dname/version", 0777);
            if ($vfile = @fopen(SM_PATH . "plugins/$dname/version", r)) {
               $this->pluginname = strip_tags(trim(fgets($vfile, 150)));
               $this->pluginversion = strip_tags(trim(fgets($vfile, 150)));
               fclose($vfile);
            } else {
               $this->GetPluginName($dname);
            }
         }
      }

      function GetPluginName($dname) {
         $this->pluginname = '';
         $dirfile = @fopen(SM_PATH . "plugins/pupdate/udata/defaultdirs.dat",r);
         $aa = -1;
         while (!feof($dirfile) && $this->pluginname == '') {
            $aa++;
            $plugin = trim(fgets($dirfile, 150));
            if ($plugin == $dname){
               $founddefault = 1;
               $pluginfile = @fopen(SM_PATH ."plugins/pupdate/udata/pluginlist.dat",r);
               $b=-1;
               while ($b < $aa){
                  $b++;
                  $this->pluginname = trim(fgets($pluginfile, 150));
               }
               fclose($pluginfile); 
            }
         }
         fclose($dirfile);
         if ($this->pluginname == '')
               $this->pluginname = strip_tags(ucwords(str_replace("_", " ", $dname)));
      }

      function ShowStable() {
         $file = @fopen("http://www.squirrelmail.org/download.php", r);
         $string = @fread($file, 5000);
         $stben = strpos($string, "<b>Version:");
         $stend = strpos($string, "</b><br>", $stben + 1);
         $x = substr($string, $stben + 12, ($stend - ($stben + 12)));
         print "Current Stable Version is <a href='http://www.squirrelmail.org/download.php'><b>Squirrelmail $x</b></a><br>\n";
         @fclose($file);
      }

      function ShowVersion($version) {
         print "\n<br>You are currently running <b>Squirrelmail $version</b><br>\n";
      }

      function ShowOptions($color) {
        $showarray = array(0 => "Show",1 => "Hide");
        $a = $this->stablehide;
        $b = $this->cvshide;
        $c = $this->uptodatehide;
        $d = $this->unofficialhide;
        $e = $this->corehide;
        $f = $this->dontupdate;
        $g = $this->locationhide;

         print "<br><center><table border=1 width='70%' bgcolor='$color[9]'><tr><td><center>Stable</center></td><td><center>CVS</center></td><td><center>Updated</center></td><td><center>Unofficial</center></td><td><center>Core</center></td><td><center>Data Files</center></td><td><center>Location</center></td></tr>";
         print "<tr bgcolor='$color[4]'><td><center>$showarray[$a]</center></td><td><center>$showarray[$b]</center></td><td><center>$showarray[$c]</center></td><td><center>$showarray[$d]</center></td><td><center>$showarray[$e]</center></td><td><center>$showarray[$f]</center></td><td><center>$showarray[$g]</center></td></tr>";
         print "</table></center>";
      }

      function UpdateFile($dfile) {
         @chmod (SM_PATH . "plugins/pupdate/udata/$dfile.dat", 0777);
         $file = @fopen("http://advcs.org/sm/$dfile.dat", r);
         $pulp = @strip_tags(fread($file, 5000));
         $file2 =  fopen(SM_PATH . "plugins/pupdate/udata/$dfile.dat", w);
         @fwrite ($file2, $pulp);
         @fclose($file);
         @fclose($file2);
      }

      function CheckUpdate($dfile) {
         $file = @fopen("http://advcs.org/sm/$dfile.dat",r);
         $this->pulp = @trim(strip_tags(fread($file, 4)));
         $file2 =  @fopen(SM_PATH . "plugins/pupdate/udata/$dfile.dat",r);
         $this->pulp2 = @trim(strip_tags(fgets($file2, 150)));
         @fclose($file);
         @fclose($file2);
      }

      function CheckUpdates() {
         if ($this->autoupdate) {
            $this->CheckUpdate('pluginlist');
            if ($this->pulp > $this->pulp2) {
               $this->UpdateFile('pluginlist');
               print "Your Plugin List has been updated from v$this->pulp2, to v$this->pulp automatically.<br>\n";
            }
            $this->CheckUpdate('defaultdirs');
            if ($this->pulp > $this->pulp2) {
               $this->UpdateFile('defaultdirs');
               print "Your Directory List has been updated from v$this->pulp2, to v$this->pulp automatically.<br>\n";
            }
            $this->CheckUpdate('core');
            if ($this->pulp > $this->pulp2) {
               $this->UpdateFile('core');
               print "Your Core List has been updated from v$this->pulp2, to v$this->pulp automatically.<br>\n";
            }
         } else {
            $this->CheckUpdate('pluginlist');
            if ($this->pulp > $this->pulp2)
               print "Your Plugin List is v$this->pulp2, click <a href='../pupdate/update.php?do=updatelist'><b>here</b></a> to update to v$this->pulp automatically.<br>\n";
            $this->CheckUpdate('defaultdirs');
            if ($this->pulp > $this->pulp2)
               print "Your Directory List is v$this->pulp2, click <a href='../pupdate/update.php?do=updatelist'><b>here</b></a> to update to v$this->pulp automatically.<br>\n";
            $this->CheckUpdate('core');
            if ($this->pulp > $this->pulp2)
               print "Your Core List is v$this->pulp2, click <a href='../pupdate/update.php?do=updatelist'><b>here</b></a> to update to v$this->pulp automatically.<br>\n";
         }
      }

      function ChangeVersion($name2,$pversion,$dname) {
         print "<dl><dt><b>$name2</b></dt>";
         print "<dd><font size=-1><b>Version</b>: $pversion</font></dd>";
         print "<dd><font size=-1><b>Location</b>: /plugins/$dname</font></dd></dl>";
         print "<form method=post action='update.php'>Change version to:<br><input type=text name=vvv value='$pversion'><input type=hidden name=dname value='$dname'><input type=hidden name=name2 value='$name2'><input type=submit value='Submit'></form>";
         exit;
      }

      function WriteVersion($dname, $vvv, $name2) {
         @chmod (SM_PATH . "plugins/$dname/version", 0777);
         $file =  fopen(SM_PATH . "plugins/$dname/version", w);
         @fwrite ($file, strip_tags("$name2\n"));
         @fwrite ($file, strip_tags($vvv));
         @fclose($file);
      }

      function getnew($id) {
         # This function just grabs the newest version off the website, its slow and bloated, need to be fixed!!!!
         $file = @fopen("http://www.squirrelmail.org/plugin_view.php?id=$id", r);
         $string = fread($file, 9000);
         $stben = strpos($string, "<b>Version");
         $stend = strpos($string, "<br><br>", $stben + 1);
         $x = substr($string, $stben, ($stend - $stben));
         $x = str_replace("plugin_download.php", "http://www.squirrelmail.org/plugin_download.php",$x);
         fclose($file);
         return $x;
      }

      function parsecore ($cinfo, $sm) {
         if (trim($cinfo) == '')
            return "";
         $c = substr($cinfo, 0, 1);
         $cv = substr($cinfo, 2);
         if ($cv > $sm)
            return "";
         if ($c == 'V')
            return "Added to the CVS in SM $cv, please check for updates <a target='_new' href='http://cvs.sourceforge.net/cgi-bin/viewcvs.cgi/squirrelmail/squirrelmail/plugins/'>there</a>.";
         return "Added to the SM Core in SM $cv,<br> you may need to uninstall this plugin,<br> inorder for your SM to function properly.";
      }

      function isitcore($id, $sm) {
         $corefile = fopen(SM_PATH . "plugins/pupdate/udata/core.dat", r);
         $b = -1;
         while ($b < $id + 1) {
            $b++;
            $coreinfo = @trim(strip_tags(fgets($corefile, 15)));
         }
         @fclose($corefile);
         return $this->parsecore($coreinfo, $sm);
      }

      function DisplayCoreInfo($dname, $plugin, $cinfom, $pversion) {
         global $display, $extra;
         $this->plink = "(<a href='update.php?do=edit&dname=$dname&name2=$plugin&pversion=$pversion'><font size=-1>v$this->pluginversion</font></a>)";
         if (substr($cinfo,13,1) == 'S'){
            if (!$this->corehide)
               $display = true;
         } else {
            if (!$this->cvshide)
               $display = true;
         }
         $extra = $extra . "<dd><font size=-1>$cinfo</font></dd></dl>\n";
      }

      function DisplayPluginInfo($dname, $plugin, $a, $pversion) {
         global $display, $extra;
         $info = $this->getnew($a);
         $pnewversion = strpos($info, "</b><br>");
         $pnewversion = substr($info, 11, $pnewversion - 11);
         $this->plink = "(<a href='update.php?do=edit&dname=$dname&name2=$plugin&pversion=$pversion'><font size=-1>v$pversion</font></a>)";
         if (!$pversion)
            $this->plink = "(<a href='update.php?do=edit&dname=$dname&name2=$plugin&pversion=$pversion'><font size=-1><i><u>Unknown Version</u></i></font></a>)";
         if ($pnewversion > $pversion) {
            $display = true;
            $extra = $extra . "<dd><font size=-1>$info</font></dd></dl>\n";
         } else {
            if (!$this->uptodatehide) {
               $display = true;
               $extra = $extra . "<dd><font size=-1>Is up to date.</font></dd></dl>\n";
            }
         }
      }
   }

?>