<?php

include_once(SM_PATH . 'include/validate.php');
include_once(SM_PATH . 'plugins/proon/utils.php');

/**
 * This function considers both a sitewide minimum interval
 * between checks and a personal interval.  Both tests
 * must pass or the hook is not active.
 */
function proon_is_hook_active($what) {
  sqGetGlobalVar(PROON_LAST_PRUNE, $last_prune, SQ_SESSION);
  // If $last_prune is null, it's just after logon, so the
  // hook is definitely active.
  if ($last_prune == null) return true;

  $time_diff = time() - $last_prune;

  global $proon_site_min_interval;
  if (isset($proon_site_min_interval)) {
    $site_interval = proon_date_in_seconds($proon_site_min_interval);
  }
  if ($site_interval > $time_diff) return false;

  global $data_dir, $username;
  $interval = getPref($data_dir, $username, PROON_O_U_PRUNE_INTERVAL);
  if ($interval == PROON_PREF_BLANK) {
    // no interval, so not active
    return false;
  }

  $interval = proon_date_in_seconds($interval);
  if ($interval > $time_diff) return false;

  return true;
}

function proon_prune_hook_function($h) {
  if (is_array($h)) $h = $h[0];
  if (!proon_is_hook_active($h)) {
    return;
  }

  bindtextdomain('proon', SM_PATH . 'plugins/proon/locale');
  textdomain('proon');

  $p = proon_get_prefs();
  $outcome = array();
  $notice = null;
  $imapStr = null;
  include_once(SM_PATH . 'plugins/proon/action.php');
  proon_action_pruneall($p, $outcome, $notice, $imapStr);
  sqsession_register(time(), PROON_LAST_PRUNE);

  if (isset($p[PROON_P_OPTIONS][PROON_O_U_MESSAGE_AFTER])) {
    $report_slim = proon_format_outcome($p, $outcome, false);
    if ($report_slim !== null) {
      include_once(SM_PATH . 'class/mime/Message.class.php');
      $msg = new Message();
      $msg->rfc822_header = proon_format_headers($p, $outcome, false);
      $msg->setBody($report_slim);
      include_once(SM_PATH . 'class/deliver/Deliver_IMAP.class.php');
      $deliver = new Deliver_IMAP();
      //sm_print_r('msg', $msg);
      $length = $deliver->mail($msg);
      proon_login($imapStr);
      sqimap_append($imapStr, 'INBOX', $length);
      $deliver->mail($msg, $imapStr);
      sqimap_append_done($imapStr, 'INBOX');
    }
  }
  if (isset($p[PROON_P_OPTIONS][PROON_O_U_SCREEN_AFTER])) {
    $report_verbose = proon_format_outcome($p, $outcome, true);
    
    echo '<pre>';
    echo _("proon autopruning report") . "\n\n";
    echo $report_verbose;
    echo '</pre>';
  }
  proon_logout($imapStr);

  bindtextdomain('squirrelmail', SM_PATH . 'locale');
  textdomain('squirrelmail');

}

function proon_link($h) {
  if (is_array($h)) $h = $h[0];
  
  $options_page = true;
  if ($h == 'left_main_after') {
    $options_page = false;
    global $data_dir, $username;
    $disable_left_link = getPref($data_dir, $username, PROON_O_U_PRUNE_LINK);
    if ($disable_left_link  &&  $disable_left_link != PROON_PREF_BLANK) {
      // user doesn't want it on the left pane
      return false;
    }
  }

  bindtextdomain('proon', SM_PATH . 'plugins/proon/locale');
  textdomain('proon');

  if ($options_page) {
    echo '<tr><th colspan=99 align=center>' . _("Options for Pruning Folders") . '</th>';
    echo '<tr><td colspan=99 align=center>';
    echo '<a href="../plugins/proon/form.php">' . _("Pruning ...") . '</a></th>';
  }
  else {
    echo '<p><center>';
    echo '<form target="right" action="../plugins/proon/form.php" method="get">';
    echo '<input class="small" type="submit" value="' . _("Pruning ...") . '"></form>';
    echo '</center>';
  }
    
  bindtextdomain('squirrelmail', SM_PATH . 'locale');
  textdomain('squirrelmail');
}

function proon_onetime($h) {
  if (is_array($h)) $h = $h[0];

  global $right_frame;

  // caution: this hook can be called twice if a site uses a
  // redirecting login plugin.
  // We only want to do stuff the first time through.
  sqGetGlobalVar('proon_onetime', $proon_onetime, SQ_SESSION);
  if ($proon_onetime) {
    if ($proon_onetime !== true) {
      $right_frame = $proon_onetime;
    }
    return; // already been here
  }
  sqsession_register(true, 'proon_onetime');

  $p = proon_get_prefs();
  if ($p[PROON_P_PREFS_SEEN] > 0) return;  // not our first time
  
  global $proon_onetime_everybody;
  global $proon_convert_apst;
  if ($proon_convert_apst) {
    global $data_dir, $username;
    $apst = getPref($data_dir, $username, 'auto_prune_sent_threshold');
    if (is_numeric($apst)  &&  $apst > 0) {
      global $proon_redirect_apst;
      if ($proon_redirect_apst  ||  $proon_onetime_everybody) {
	$right_frame = '../plugins/proon/form.php';
	sqsession_register($right_frame, 'proon_onetime');
      }
      else {
	proon_actually_convert_apst($apst);
      }
    }
  }
  if ($proon_onetime_everybody) {
    $right_frame = '../plugins/proon/form.php';
    sqsession_register($right_frame, 'proon_onetime');
  }
}

function proon_actually_convert_apst($apst) {
  global $sent_folder, $folder_prefix;
  global $username, $data_dir;
  $sf = $sent_folder;
  if ($sf != ''  &&  isset($folder_prefix)  &&  strlen($folder_prefix) > 0) {
    $sf = substr($sf, strlen($folder_prefix));
  }
  $s[$sf] = $apst;
  setPref($data_dir, $username, PROON_O_F_DATE_SPAN, proon_to_pref($s));
  $s[$sf] = 'toss';
  setPref($data_dir, $username, PROON_O_F_TOSS_UNSEEN, proon_to_pref($s));
  proon_log('converted auto_prune_sent_threshold=' . $apst . " for folder $sf");

  global $proon_delete_apst;
  if ($proon_delete_apst) {
    setPref($data_dir, $username, 'auto_prune_sent_threshold', null);
  }
}

?>
