<?php

/*
 *	ProcFilter - Procmail filter plugin for SquirrelMail
 *	By Patrick Swieskowski and Rick Sheaffer
 */

	chdir('..');
	define('SM_PATH','../');



	// include compatibility plugin
	//
	if (defined('SM_PATH'))
		include_once(SM_PATH . 'plugins/compatibility/functions.php');
	else if (file_exists('../plugins/compatibility/functions.php'))
		include_once('../plugins/compatibility/functions.php');
	else if (file_exists('./plugins/compatibility/functions.php'))
		include_once('./plugins/compatibility/functions.php');



	if (compatibility_check_sm_version(1, 3))
	{
		include_once (SM_PATH . 'include/validate.php');
		include_once (SM_PATH . 'functions/page_header.php');
		include_once (SM_PATH . 'functions/imap.php');
		include_once (SM_PATH . 'include/load_prefs.php');
		include_once (SM_PATH . 'plugins/procfilter/procfilter_conf.php');
	}
	else
	{
		include_once ('../src/validate.php');
		include_once ('../functions/page_header.php');
		include_once ('../functions/imap.php');
		include_once ('../src/load_prefs.php');
		include_once ('../plugins/procfilter/procfilter_conf.php');
	}


	global $username, $key, $imapServerAddress, $imapPort;
	global $fields, $folders, $imapConnection, $imap_stream;
	global $recipies;

	compatibility_sqextractGlobalVar('onetimepad');
	compatibility_sqextractGlobalVar('delimiter');

	// get global variables for versions of PHP < 4.1
	//
	if (!compatibility_check_php_version(4, 1)) {
		global $HTTP_COOKIE_VARS, $HTTP_POST_VARS;
		$_COOKIE = $HTTP_COOKIE_VARS;
		$_POST = $HTTP_POST_VARS;
	}

	$key = $_COOKIE['key'];
	
	$fields = array("From", "Subject", "To", "Cc", "TO_");

	// figure out if we're already connected to IMAP server
	//
	if (!isset($imap_stream) && !isset($imapConnection)) {
		$imapConnection = sqimap_login($username, $key, $imapServerAddress, $imapPort, 0);
		$previously_connected = false;
	} elseif (isset($imapConnection)) {
		$previously_connected = true;
	} else {
		$previously_connected = true;
		$imapConnection = $imap_stream;
	}

	$boxes = sqimap_mailbox_list($imapConnection);

	if (!$previously_connected) 
		sqimap_logout($imapConnection);

	$folders = array();
	for ($i = 0; $i < count($boxes); $i++)
		if (!in_array('noselect', $boxes[$i]['flags']))
			array_push($folders, $boxes[$i]['unformatted']);

	$recipies = array();

	proc_get("/tmp/pmrc.$username");
	read_recipies("/tmp/pmrc.$username");

	if (array_key_exists('create_x', $_POST)) {

		// Create a new entry
		$new['field'] = $fields[$_POST['field']];
		$new['string'] = $_POST['string'];
		if (get_magic_quotes_gpc() == 1)
			$new['string'] = stripslashes($new['string']);
		$new['folder'] = $folders[$_POST['folder']];
		$new['action'] = $_POST['action'];
		array_push($recipies, $new);
		write_recipies("/tmp/pmrc.$username", "/tmp/npmrc.$username");
		proc_put("/tmp/npmrc.$username");
		unlink("/tmp/npmrc.$username");
	} else if (array_key_exists('modify_x', $_POST)) {

		// Modify an existing entry
		$recipies[$_POST['rule']]['field'] = $fields[$_POST['field']];
		$recipies[$_POST['rule']]['string'] = $_POST['string'];
		if (get_magic_quotes_gpc() == 1)
			$recipies[$_POST['rule']]['string'] = stripslashes($_POST['string']);
		$recipies[$_POST['rule']]['folder'] = $folders[$_POST['folder']];
		$recipies[$_POST['rule']]['action'] = $_POST['action'];
		write_recipies("/tmp/pmrc.$username", "/tmp/npmrc.$username");
		proc_put("/tmp/npmrc.$username");
		unlink("/tmp/npmrc.$username");
	} else if (array_key_exists('delete_x', $_POST)) {

		// Delete an entry
		$recipies = array_merge(array_slice($recipies, 0, $_POST['rule']), array_slice($recipies, $_POST['rule']+1));
		write_recipies("/tmp/pmrc.$username", "/tmp/npmrc.$username");
		proc_put("/tmp/npmrc.$username");
		unlink("/tmp/npmrc.$username");
	} else if (array_key_exists('up_x', $_POST)) {

		// Move an entry up
		if ($_POST['rule'] > 0) {
			$tmp = $recipies[$_POST['rule']];
			$recipies[$_POST['rule']] = $recipies[$_POST['rule']-1];
			$recipies[$_POST['rule']-1] = $tmp;
			write_recipies("/tmp/pmrc.$username", "/tmp/npmrc.$username");
			proc_put("/tmp/npmrc.$username");
			unlink("/tmp/npmrc.$username");
		}
	} else if (array_key_exists('down_x', $_POST)) {

		// Move an entry down 
		if ($_POST['rule'] < count($recipies)-1) {
			$tmp = $recipies[$_POST['rule']];
			$recipies[$_POST['rule']] = $recipies[$_POST['rule']+1];
			$recipies[$_POST['rule']+1] = $tmp;
			write_recipies("/tmp/pmrc.$username", "/tmp/npmrc.$username");
			proc_put("/tmp/npmrc.$username");
			unlink("/tmp/npmrc.$username");
		}
	}
		

	unlink("/tmp/pmrc.$username");

	displayPageHeader($color, 'None');
?>
<br>
<table width="95%" align=center border=0 cellpadding=2 cellspacing=0>
<tr><td align="center" bgcolor="<?php echo  $color[0] ?>">
	<b><?php echo _("Options") . " - " . _("Mail Filters"); ?></b>

<table width="100%" border=0 cellpadding=1 cellspacing=1>
<tr><td bgcolor="<?php echo  $color[4] ?>" align=center><br>
<table border=0 cellpadding=1 cellspacing=3>
<?php
	print_recipies();
?>
<form method=post action="procfilter_options.php">
<input type=hidden name="create.x" value="12">
<tr><td>
If <?php echo  fieldDropdown('') ?> contains <input type=text name=string size=10> then
<select name=action>
<option value=m>move</option>
<option value=c>copy</option>
</select>
to <?php echo  folderDropdown('') ?>
</td>
<td colspan=4 align=center><input type=image src="images/saveas.gif" border=0 name=create alt="save new"></td>
</tr>
</form>
</table>
<p><b>Notice:</b> Use of these filters may prevent the reading of mail in non-IMAP mail clients.
</td></tr>
</table>
</td></tr>
</table>
</body>
</html>

<?php
	// Display dropdown menu of field options

	function fieldDropdown($str) {
		global $fields;

		print("<select name=field>\n");

		for ($i = 0; $i < count($fields); $i++) {
			print("<option value=\"$i\"");
			if ($fields[$i] == $str)
				print(" selected");
			if ($fields[$i] == "TO_")
				print(">To or Cc</option>\n");
			else
				print(">$fields[$i]</option>\n");
		}

		print("</select>\n");
	}

	// Display dropdown menu of folder options

	function folderDropdown($str) {
		global $folders;

		print("<select name=folder>\n");

		for ($i = 0; $i < count($folders); $i++) {
			print("<option value=\"$i\"");
			if ($folders[$i] == $str)
				print(" selected");
			print(">$folders[$i]</option>\n");
		}
		
		print("</select>\n");
	}

	// Get the .procmailrc file

	function proc_get($localfile) {
		global $username, $key, $onetimepad, $imapServerAddress;
		compatibility_sqextractGlobalVar('onetimepad');
		if (!compatibility_check_php_version(4, 1)) {
			global $HTTP_COOKIE_VARS;
			$_COOKIE = $HTTP_COOKIE_VARS;
		}
		$key = $_COOKIE['key'];
		$password = OneTimePadDecrypt($key, $onetimepad);
	
		$conn = @ftp_connect($imapServerAddress);
		@ftp_login($conn, $username, $password);
		@ftp_get($conn, $localfile, ".procmailrc", FTP_ASCII) or touch($localfile);

		@ftp_close($conn);
	}

	// Put the .procmailrc file

	function proc_put($localfile) {
		global $username, $key, $onetimepad, $imapServerAddress;
		compatibility_sqextractGlobalVar('onetimepad');
		if (!compatibility_check_php_version(4, 1)) {
			global $HTTP_COOKIE_VARS;
			$_COOKIE = $HTTP_COOKIE_VARS;
		}
		$key = $_COOKIE['key'];
		$password = OneTimePadDecrypt($key, $onetimepad);
	
		$conn = ftp_connect($imapServerAddress);
		ftp_login($conn, $username, $password);
		ftp_put($conn, ".procmailrc", $localfile, FTP_ASCII);

		ftp_close($conn);
	}

	// Read the recipies from the .procmailrc file
	
	function read_recipies($localfile) {
		global $recipies;
	
		$fd = fopen($localfile, "r");
		while (!feof($fd) && $buf != "##Begin Procfilter Configuration -- Please do not edit by hand, use SquirrelMail")
			$buf = rtrim(fgets($fd));

		while (!feof($fd) && $buf != "##End Procfilter Configuration") {
			$buf = rtrim(fgets($fd));
			if (substr($buf, 0, 3) == "###") {
				$tmp = explode(" '' ", substr($buf, 3));
				$new['field'] = stripslashes($tmp[0]);
				$new['string'] = stripslashes($tmp[1]);
				$new['folder'] = stripslashes($tmp[2]);
				$new['action'] = stripslashes($tmp[3]);
				array_push($recipies, $new);
			}
		}

		fclose($fd);
	}

	// Write the recipes in the recipies array
	
	function write_recipies($oldfile, $newfile) {
		global $recipies;
		global $MAILDIR;
	
		$of = fopen($oldfile, "r");
		$nf = fopen($newfile, "w");

		$buf = rtrim(fgets($of));
		while (!feof($of) && $buf != "##Begin Procfilter Configuration -- Please do not edit by hand, use SquirrelMail") {
			fputs($nf, "$buf\n");
			$buf = rtrim(fgets($of));
		}


		fputs($nf, "##Begin Procfilter Configuration -- Please do not edit by hand, use SquirrelMail\n");
		fputs($nf, "MAILDIR=$MAILDIR # Default mail directory\n");

		for ($i = 0; $i < count($recipies); $i++) {
			$field = $recipies[$i]['field'];
			$string = $recipies[$i]['string'];
			$folder = $recipies[$i]['folder'];

			if ($recipies[$i]['action'] == "m")
				$action = ":";
			else
				$action = "c:";

			$ssfield = addslashes($recipies[$i]['field']);
			$ssstring = addslashes($recipies[$i]['string']);
			$ssfolder = addslashes($recipies[$i]['folder']);
			$ssaction = addslashes($recipies[$i]['action']);

			fputs($nf, "\n###${ssfield} '' ${ssstring} '' ${ssfolder} '' ${ssaction}\n");
			fputs($nf, ":0${action}\n* ^${field}.*${string}\n${folder}\n");
		}

		fputs($nf, "\n##End Procfilter Configuration\n");


		while (!feof($of) && $buf != "##End Procfilter Configuration")
			$buf = rtrim(fgets($of));

		while (!feof($of)) {
			$buf = fgets($of);
			fputs($nf, "$buf");
		}

		fclose($of);
		fclose($nf);
	}

	// Print the recipies

	function print_recipies() {
		global $recipies;

		for ($i = 0; $i < count($recipies); $i++) {
			$str = $recipies[$i]['string'];

			print("<form method=post action=\"procfilter_options.php\"><input type=hidden name=rule value=\"$i\">\n");
			print("<tr><td>\nIf ");
			fieldDropdown($recipies[$i]['field']);
			print(" contains <input type=text name=string size=10 value=\"$str\"> then ");
			print("<select name=action>\n");

			if ($recipies[$i]['action'] == "m")
				print("<option value=m selected>move</option>\n<option value=c>copy</option>\n");
			else
				print("<option value=m>move</option>\n<option value=c selected>copy</option>\n");

			print("</select>\n to ");
			folderDropdown($recipies[$i]['folder']);
			print("\n</td>\n");
			print("<td><input type=image src=\"images/save.gif\" border=0 name=modify alt=\"save\"></td>\n");
			print("<td><input type=image src=\"images/delete.gif\" border=0 name=delete alt=\"delete\"></td>\n");

			// Let's not display the move arrows if they're not needed
			if (count($recipies) == 1) {
				print("<td>&nbsp;</td>\n<td>&nbsp;</td>\n");
			} else if ($i == 0) {
				print("<td colspan=2 align=center><input type=image src=\"images/down.gif\" border=0 name=down alt=\"move down\"></td>\n");
			} else if ($i == count($recipies)-1) {
				print("<td colspan=2 align=center><input type=image src=\"images/up.gif\" border=0 name=up alt=\"move up\"></td>\n");
			} else {
				print("<td><input type=image src=\"images/up.gif\" border=0 name=up alt=\"move up\"></td>\n");
				print("<td><input type=image src=\"images/down.gif\" border=0 name=down alt=\"move down\"></td>\n");
			}

			print("</tr></form>\n");
		}	
	}
?>
