<?php

/**
  * SquirrelMail Password Forget Plugin
  * Copyright (C) 2004 Paul Lesneiwski <pdontthink@angrynerds.com>
  * This program is licensed under GPL. See COPYING for details
  *
  */


// include compatibility plugin
//
if (defined('SM_PATH'))
   include_once(SM_PATH . 'plugins/compatibility/functions.php');
else if (file_exists('../plugins/compatibility/functions.php'))
   include_once('../plugins/compatibility/functions.php');
else if (file_exists('./plugins/compatibility/functions.php'))
   include_once('./plugins/compatibility/functions.php');


/**
  * Determines if this plugin should be active 
  * for the current client
  *
  * @return boolean FALSE if this plugin should NOT
  *                 be active for the current client;
  *                 TRUE otherwise
  */
function check_client()
{

   global $known_clients;


   include_once (SM_PATH . 'plugins/password_forget/config.php');


   // get global variable for versions of PHP < 4.1
   //
   if (!compatibility_check_php_version(4,1)) 
   {
      global $HTTP_SERVER_VARS;
      $_SERVER = $HTTP_SERVER_VARS;
   }


   // if desired by admin, turn off functionality 
   // for known IP addresses
   //
   foreach ($known_clients as $addr)
      if (preg_match("/$addr/", $_SERVER['REMOTE_ADDR']))
         return FALSE;
 

   return TRUE;
 
}


/**
  * Inserts obfuscated password field
  *
  */
function password_forget_pre_do() 
{

   if (!check_client()) return;


   global $username_form_name, $password_form_name, $newUsername;
   
   $newUsername = GenerateRandomString(10, '', 3);
   $newPassword = GenerateRandomString(10, '', 3);
   while ($newPassword == $newUsername)
   {
      $newPassword = GenerateRandomString(10, 3);
   }
 
   echo "<input type=\"hidden\" name=\"login_username\" value=\"$newUsername\">\n";
   echo "<input type=\"hidden\" name=\"secretkey\" value=\"$newPassword\">\n";
   
   $username_form_name = $newUsername;
   $password_form_name = $newPassword;
}


/**
  * Decyphers obfuscated password field
  *
  */
function password_forget_post_do() 
{

   if (!check_client()) return;


   global $login_username, $secretkey;
   global $$login_username, $$secretkey;
  
   if (empty($$login_username))
      compatibility_sqextractGlobalVar($login_username);

   if (empty($$secretkey))
      compatibility_sqextractGlobalVar($secretkey);

   $login_username = $$login_username;
   $secretkey = $$secretkey;

}


?>
