<?php

/**
  * SquirrelMail Password Forget Plugin
  * Copyright (c) 2000-2001 Tyler Akins
  * Copyright (c) 2003-2008 Paul Lesniewski <paul@squirrelmail.org>
  * Licensed under the GNU GPL. For full terms see the file COPYING.
  *
  * @package plugins
  * @subpackage password_forget
  *
  */



/**
  * Validate that this plugin is configured correctly
  *
  * @return boolean Whether or not there was a
  *                 configuration error for this plugin.
  *
  */
function password_forget_check_configuration_do()
{

   // make sure base config is available
   //
   if (!password_forget_init())
   {
      do_err('Password Forget plugin is missing its main configuration file', FALSE);
      return TRUE;
   }

}



/**
  * Initialize this plugin (load config values)
  *
  * @return boolean FALSE if no configuration file could be loaded, TRUE otherwise
  *
  */
function password_forget_init()
{

   if (!@include_once (SM_PATH . 'config/config_password_forget.php'))
      if (!@include_once (SM_PATH . 'plugins/password_forget/config.php'))
         if (!@include_once (SM_PATH . 'plugins/password_forget/config_default.php'))
            return FALSE;

   return TRUE;

/* ----------  This is how to do the same thing using the Compatibility plugin
   return load_config('password_forget',
                      array('../../config/config_password_forget.php',
                            'config.php',
                            'config_default.php'),
                      TRUE, TRUE);
----------- */

}



/**
  * Determines if this plugin should be active 
  * for the current client
  *
  * @return boolean FALSE if this plugin should NOT
  *                 be active for the current client;
  *                 TRUE otherwise
  */
function check_client()
{

   global $known_clients;
   password_forget_init();


   // if desired by admin, turn off functionality 
   // for known IP addresses
   //
   sqGetGlobalVar('REMOTE_ADDR', $remote_address, SQ_SERVER);
   foreach ($known_clients as $addr)
      if (preg_match("/$addr/", $remote_address))
         return FALSE;
 

   return TRUE;
 
}


/**
  * Inserts obfuscated password field
  *
  */
function password_forget_pre_do() 
{

   if (!check_client()) return;

   global $username_form_name, $password_form_name,
          $newUsername, $newPassword;
   
   $newUsername = GenerateRandomString(10, '', 5);
   $newPassword = GenerateRandomString(10, '', 5);
   while ($newPassword == $newUsername)
   {
      $newPassword = GenerateRandomString(10, '', 5);
   }
 
   $output = addHidden('login_username', $newUsername)
           . addHidden('secretkey', $newPassword);
   
   $username_form_name = $newUsername;
   $password_form_name = $newPassword;

   if (check_sm_version(1, 5, 2))
      return array('login_top' => $output);
   else
      echo $output;
}


/**
  * Decyphers obfuscated password field
  *
  */
function password_forget_post_do() 
{

   if (!check_client()) return;

   global $login_username, $secretkey,
          $$login_username, $$secretkey;
  
   if (empty($$login_username))
      sqGetGlobalVar($login_username, $$login_username, SQ_FORM);

   if (empty($$secretkey))
      sqGetGlobalVar($secretkey, $$secretkey, SQ_FORM);

   $login_username = $$login_username;
   $secretkey = $$secretkey;

}



