<?php
/**
 * functions for naguser plugin
 *
 * @copyright (c) 2004 The SquirrelMail Project Team
 * @license http://opensource.org/licenses/gpl-license.php GNU Public License
 * @version $Id: functions.php,v 1.4 2004/07/31 11:00:03 tomas Exp $
 * @package plugins
 * @subpackage naguser
 */

/* add form functions */
if (file_exists(SM_PATH . 'functions/forms.php')) {
    include_once(SM_PATH . 'functions/forms.php');
} else {
    include_once(SM_PATH . 'plugins/naguser/forms.php');
}

/* load defaults */
global $nonag_ips, $nonag_names, $nonag_users;
global $tos_url, $tos_url2, $tos_url_relative, $repeat_nag_time;
$nonag_ips='127.0.0.1';
$nonag_names='';
$nonag_users='';
$tos_url="../plugins/naguser/tos.php";
$tos_url2='';
$tos_url_relative=true;
$repeat_nag_time=86400;

/* load config */
if (file_exists(SM_PATH . 'config/naguser_config.php')) {
    include_once(SM_PATH . 'config/naguser_config.php');
} elseif (file_exists(SM_PATH . 'plugins/naguser/config.php')) {
    include_once(SM_PATH . 'plugins/naguser/config.php');
}

function show_naguser_form($called_by_plugin=false) {
    global $color, $username, $data_dir, $PHP_SELF, $tos_url, $tos_url_relative;

    if ($called_by_plugin && $tos_url_relative) {
      $final_tos_url="../" . $tos_url;
    } else {
      $final_tos_url=$tos_url;
    }

    // Set domain
    bindtextdomain ('naguser', SM_PATH . 'locale');
    textdomain ('naguser');
    
print "<br><center><b>";
echo _("Rules of engagement");
print "</b></center><br>\n";
print "<center><table bgcolor=\"".$color[3]."\" width=\"100%\" border=\"1\" cellpadding=\"2\">";
print "<tr><td bgcolor=\"".$color[3]."\"><br>\n";
print "<center><table width=\"95%\" border=\"1\" bgcolor=\"".$color[3]."\">\n";
print "<tr><td bgcolor=\"".$color[4]."\"><b>";
echo _("You have to read and understand program usage rules:");
print "</b><br />\n";

print "</td></tr><tr><td>\n";
echo "<iframe src=\"$final_tos_url\" width=\"100%\" height=\"200\" scrolling=\"auto\">";
echo "<p>" . _("Your browser does not support inline frames. Please read related document by checking usage instructions.") . "</p>";
echo "<p><a href=\"$final_tos_url\"><b>" . _("Usage instructions") . "</b></a></p>";
echo "</iframe>";
print "<br /></td></tr></table></center><br>\n";

print addForm($PHP_SELF);
print "<center>".
      addSubmit(_("Yes, I understand"),'submit').
      "</center><br /></form>\n";

print "</td></tr></table></center>";
}

function naguser_check() {
    global $data_dir, $username;
    
    if (sqgetGlobalVar('submit',$submit,SQ_POST)) {
      setPref($data_dir,$username,"naguser",time());
      return true;
    }
    
    if (naguser_check_username()) return true;
    if (naguser_check_ip()) return true;

    $naguser = getPref($data_dir, $username, 'naguser','');

    // get nag time
    $timeframe=get_repeat_nag_time();

    // Das Feld heisst naguser und sollte einen timestamp enthalten
    //    if( $naguser == '' || ( time() - $naguser > 3*30*24*60*60 ) )
    if( $naguser == '' || ( time() - $naguser > $timeframe ) ) {
      return false;
    } else {
      return true;
    }
}

/**
 * Check if user does not need to be nagged
 *
 * @return boolean true if user is listed in nonag_users.
 */
function naguser_check_username() {
    global $nonag_users, $username;

    if ($nonag_users=='') return false;

    $nonag_users_array=explode(",",$nonag_users);

    if (in_array($username,$nonag_users_array) ) return true;
    
    return false;
}

/**
 * Check if remote ip address does not need to be nagged
 *
 * @return boolean true if address is listed in nonag_ips.
 */
function naguser_check_ip() {
    global $nonag_ips, $nonag_names;
    
    if (! sqgetGlobalVar('REMOTE_ADDR',$remote_ip,SQ_SERVER)) return false;

    if ($nonag_ips=='') return false;

    $nonag_ips_array=explode(",",$nonag_ips);
    $remote_ip_array=explode(".",$remote_ip);
    $remote_subnet_c=$remote_ip_array[0] . '.' . 
      $remote_ip_array[1] . '.' . $remote_ip_array[2] . '.';

    if ( in_array($remote_ip,$nonag_ips_array) || 
         in_array($remote_subnet_c,$nonag_ips_array)) return true;

    if ($nonag_names!='') {
        $nonag_names_array=explode(',',$nonag_names);

        // don't try to resolve names if webserver already did it
        if (! sqgetGlobalVar('REMOTE_HOST',$remote_name,SQ_SERVER))
            $remote_name=gethostbyaddr($remote_ip);

        // stop processing if host does not have reverse ip address
        // or resolution fails
        if ($remote_name == $remote_ip)
            return false;

        // check name match
        if (in_array($remote_name,$nonag_names_array))
            return true;

        // check domain matches
        foreach ($nonag_names_array as $nonag_name) {
            if ($nonag_name[0]!='.')
                $nonag_name='.'.$nonag_name;
            $pNonag_name=str_replace('.','\.',$nonag_name);
            if (preg_match("/".$pNonag_name."$/i",$remote_name))
                return true;
        }
    }

    return false;
}

/**
 * Repeat nag time
 *
 * @return integer repeated nagging time in seconds
 */
function get_repeat_nag_time() {
    global $repeat_nag_time;
    
    // default to days
    if (is_int($repeat_nag_time))
      return $repeat_nag_time*86400 ;

    if (! is_string($repeat_nag_time))
      return 86400;

    $measure=strtolower(substr($repeat_nag_time,-1));
    $number=(int) substr($repeat_nag_time,0,-1);

    switch ($measure) {
    case 'm':
      $ret=$number*60;
      break;
    case 'h':
      $ret=$number*3600;
      break;
    case 'd':
      $ret=$number*86400;
      break;
    default:
      $ret=86400;
    }
    return $ret;
}
?>