<?php
/**
 * Default configuration file for naguser plugin
 *
 * @copyright (c) 2004 The SquirrelMail Project Team
 * @license http://opensource.org/licenses/gpl-license.php GNU Public License
 * @version $Id: config_default.php,v 1.3 2004/05/13 16:54:10 tomas Exp $
 * @package plugins
 * @subpackage naguser
 */

/**
 * Comma delimited list of addresses that don't need nagging.
 *
 * You can also use C class subnets by removing last number from address.
 * for example. '192.168.0.' adds 192.168.0.0/24 subnet.
 * @global string $nonag_ips
 */
$nonag_ips='127.0.0.1';

/**
 * Comma delimited list of users.
 *
 * @global string $nonag_users
 */
$nonag_users='';

/**
 * Main page with usage instructions
 *
 * Don't use relavite urls if you can (it might break in some places)
 * Don't use external servers if you can (some browsers might refuse to load it)
 * If url is relative, it has to be relative to SquirrelMail's src directory
 * Remember to change $tos_url_relative if you use non-relative url
 * @global string $tos_url
 */
$tos_url="../plugins/naguser/tos.php";

/**
 * Secondary page with usage instructions
 *
 * it is used by tos.php
 * @global string $tos_url2
 */
$tos_url2='';

/**
 * Relative url control
 *
 * Use true if you have to use relative value in $tos_url.
 * Use false if value is not relative
 * @global boolean $tos_url_relative
 */
$tos_url_relative=true;

/**
 * Repeat nagging time in days
 *
 * it is possible to use suffixes in order to set time in minutes (m), hours (h) or days(d).
 * if you use suffixes - wrap setting with quotes.
 * for example: $repeat_nag_time='1d';
 * If you misconfigure something - plugin defauls to 1 day nagging
 * @global mixed
 */
$repeat_nag_time=86400;
?>