<?php
/**
 * naguser plugin - setup script
 *
 * @copyright (c) 2004 The SquirrelMail Project Team
 * @license http://opensource.org/licenses/gpl-license.php GNU Public License
 * @version $Id: $
 * @package plugins
 * @subpackage naguser
 */

if (!defined('SM_PATH'))  {
    define('SM_PATH','../../');
}

/**
 * Init plugin
 * @access private
 */
function squirrelmail_plugin_init_naguser() {
    global $squirrelmail_plugin_hooks;

    /* these hooks stop user from:
        seeing message listing
	seeing message text
	using compose form
	using message search form
	using help
    */
    $squirrelmail_plugin_hooks['right_main_after_header']['naguser'] = 'naguser_form';
    $squirrelmail_plugin_hooks['read_body_menu_top']['naguser'] = 'naguser_form';
    $squirrelmail_plugin_hooks['compose_form']['naguser'] = 'naguser_form';
    $squirrelmail_plugin_hooks['search_before_form']['naguser'] = 'naguser_form';
    $squirrelmail_plugin_hooks['help_top']['naguser'] = 'naguser_form';

    // these hooks does not stop user from using interface.
    // They only display forms below regural page output.
    $squirrelmail_plugin_hooks['addressbook_bottom']['naguser'] = 'naguser_form';
    $squirrelmail_plugin_hooks['folders_bottom']['naguser'] = 'naguser_form';

    /* you can add do_hook('naguser') or do_hook('naguser2') code to any plugin or file that is called directly */
    $squirrelmail_plugin_hooks['naguser']['naguser'] = 'naguser_form';
    $squirrelmail_plugin_hooks['naguser2']['naguser'] = 'naguser_form2';
}

/**
 * Show form for main scripts (src/*.php)
 * @access private
 */
function naguser_form() {
    include_once(SM_PATH . 'plugins/naguser/functions.php');
    if ( ! naguser_check() ) {
	show_naguser_form();
        exit;
    }
}

/**
 * Show form for plugins (plugins/pluginname/*.php)
 * @access private
 */
function naguser_form2() {
    include_once(SM_PATH . 'plugins/naguser/functions.php');
    if ( ! naguser_check() ) {
	show_naguser_form(true);
        exit;
    }
}

/**
 * Return program version
 * @access private
 * @return string program version
 */
function naguser_version() {
    return '1.0';
}
?>