<?php

/**
  * login_form.tpl
  *
  * Template for login page controls added by the Multilogin plugin
  *
  * The following variables are available in this template:
  *      + $select_options                      - an array of the server names
  *                                               to be used as server selection
  *                                               options (values and text both)
  *      + $default_option                      - the option that should be selected
  *      + $show_remember_login_server_checkbox - boolean value indicating if
  *                                               checkbox should be shown
  *      + $login_server_checkbox_checked       - boolean value indicating if
  *                                               checkbox should be checked
  *                                               by default or not (only 
  *                                               relevant if checkbox is shown
  *                                               in the first place)
  *
  * @copyright &copy; 1999-2007 The SquirrelMail Project Team
  * @license http://opensource.org/licenses/gpl-license.php GNU Public License
  * @version $Id$
  * @package squirrelmail
  * @subpackage plugins
  */


// retrieve the template vars
//
extract($t);


?>

<tr>
   <td colspan="2">
      <br />
      <center>
      <table width="350">
         <tr>
            <td bgcolor="#dcdcdc">
               <table width="100%">
                  <tr>
                     <td width='30%' align="right"><?php echo _("Log in to"); ?>:</td>
                     <td width="*" align="left">
                        <select name="loginServer">
                           <?php foreach ($select_options as $option) echo '<option value="' . $option . '"' . ($default_option == $option ? ' selected' : '') . '>' . $option . "</option>\n"; ?>
                        </select>
                     </td>
                  </tr>
               </table>
            </td>
         </tr>
         <?php if ($show_remember_login_server_checkbox) { ?>
         <tr>
            <td>
               <center>
               <input type='checkbox' <?php if ($login_server_checkbox_checked) { ?>checked<?php } ?> name='rememberLoginServer' id='remember'><label for='remember'><?php echo _("Remember login server"); ?></label>
               </center>
            </td>
         </tr>
         <?php } ?>
      </table>
      </center>
   </td>
</tr>

