<?php

/**
  * SquirrelMail Move All Messages Plugin
  *
  * Copyright (c) 2011-2011 Paul Lesniewski <paul@squirrelmail.org>
  * Copyright (c) 2002 Barton Hodges <barton@gcmcomputers.com>
  *
  * Licensed under the GNU GPL. For full terms see the file COPYING.
  *
  * @package plugins
  * @subpackage move_all_messages
  *
  */



/**
  * Initialize this plugin (load config values)
  *
  * @param boolean $debug When TRUE, do not suppress errors when including
  *                       configuration files (OPTIONAL; default FALSE)
  *
  * @return boolean FALSE if no configuration file could be loaded, TRUE otherwise
  *
  */
function move_all_messages_init($debug=FALSE)
{

   if ($debug)
   {
      if (!include_once(SM_PATH . 'config/config_move_all_messages.php'))
         if (!include_once(SM_PATH . 'plugins/move_all_messages/config.php'))
            if (!include_once(SM_PATH . 'plugins/move_all_messages/config_default.php'))
               return FALSE;
   }
   else
   {
      if (!@include_once(SM_PATH . 'config/config_move_all_messages.php'))
         if (!@include_once(SM_PATH . 'plugins/move_all_messages/config.php'))
            if (!@include_once(SM_PATH . 'plugins/move_all_messages/config_default.php'))
               return FALSE;
   }


   return TRUE;

}



/**
  * Show move all button on mailbox list page
  *
  * @param array $buttons The list of buttons being added to when
  *                       using 1.5.2+
  *
  */
function show_move_all_messages_button(&$buttons)
{

   global $move_all_messages_button_text, $move_all_messages_button_title_text,
          $username, $data_dir;


   sq_change_text_domain('move_all_messages');


   if (!move_all_messages_init())
   {
      $move_all_messages_button_text = _("Move All");
      $move_all_messages_button_title_text = _("Move ALL messages out of this folder to the destination folder");
   }



   // display the purge button?
   //
   if (check_sm_version(1, 5, 2))
      $buttons['mamMoveAll'] = array('value' => _($move_all_messages_button_text),
                                     'type' => 'submit',
                                     'extra_attrs' => array('title' => _($move_all_messages_button_title_text)));
   else if (check_sm_version(1, 5, 1))
      $buttons[1]['mamMoveAll'] = array(0 => _($move_all_messages_button_text),
                                        1 => 'submit');
   else
      echo '<input type="submit" name="mamMoveAll" title="' . _($move_all_messages_button_title_text) . '" value="' . _($move_all_messages_button_text) . "\" />\n";



   sq_change_text_domain('squirrelmail');

}



function plugin_move_all_messages_move_messages_before()
{
   global $imapConnection;
   global $moveAllMessages;
   global $numMessages;
   global $msg;
   if ( $numMessages > 0 && isset($moveAllMessages) && $moveAllMessages==1 ) {
      $msg = range(1, $numMessages);
      $msgs_list = sqimap_get_small_header_list($imapConnection, $msg, $issent);
   }
}



/**
  * Perform any needed actions when clicked from message list page
  * 
  * @param array (only used in 1.5.2) An array consisting of: button name (provided
  *                                   by an external caller - ignore for now), the
  *                                   mailbox cache, the account number, the mailbox
  *                                   name (ignore for now), and a UID list (should
  *                                   be null when we care about handling any actions).
  *                                   
  * @return boolean (only in 1.5.2) TRUE when a button action
  *                                 was handled, FALSE otherwise
  *                                 
  */
function move_all_messages_handle_button_click($args)
{

   // need to move messages?  do it now then
   //
   if (sqGetGlobalVar('mamMoveAll', $mamMoveAll, SQ_FORM) && !empty($mamMoveAll))
   {

      global $imapConnection;


      // 1.5.x
      //
      if (check_sm_version(1, 5, 2))
      {

         if (isset($args[1]['UIDSET'][0]) && is_array($args[1]['UIDSET'][0]))
         {
            $error = handleMessageListForm($imapConnection, $args[1], 'move', $args[1]['UIDSET'][0]);
            if (!empty($error))
            {
               // TODO: use correct error output mechanism
               //
               echo $error;
               exit;
            }

            return TRUE;
         }

//TODO: else how to rebuild UIDSET? do we / can we care?
      }


      // 1.4.x
      //
      else
      {
         global $mbx_response, $msg, $moveButton;
         $msg = sqimap_get_php_sort_order($imapConnection, $mbx_response);
         $moveButton = TRUE;
         return;
      }

   }

}



