<?php 
/** 
 * mini window plugin for SquirrelMail
 *
 * This is the whole thing except functions
 * which are in functions.php. This page has
 * two phases the expandable folders display
 * and the message reading page.
 * @copyright (c) 2002-2004 Jason Munro
 * @copyright (c) 2005 The SquirrelMail Project Team
 * @license http://opensource.org/licenses/gpl-license.php GNU Public License
 * @version $Id: mini.php,v 1.7 2005/07/27 16:15:59 tokul Exp $
 * @package sm-plugins
 * @subpackage mini
 */

/** @ignore */
if (!defined('SM_PATH')) define('SM_PATH','../../');

/* include what we need */
include_once(SM_PATH . 'include/validate.php');
include_once(SM_PATH . 'functions/imap.php');
include_once(SM_PATH . 'functions/imap_utf7_local.php');
include_once(SM_PATH . 'plugins/mini/functions.php');

if (!isset($uid_support)) {
    $uid_support = true;
}

/* get our global vars */
$delimiter = $_SESSION['delimiter'];
$key = $_COOKIE['key'];
$username = $_SESSION['username'];
$onetimepad = $_SESSION['onetimepad'];
$length = strlen($default_folder_prefix);
if (!isset($PHP_SELF)) {
    $PHP_SELF = strip_tags($_SERVER['PHP_SELF']);
}
//$mini_refresh = getPref($data_dir, $username, 'mini_refresh', '0');
//$mini_width = getPref($data_dir, $username, 'mini_width', '380');
//$mini_text_size = getPref($data_dir, $username, 'mini_text_size', '1');
if ($mini_text_size == '1') {
    $bsm = "<small>";
    $esm = "</small>";
} elseif ($mini_text_size == '0') {
    $bsm = "<small><small>";
    $esm = "</small></small>";
} elseif ($mini_text_size == '2') {
    $bsm = "";
    $esm = "";
}

$imapConn = sqimap_login($username,$key,$imapServerAddress,$imapPort,10,$onetimepad);

/* if we are keeping the message as new */
if (isset($_GET['mini_keep_as_new']) &&
    isset($_GET['box']) &&
    isset($_GET['mini_id'])) {
    $box = urldecode($_GET['box']);
    sqimap_mailbox_select($imapConn, $box, true, false, false);
    sqimap_toggle_flag($imapConn, array($_GET['mini_id']),'\Seen',false,true);
}

bindtextdomain('mini',SM_PATH .'locale');
textdomain('mini');

$boxes = get_mini_list($imapConn);

/* check collapse status and adjust vars as need be */
if (isset($_GET['mini_collapse'])) {
   $name = $_GET['mini_collapse'];
   $_SESSION[$name] = 'off'; 
}
if (isset($_GET['mini_read'])) {
    $link = _("Back");
}
else {
    $link = _("Refresh");
}

/**
 * FIXME: try html page header functions.
 * html goodness
 */
echo "<html><head><title>"._("Mini SquirrelMail")."</title>\n";
if ($mini_refresh > 0 && !isset($_GET['mini_read'])) {
    echo "<meta HTTP-EQUIV=i\"Pragma\" CONTENT=\"no-cache\">\n".
         "<meta HTTP-EQUIV=\"REFRESH\" CONTENT=\"$mini_refresh;URL=mini.php\">\n";
}
echo "</head><body bgcolor=\"$color[4]\" text=\"$color[8]\" link=\"$color[7]\" ".
     "alink=\"$color[7]\" vlink=\"$color[7]\">\n".
     "<table width=\"100%\" bgcolor=\"$color[9]\" cellpadding=4><tr>".
     "<td align=left>\n".
     "$bsm<b><a href=\"mini.php\">$link</a>\n".
     "</b>$esm</td><td align=right><small><b>\n".
     "<i>"._("Mini SquirrelMail")."</i>&nbsp;&nbsp;\n".
     "</b></small></td></tr><tr><td colspan=2 bgcolor=\"$color[4]\">\n".
     "<center><table width=\"99%\" border=0 bgcolor=\"$color[4]\"".
     "cellspacing=0 cellpadding=0>\n";


/* if we are reading a message */
if (isset($_GET['mini_read'])) {
    $id = (int) $_GET['id'];
    $box = $_GET['box'];

    /* select the mailbox */
    sqimap_mailbox_select($imapConn, $box, true, false, false);

    /**
     * headers can be limited only in 1.5.x. use only two arguments 
     * in order to be compatible with 1.4.x and 1.5.x function syntax.
     */
    // $fetch_results = sqimap_get_small_header_list($imapConn, $ids, array('SUBJECT','FROM'),array());
    $fetch_results = sqimap_get_small_header_list($imapConn, array($id));

    $res_id = ( check_sm_version(1,5) ? $id : 0);
    if (isset($fetch_results[$res_id]['SUBJECT']) && $fetch_results[$res_id]['SUBJECT']!='') {
        $subject=decodeHeader($fetch_results[$res_id]['SUBJECT']);
    } elseif (isset($fetch_results[$res_id]['subject']) && $fetch_results[$res_id]['subject']!='') {
        $subject=decodeHeader($fetch_results[$res_id]['subject']);
    } else {
        $subject=_("No subject");
    }
    if (isset($fetch_results[$res_id]['FROM']) && $fetch_results[$res_id]['FROM']!='') {
        $sender=decodeHeader($fetch_results[$res_id]['FROM']);
    } elseif (isset($fetch_results[$res_id]['from']) && $fetch_results[$res_id]['from']!='') {
        $sender=decodeHeader($fetch_results[$res_id]['from']);
    } else {
        $sender=_("No sender");
    }
    $mini_message = mini_message ($imapConn, $box, $id);
    echo "<tr><td>$bsm<b>"._("Subject")."</b>$esm</td><td>\n".
         "$bsm<b>"._("From")."</b>$esm</td></tr>\n".
         "<tr><td width=\"50%\">$bsm$subject$esm</td><td width=\"50%\">$bsm$sender$esm</td></tr>".
         "</table></td></tr></table></center>\n".
         "<br><table width=\"100%\" bgcolor=\"$color[0]\"><tr>".
         "<td align=center>$mini_message</td></tr></table></center>".
         "<center>$bsm<b><a href=\"mini.php\">"._("Back")."</a>&nbsp;&nbsp;&nbsp;".
         "<a href=\"mini.php?mini_keep_as_new=yes&mini_id=$id&box=".
         urlencode($box)."\">"._("Keep as new")."</a>$esm</b></center>\n";
    // close imap connection
    sqimap_logout($imapConn);
    exit;
}

/* finish all the tables. */
echo "<tr><td align=center>$bsm<b>&nbsp;&nbsp;&nbsp;"._("Folder")."&nbsp;&nbsp;".
     "</b>$esm</td><td align=center>$bsm<b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;".
     _("New Mail")."</b>$esm</td></tr><tr><td colspan=2 align=center>$bsm\n".
     "<table width=\"99%\" bgcolor=\"$color[0]\" border=0>\n";

/* loop through boxes and either display summary or add in the details if selected */
if (count($boxes) > 0) {
    foreach($boxes as $index=>$value) {
        if ($index != 'INBOX') {
            $index_dsp = imap_utf7_decode_local(substr($index,$length));
        }
        else {
            $index_dsp = _("INBOX");
        }
        echo "<tr bgcolor=\"$color[0]\">\n".
             "<td width=\"50%\">";
        if ((isset($_GET['mini_expand']) && $index == substr($_GET['mini_expand'],7)) ||
            (isset($_SESSION['expand_'.$index]) && $_SESSION['expand_'.$index] == 'on')) {
            echo "<a style=\"text-decoration:none\" ".
                 "href=\"mini.php?mini_collapse=expand_".urlencode($index).
                 "\">-</a><b>&nbsp;$bsm<font color=\"$color[6]\">".
                 $index_dsp."</font>$esm</b></td>\n".
                 "<td width=\"50%\" align=center>$bsm<font color=\"$color[6]\">".
                 count($value)."</font>$esm</b></td></tr>\n";
            $mini_headers  = get_mini_headers ($imapConn, $index, $value); 
            echo "<tr><td bgcolor=\"$color[5]\">$bsm".
                 "<b>"._("Subject")."</b>$esm</td>\n".
                 "<td bgcolor=\"$color[5]\">$bsm".
                 "<b>"._("From")."</b>$esm</td></tr>\n";
            foreach($mini_headers as $id=>$header_value) {
                echo "<tr bgcolor=\"$color[4]\"><td width=\"50%\">".
                     "$bsm<a href=\"mini.php?id=$id&amp;box=".urlencode($index)."&amp;mini_read=yes".
                     "\" style=\"text-decoration:none\" ".
                     $header_value."$esm</td></tr>\n";
            }
        }
        else {
            echo "<a style=\"text-decoration:none\" href=\"mini.php?mini_expand=expand_".
                 urlencode($index)."\">+</a><b>&nbsp;$bsm<font color=\"$color[6]\">".
                 $index_dsp."</font>$esm</b></td><td width=\"50%\" align=center>".
                 "$bsm<font color=\"$color[6]\">".count($value)."</font>$esm".
                 "</b></td></tr>\n";
        } 
    }
} else {
    echo '<tr><td align=center>'._("No New Messages")."</td></tr>\n";
}

// close imap connection
sqimap_logout($imapConn);

/* do our session stuff for collapsed folder contents here.*/
if (isset($_GET['mini_expand'])) {
    $value = 'on';
    $name  = $_GET['mini_expand'];
    $_SESSION[$name] = $value;
}

/* close up shop */
echo "</table>$bsm<br>$esm</td></tr></table></center>\n".
     "</td></tr></table></center>";
echo '<br><center><input type="button" name="close" value="'._("Close").'"'.
     " onClick=\"self.close()\"></center>\n";
echo "</body></html>\n";
?>
