<?php


/**
  * Initialize this plugin (load config values)
  *
  * @return boolean FALSE if no configuration file could be loaded, TRUE otherwise
  *
  */
function mark_read_init() {

   if (!@include_once (SM_PATH . 'plugins/mark_read/config.php'))
      if (!@include_once (SM_PATH . 'plugins/mark_read/config.sample.php'))
         return FALSE;

   return TRUE;

}

// Display mark_read links on target folders
//
function mark_read_show_link_do($parms) {

   global $data_dir, $username, $default_folders_to_show_mark_read_link,
          $default_mark_read_display, $default_mark_read_displayall,
	  $default_mark_read_display_is_short, $default_mark_read_display_upper,
	  $default_user_mark_read_separator,
	  $default_user_mark_read_brackets;

   include_once(SM_PATH . 'functions/i18n.php');
   bindtextdomain('mark_read', SM_PATH . 'locale');
   textdomain('mark_read');
   
   $numMessages = $parms[0];
   $real_box = $parms[1];
   $imapConnection = $parms[2];


   mark_read_init();


   // grab preferences
   //
   $allFolders = getPref($data_dir, $username, 'mark_read_show_link', '');
   $mark_read_display = intval(getPref($data_dir, $username, 'mark_read_display', $default_mark_read_display));
   $mark_read_display_is_short = intval(getPref($data_dir, $username, 'mark_read_display_is_short', $default_mark_read_display_is_short));
   $user_mark_read_brackets = intval(getPref($data_dir, $username, 'user_mark_read_brackets', $default_user_mark_read_brackets));
   $user_mark_read_separator = intval(getPref($data_dir, $username, 'user_mark_read_separator', $default_user_mark_read_separator));
   $mark_read_display_upper = intval(getPref($data_dir, $username, 'mark_read_display_upper', $default_mark_read_display_upper));

   // load default folders if none have previously been chosen
   //
   if ($allFolders == 'NONE') $allFolders = '';
   else if ($allFolders == '')
   {
      $allFolders = implode('###', $default_folders_to_show_mark_read_link);
   }
   $mark_read_show_link = explode('###', $allFolders);

      $show_read=_("read");
      $show_unread=_("unread");

      if( $mark_read_display_is_short == 1 ) {
       $show_unread=$show_unread{0};
       $show_read=$show_read{0};
      }

      if( $mark_read_display_upper == 1 ) {
      $show_read=strtoupper($show_read);
      $show_unread=strtoupper($show_unread);
      }

	switch($user_mark_read_separator)
	{
        case '0' :
                $separator="";
                break;
        case '1' :
                $separator="/";
                break;
        case '2' :
                $separator="-";
                break;
        case '3' :
                $separator="_";
                break;
        case '4' :
                $separator="\\";
                break;
        case '5' :
                $separator="|";
                break;
        case '6' :
                $separator="#";
                break;
        case '7' :
                $separator="+";
                break;
        case '8' :
                $separator=" ";
                break;
	}

   if (empty($numMessages)) {
      $numMessages = sqimap_get_num_messages($imapConnection, $real_box);
   }
   if ($numMessages > 0 && in_array($real_box, $mark_read_show_link)) {
      $urlMailbox = urlencode($real_box);
      $display = '';

      if( ($mark_read_display & READ) > 0 ) $display .= "<A HREF=\"../plugins/mark_read/mark_read.php?mailbox=$urlMailbox&mark=read\" title=\""._("mark all messages in this folder as read")."\">".$show_read."</A>";
      if( ($mark_read_display & (READ+UNREAD)) == (READ+UNREAD) ) $display .= $separator; 
      if( ($mark_read_display & UNREAD) > 0 ) $display .= "<A HREF=\"../plugins/mark_read/mark_read.php?mailbox=$urlMailbox&mark=unread\" title=\""._("mark all messages in this folder as unread")."\">".$show_unread."</A>"; 

        switch($user_mark_read_brackets)
        {
        case '1' :
                $display="(".$display.")";
                break;
        case '2':
                $display="[".$display."]";
                break;
        case '3':
                $display="{".$display."}";
                break;
        case '4':
                $display="&lt;".$display."&gt;";
                break;
        case '5':
                $display="-".$display."-";
                break;
        }

      return (($mark_read_display > NONE)?"<small>&nbsp;$display</small>":"");

   }

   bindtextdomain('squirrelmail', SM_PATH . 'locale');
   textdomain('squirrelmail');

}

// Display mark all read link
//
function mark_read_do_mark_all_read() {

   global $data_dir, $username, $default_folders_to_show_mark_read_link,
          $default_mark_read_display, $default_mark_read_displayall,
          $default_mark_read_display_is_short, $default_mark_read_display_upper,
          $default_user_mark_read_separator,
          $default_user_mark_read_brackets;

  include_once(SM_PATH . 'functions/i18n.php');
  bindtextdomain('mark_read', SM_PATH . 'locale');
  textdomain('mark_read');


  $mark_read_displayall = getPref($data_dir, $username, 'mark_read_displayall', $default_mark_read_displayall);
  if( $mark_read_displayall == 1 ) { 
    $mark_read_display = intval(getPref($data_dir, $username, 'mark_read_display', $default_mark_read_display));
    $display = '';
    if( ($mark_read_display & READ) > 0 ) $display .= "<A HREF=\"../plugins/mark_read/mark_read.php?markallread=1&mark=read\" title=\""._("mark all messages in the above folders as read")."\">"._("read")."</A>";
    if( ($mark_read_display & (READ+UNREAD)) == (READ+UNREAD) ) $display .= '/'; 
    if( ($mark_read_display & UNREAD) > 0 ) $display .= "<A HREF=\"../plugins/mark_read/mark_read.php?markallread=1&mark=unread\" title=\""._("mark all messages in the above folders as unread")."\">"._("unread")."</A>"; 
    echo (($mark_read_display > NONE)?"<hr><small>&nbsp;"._("mark all folders")." $display</small>":"");
  }
  
  bindtextdomain('squirrelmail', SM_PATH . 'locale');
  textdomain('squirrelmail');
  
}

// This is the text that appears on the option page
//
function mark_read_show_options_do() {

   global $username, $data_dir, $color, $user_mark_read_link, 
          $default_mark_read_display, $default_mark_read_displayall, 
          $default_folders_to_show_mark_read_link,
          $default_mark_read_display_is_short, $default_mark_read_display_upper,
          $default_user_mark_read_separator,
          $default_user_mark_read_brackets;

  include_once(SM_PATH . 'functions/i18n.php');
  bindtextdomain('mark_read', SM_PATH . 'locale');
  textdomain('mark_read');

   // grab new settings if user had just pressed Save
   //
   global $mark_read_form;
   sqGetGlobalVar('mark_read_form', $mark_read_form);
   if (isset($mark_read_form) && $mark_read_form)
   {

      // get folders that should get a mark_read link
      //
      global $mark_read_show_link;
      sqGetGlobalVar('mark_read_show_link', $mark_read_show_link);
      $allFolders = '';
      if (isset($mark_read_show_link))
         foreach ($mark_read_show_link as $folder)
            $allFolders .= $folder . '###';
      if (!isset($mark_read_show_link) || count($mark_read_show_link) == 0)
         $allFolders = 'NONE';
      setPref($data_dir, $username, 'mark_read_show_link', $allFolders);

      // get display options from the form
      //
      global $mark_read_display_is_short;
      sqGetGlobalVar('mark_read_display_is_short', $mark_read_display_is_short);
      if( isset($mark_read_display_is_short) ) {
         setPref($data_dir, $username, 'mark_read_display_is_short', $mark_read_display_is_short);
      } else {
         setPref($data_dir, $username, 'mark_read_display_is_short', 0);
      }

      global $user_mark_read_brackets;
      sqGetGlobalVar('user_mark_read_brackets', $user_mark_read_brackets);
      if( isset($user_mark_read_brackets) ) {
         setPref($data_dir, $username, 'user_mark_read_brackets', $user_mark_read_brackets);
      } else {
         setPref($data_dir, $username, 'user_mark_read_brackets', 1);
      }

      global $mark_read_display_upper;
      sqGetGlobalVar('mark_read_display_upper', $mark_read_display_upper);
      if( isset($mark_read_display_upper) ) {
         setPref($data_dir, $username, 'mark_read_display_upper', $mark_read_display_upper);
      } else {
         setPref($data_dir, $username, 'mark_read_display_upper', 0);
      }

      global $user_mark_read_separator;
      sqGetGlobalVar('user_mark_read_separator', $user_mark_read_separator);
      if( isset($user_mark_read_separator) ) {
         setPref($data_dir, $username, 'user_mark_read_separator', $user_mark_read_separator);
      } else {
         setPref($data_dir, $username, 'user_mark_read_separator', 1);
      }

      global $mark_read_display;
      sqGetGlobalVar('mark_read_display', $mark_read_display);
      if( isset($mark_read_display) ) {
         setPref($data_dir, $username, 'mark_read_display', $mark_read_display);
      } else {
         setPref($data_dir, $username, 'mark_read_display', 3);
      }

      global $mark_read_displayall;
      sqGetGlobalVar('mark_read_displayall', $mark_read_displayall);
      if( isset($mark_read_displayall) ) {
         setPref($data_dir, $username, 'mark_read_displayall', $mark_read_displayall);
      } else {
         setPref($data_dir, $username, 'mark_read_displayall', 0);
      }

   }


   mark_read_init();


   // grab preferences
   //
   $allFolders = getPref($data_dir, $username, 'mark_read_show_link', '');
   $mark_read_display = intval(getPref($data_dir, $username, 'mark_read_display', $default_mark_read_display));
   $mark_read_display_is_short = intval(getPref($data_dir, $username, 'mark_read_display_is_short', $default_mark_read_display_is_short));
   $user_mark_read_brackets = intval(getPref($data_dir, $username, 'user_mark_read_brackets', $default_user_mark_read_brackets));
   $user_mark_read_separator = intval(getPref($data_dir, $username, 'user_mark_read_separator', $default_user_mark_read_separator));
   $mark_read_display_upper = intval(getPref($data_dir, $username, 'mark_read_display_upper', $default_mark_read_display_upper));


   // load default folders if none have previously been chosen
   //
   if ($allFolders == 'NONE') $allFolders = '';
   else if ($allFolders == '')
   {
      $allFolders = implode('###', $default_folders_to_show_mark_read_link);
   }

   
   $mark_read_show_link = explode('###', $allFolders);


   if ($user_mark_read_link)
   {

      echo "\n" . '<form method="post" name="mark_read_links_form">'
         . "\n" . '<input type="hidden" value="1" name="mark_read_form">'
         . "\n" . '<table border="0" width="70%" cols="1" align="center" cellpadding="4" '
         . 'cellspacing="0" border="0">'
//         . "<tr><td bgcolor=\"$color[4]\">&nbsp;</td></tr>\n"
         . "<tr><td bgcolor=\"$color[9]\" align=\"center\"><B>"
         . _("Mark Read Link")
         . '</B></td></tr>'
         . "<tr><td bgcolor=\"$color[0]\" align=\"center\">"
         . _("Select all Folders, which you want to appear with a mark as read-/unread-link:")
         . '</td></tr>'
         . "<tr><td bgcolor=\"$color[0]\" align=\"center\">";
      if ($user_mark_read_link)
      {
         global $boxes, $trash_folder;
         $specialFolders = array();
         echo '<table width="100%" border="0"><tr><td width="60%" align="right">'
            . '<select name="mark_read_show_link[]" multiple size="15">';
         for ($i = 0; $i < count($boxes); $i++) 
         {
      //      if (strtolower($boxes[$i]['unformatted']) != $trash_folder)
      //      {
               $box = $boxes[$i]['unformatted-dm'];
               $box2 = str_replace(' ','&nbsp;',imap_utf7_decode_local(
                                                $boxes[$i]['unformatted-disp']));
               if (strtolower($box) != 'inbox.trash') 
                  echo '<option value="' . $box . '"'
                     . (isset($mark_read_show_link) 
                        && in_array($box, $mark_read_show_link)
                        ? ' selected' : '') . '>' . $box2 . "\n";

               // get special folder list for use below
               //
               if (isSpecialMailbox($box))
                  $specialFolders[] = $box2;

      //      }
         }

         echo '</select></td><td valign="bottom">'
            . '&nbsp;&nbsp;<a href="#" onClick="list=document.mark_read_links_form.elements[1]; for (i=0; i<list.length; i++) {if (';
         $first = true;
         foreach ($specialFolders as $specialFolder)
         {
            if (!$first) echo ' || ';
            else $first = false;
            echo 'list.options[i].text==\'' . $specialFolder . '\'';
         }
         echo ') { if (list.options[i].selected) list.options[i].selected=false; else list.options[i].selected=true; } } return false">'._("Toggle Special Folders").'</a><br><br>'
            . '&nbsp;&nbsp;<a href="#" onClick="list=document.mark_read_links_form.elements[1]; for (i=0; i<list.length; i++) {if (list.options[i].selected) list.options[i].selected=false; else list.options[i].selected=true; } return false">'._("Toggle All").'</a></td></tr></table>';
         
         echo _("Display links") .': <select name="mark_read_display" size="1">'.
               '<option '.($mark_read_display==0?'selected ':'').'value="0">'. _("none") .'</option>'.
               '<option '.($mark_read_display==1?'selected ':'').'value="1">'. _("read") .'</option>'.
               '<option '.($mark_read_display==2?'selected ':'').'value="2">'. _("unread") .'</option>'.
               '<option '.($mark_read_display==3?'selected ':'').'value="3">'. _("read/unread") .'</option>'.
               '</select>' ;

         echo '&nbsp;&nbsp;<input type="radio" name="mark_read_display_upper" id="mark_read_display_upper" value="1" id="mark_read_upper" ' . ($mark_read_display_upper==1?'checked ':' ') . '> <label for="mark_read_display_upper">';
         echo _("upper") . '</label>';
         echo '<input type="radio" name="mark_read_display_upper" id="mark_read_display_upper" value="0" id="mark_read_display_upper" ' . ($mark_read_display_upper==0?'checked ':' ') . '> <label for="mark_read_display_upper">'; 
         echo _("lower") . '</label>';

         echo '&nbsp;&nbsp;<input type="checkbox" name="mark_read_display_is_short" id="mark_read_display_is_short" value="1" '.($mark_read_display_is_short==1?'checked="checked"':'').' /> <label for="mark_read_display_is_short">'.
               _("shortened")."</label><br />";

         echo _("brackets") .': <select name="user_mark_read_brackets" size="1">'.
               '<option '.($user_mark_read_brackets==0?'selected ':'').'value="0">'. _("none") .'</option>'.
               '<option '.($user_mark_read_brackets==1?'selected ':'').'value="1">'."( )".'</option>'.
               '<option '.($user_mark_read_brackets==2?'selected ':'').'value="2">'."[ ]".'</option>'.
               '<option '.($user_mark_read_brackets==3?'selected ':'').'value="3">'."{ }".'</option>'.
               '<option '.($user_mark_read_brackets==4?'selected ':'').'value="4">'."< >".'</option>'.
               '<option '.($user_mark_read_brackets==5?'selected ':'').'value="5">'."- -".'</option>'.
               '</select>' ;

	 echo '&nbsp;&nbsp;'. _("seperator").': <select name="user_mark_read_separator" size="1">'.
               '<option '.($user_mark_read_separator==0?'selected ':'').'value="0">'._("none").'</option>'.
               '<option '.($user_mark_read_separator==1?'selected ':'').'value="1">'."/".'</option>'.
               '<option '.($user_mark_read_separator==2?'selected ':'').'value="2">'."-".'</option>'.
               '<option '.($user_mark_read_separator==3?'selected ':'').'value="3">'."_".'</option>'.
               '<option '.($user_mark_read_separator==4?'selected ':'').'value="4">'."\\".'</option>'.
               '<option '.($user_mark_read_separator==5?'selected ':'').'value="5">'."|".'</option>'.
               '<option '.($user_mark_read_separator==6?'selected ':'').'value="6">'."#".'</option>'.
               '<option '.($user_mark_read_separator==7?'selected ':'').'value="7">'."+".'</option>'.
               '<option '.($user_mark_read_separator==8?'selected ':'').'value="8">'." ".'</option>'.
               '</select>' ;
         echo "<br />";

         # $mark_read_displayall may be unset, so initialize it with the default value
         if( !isset($mark_read_displayall) ) $mark_read_displayall = $default_mark_read_displayall;

         echo '<input type="checkbox" name="mark_read_displayall" id="mark_read_displayall" value="1" '.($mark_read_displayall==1?'checked="checked"':'').' /> <label for="mark_read_displayall">'.
               _("Display 'mark all folders' link below the folder list") . '</label>';
      }
      echo '</td></tr><tr><td bgcolor="' . $color[0] 
         . '" align="right"><input type="submit" value="' 
         . _("Save") . '">'
         . '</td></tr></table></form>';

   }

  bindtextdomain('squirrelmail', SM_PATH . 'locale');
  textdomain('squirrelmail');

}



?>
