<?php
/**
** Mail Alias plugin for SquirrelMail
**
**  functions.php
**
**  Copyright (C) 2004,2005 Graeme C Neatham <graeme@promptpost.com>
**  Licensed under the GNU GPL. For full terms see the file COPYING.
**
**  Setting up the mail_alias plugin, this file also contains the logic for
**  retrieving, inserting, and deleting mail aliases.
**
**/

   include_once('DB.php');
   include_once(SM_PATH . 'plugins/mail_alias/config.php');
   include_once(SM_PATH . 'plugins/mail_alias/identity.php');

function mail_alias_optpage_register_block_do() {

    // Gets added to the user's OPTIONS page.
    //
    global $optpage_blocks, $username;

    bindtextdomain('mail_alias', SM_PATH . 'plugins/mail_alias/locale');
    textdomain('mail_alias');

        $optpage_blocks[] = array(
            'name' => _("Mail Aliases"),
            'url'  => '../plugins/mail_alias/mail_alias_opt.php',
            'desc' => _("You may define your mail aliases here. A mail alias is an email address the mail for which will arrive in this account"),
            'js'   => FALSE
        );

    bindtextdomain('squirrelmail', SM_PATH . 'locale');
    textdomain('squirrelmail');
}

function open_db_connection() {

    global $dispErr, $ma_db_dsn;

    // get database connection
    //
    $databaseConnection = DB::connect($ma_db_dsn);

    // make sure connection is OK
    //
    if (DB::isError($databaseConnection) || $dispErr) {
        echo '<p align=center><b>' . _("Error - Database connection failed.")
            . '&nbsp;&nbsp;' . _("Please contact the system administrator.") . '</b></p>';
    if (DB::isError($databaseConnection))
        return false;
    }
    $databaseConnection->setOption('portability', DB_PORTABILITY_NUMROWS); 

    return $databaseConnection;
}

function get_db_domains() {

    global $dispErr, $dom_list, $sql_get_domains;

    // initialize domain list
    //
    $dom_list = ' ';

    // get database connection
    //
    $dbConn = open_db_connection();
    if (!$dbConn) return;

    // execute get domains query
    //
    $select_result = $dbConn->query($sql_get_domains);


    // make sure the query was OK
    //
    if (DB::isError($select_result) || $dispErr) {
        echo '<p align=center><b>' . _("Error - Could not retrieve permitted domains.")
            . '&nbsp;&nbsp;' . _("Please contact the system administrator.") . '</b></p>';
      if (DB::isError($select_result)) {
          $dbConn->disconnect();
          return;
      }
    }

    // build domain list
    //
    while ($select_result->fetchInto($line, DB_FETCHMODE_ORDERED)) {
           $dom_list .= $line[0];
           $dom_list .= ', ';
    }

    $dom_list = substr($dom_list,0,-2);

    $dbConn->disconnect();
}

function get_db_alias_for_user() {

    global $dispErr, $username, $sql_get_aliases;

    // get database connection
    //
    $dbConn = open_db_connection();
    if (!$dbConn) return;

    // prepare query data
    //
    $sql_data = array($username, 'ALIAS');

    // execute  get aliases query
    //
    $select_result = $dbConn->query($sql_get_aliases, $sql_data);


    // make sure the query was OK
    //
    if (DB::isError($select_result) || $dispErr) {
        echo '<p align=center><b>' . _("Error - Could not retrieve current aliases.")
            . '&nbsp;&nbsp;' . _("Please contact the system administrator.") . '</b></p>';
      if (DB::isError($select_result)) {
          $dbConn->disconnect();
          return;
      }
    }

    $dbConn->disconnect();

    return $select_result;
}

function get_db_alias_max() {

    global $dispErr, $username, $max_alias, $sql_get_alias_max;

    // get database connection
    //
    $dbConn = open_db_connection();
    if (!$dbConn) return;

    // execute get maximum aliases allowed query
    //
    $max_alias = $dbConn->getOne($sql_get_alias_max, $username);


    // make sure the query was OK
    //
    if (DB::isError($max_alias) || $dispErr) {
        echo '<p align=center><b>' . _("Error - Could not retrieve maximum aliases.")
            . '&nbsp;&nbsp;' . _("Please contact the system administrator.") . '</b></p>';
      if (DB::isError($max_alias))
          $max_alias = 0;
    }

    $dbConn->disconnect();

    return $max_alias;
}

function add_db_alias_for_user($emlalias, $identsynch) {

    global $dispErr, $username, $mailbox_dir, 
           $sql_add_alias_user, $sql_add_alias_forward;

    // check we have a usable alias
    //
    if (!validate_email($emlalias)) {
        echo '<p align=center><b>' . _("Error") . ' - &nbsp;<i><bdo dir="LTR">' . $emlalias 
           . '</bdo></i>&nbsp;&nbsp;' . _("is not a valid Alias") . '</b></p>';
        return;
    }

    // check the alias is not already in use
    //
    if (!unused_email($emlalias)) {
        echo '<p align=center><b>' . _("Error") . ' - &nbsp;<i>' . $emlalias 
           . '</i>&nbsp;&nbsp;' . _("is already in use and cannot be used as an Alias") . '</b></p>';
        return;
    }

    // get database connection
    //
    $dbConn = open_db_connection();
    if (!$dbConn) return;

    // decipher the mailbox directory
    //
    $user_maildir = vd_replace($mailbox_dir);


    // Need to perform two related inserts
    // Only commit if both succeed, else rollback
    // Mysql needs InnoDB tables for this to work
    //
    $dbConn->autoCommit(false);
    $rollback = 0;

    // prepare data to create a new alias
    //
    $data1 = array($emlalias, 'ALIAS', $user_maildir);
    $data2 = array($emlalias, $username);

    // execute queries
    //
    $select_result1 = $dbConn->query($sql_add_alias_user, $data1);
    $select_result2 = $dbConn->query($sql_add_alias_forward, $data2);


    // make sure the inserts were OK
    //
    if (DB::isError($select_result1) || $dispErr) {
        echo '<p align=center><b>' . _("Error - Could not insert the alias record into the user table.")
           . '&nbsp;&nbsp;' . _("Please contact the system administrator.") . '</b></p>';
      if (DB::isError($select_result1)) 
          $rollback = 1;
    }
    if (DB::isError($select_result2) || $dispErr) {
        echo '<p align=center><b>' . _("Error - Could not insert the alias record into the forward table.")
           . '&nbsp;&nbsp;' . _("Please contact the system administrator.") . '</b></p>';
      if (DB::isError($select_result2)) 
          $rollback = 1;
    }

    if ($rollback) $dbConn->rollback();
    else {
         $dbConn->commit();
         
         // Synchronize Identities
         //
         if ($identsynch == 'yes') {
            if (!ident_exists($emlalias)) {
               $ident = ma_get_identities();
               $ic = count($ident);
               $ident[] = array('full_name' => '',
                                'email_address' => $emlalias,
                                'reply_to' => $emlalias,
                                'signature' => '',
                                'index' => $ic );
               ma_save_identities($ident);
            }
         } 
    }

    $dbConn->autoCommit(true);
    
    $dbConn->disconnect();

    return;
}

function del_db_alias_for_user($emlalias, $identsynch) {

    global $dispErr, $username,
           $sql_del_alias_user, $sql_del_alias_forward;

    // get database connection
    //
    $dbConn = open_db_connection();
    if (!$dbConn) return;

    // Need to perform two related deletes
    // Only commit if both succeed, else rollback
    // Mysql needs InnoDB tables for this to work
    //
    $dbConn->autoCommit(false);
    $rollback = 0;

    
    // execute queries
    //
    $select_result1 = $dbConn->query($sql_del_alias_user, $emlalias);
    $select_result2 = $dbConn->query($sql_del_alias_forward, $emlalias);


    // make sure the deletes were OK
    //
    if (DB::isError($select_result1) || $dispErr) {
        echo '<p align=center><b>' . _("Error - Could not delete the alias record from the user table.")
           . '&nbsp;&nbsp;' . _("Please contact the system administrator.") . '</b></p>';
      if (DB::isError($select_result1)) 
          $rollback = 1;
    }
    if (DB::isError($select_result2) || $dispErr) {
        echo '<p align=center><b>' . _("Error - Could not delete the alias record from the forward table.")
           . '&nbsp;&nbsp;' . _("Please contact the system administrator.") . '</b></p>';
      if (DB::isError($select_result2)) 
          $rollback = 1;
    }

    if ($rollback) $dbConn->rollback();
    else {
         $dbConn->commit();

         // Synchronize Identities
         //
         if ($identsynch == 'yes') {
            if (ident_exists($emlalias)) {
               $ident = ma_get_identities();
               $ic = count($ident);
               $f = 0;
               $identId = array($ic);

               for($i=0;$i<$ic;$i++) {
                   if (!strcasecmp($ident[$i]['email_address'],$emlalias)) {
                        $identId[$f] = $i - $f;
                        $f++;
                   }
               }
               for($i=0;$i<$f;$i++) {
                 $ident = ma_sqfixidentities($ident, $identId[$i], 'delete');
               }
               ma_save_identities($ident);
            }
         } 
    }
    $dbConn->autoCommit(true);
    
    $dbConn->disconnect();

    return;
}

function validate_email($email) {
    
    global $dom_list, $not_local_part;

    // check for an empty alias
    //    
    if (empty($email)){
       return false;
    }
    
    // check for a valid email format and that the domain is in the domain list
    // regular expression checks adapted from www.weberdev.com/get_example-980.html
    //
    if (eregi("(@.*@)|(\.\.)|(@\.)|(\.@)|(^\.)",$email) || !eregi ("^.+\@(\[?)[-_a-zA-Z0-9\.]+\.([a-zA-Z]{2,3}|[0-9]{1,3})(\]?)$",$email)) {
        return false;
    }
    else {
        list($user, $domain) = explode('@',$email);
        if ((!eregi("^[_a-zA-Z0-9\.\-]+$",$user)) || (!eregi("^[a-zA-Z0-9\.\-]+$",$domain)) || (!strpos($dom_list,$domain)) || (strpos($not_local_part,(':'.$user.':')))) {
            return false;
        }
        else {
            return true;
        }
    }
}

function unused_email($emladd) {

    global $dispErr, $sql_get_user;

    // get database connection
    //
    $dbConn = open_db_connection();
    if (!$dbConn) return false;

    // execute get user query
    //
    $select_result = $dbConn->query($sql_get_user, $emladd);

    // make sure the query was OK
    //
    if (DB::isError($select_result) || $dispErr) {
        echo '<p align=center><b>' . _("Error - Could not retrieve existing users.")
            . '&nbsp;&nbsp;' . _("Please contact the system administrator.") . '</b></p>';
      if (DB::isError($select_result)) {
          $dbConn->disconnect();
          return false;
      }
    }
     
    // check the number of matches
    //
    if ($select_result->numRows() > 0) {
        $dbConn->disconnect();
        return false;
    }

    $dbConn->disconnect();

    return true;
}

function vd_replace($setting) {

   global $username;
      
   list($user, $domain) = explode('@',$username);
   
   return preg_replace(
      array('/\[DOMAIN\]/','/\[USERNAME\]/'),
      array($domain,$user),
      $setting
   );
}


function ident_exists($thisIdent) {

    $idents = ma_get_identities();
    $identIs = 0;
    $numIdents = count($idents);

    for($i=0;$i<$numIdents;$i++) {
        if (!strcasecmp($idents[$i]['email_address'],$thisIdent))
             $identIs = 1;
    }
    return $identIs;
}

?>
