<?php
/**
** Mail Alias plugin for SquirrelMail
**
**  functions.php
**
**  Copyright (C) 2004 Graeme C Neatham <graeme@promptpost.com>
**  Licensed under the GNU GPL. For full terms see the file COPYING.
**
**  Setting up the mail_alias plugin, this file also contains the logic for
**  retrieving, inserting, and deleting mail aliases.
**
**/

   include_once(SM_PATH . 'plugins/mail_alias/config.php');

function mail_alias_optpage_register_block_do() {

    // Gets added to the user's OPTIONS page.
    //
    global $optpage_blocks, $username;

    bindtextdomain('mail_alias', SM_PATH . 'plugins/mail_alias/locale');
    textdomain('mail_alias');

        $optpage_blocks[] = array(
            'name' => _("Mail Aliases"),
            'url'  => '../plugins/mail_alias/mail_alias_opt.php',
            'desc' => _("You may define your mail aliases here. A mail alias is an email address the mail for which will arrive in this account"),
            'js'   => FALSE
        );

    bindtextdomain('squirrelmail', SM_PATH . 'locale');
    textdomain('squirrelmail');
}

function open_mysql_connection() {

    global $mysql_server, $mysql_manager_id,
	   $mysql_manager_pwd, $mysql_database;

    // get mysql connection
    //
    $databaseConnection = mysql_connect($mysql_server, $mysql_manager_id, $mysql_manager_pwd);


    // make sure connection is OK
    //
    if ( ! $databaseConnection ) {
        echo '<p align=center><b>' . _("Error - Database connection failed.")
            . '&nbsp;&nbsp;' . _("Please contact the system administrator.") . '</b></p>';
        return false;
    }

    // connect to desired database
    //
    if ( !mysql_select_db($mysql_database,$databaseConnection) ) {
        echo '<p align=center><b>' . _("Error - Database not found.")
            . '&nbsp;&nbsp;' . _("Please contact the system administrator.") . '</b></p>';
        return false;
    }
    return $databaseConnection;
}

function get_mysql_domains() {

    global $dom_list,
           $mysql_dom_table, $mysql_dom_id_field;

    // initialize domain list
    //
    $dom_list = ' ';

    // get mysql connection
    //
    $dbConn = open_mysql_connection();
    if (!$dbConn) return;

    // build query statement to retrieve permitted domains
    //
    $query_string = 'select ' . $mysql_dom_id_field
                  . ' from '  . $mysql_dom_table;

    // execute query
    //
    $select_result = mysql_query($query_string, $dbConn);

    // make sure the query was OK
    //
    if (!$select_result) {
        echo '<p align=center><b>' . _("Error - Could not retrieve permitted domains.")
            . '&nbsp;&nbsp;' . _("Please contact the system administrator.") . '</b></p>';
        return;
    }

    // build domain list
    //
    while ($line = mysql_fetch_array($select_result, MYSQL_ASSOC)) {
       foreach ($line as $col_value) {
           $dom_list .= $col_value;
           $dom_list .= ', ';
       }
    }
    $dom_list = substr($dom_list,0,-2);
    mysql_close($dbConn);
}

function get_mysql_alias_for_user() {

    global $username, $dom_list,
           $mysql_fwd_table, $mysql_fwd_id_field, $mysql_forward_field,
           $mysql_usr_table, $mysql_usr_id_field, 
           $mysql_usr_name_field, $mysql_usr_maildir_field;

    // get mysql connection
    //
    $dbConn = open_mysql_connection();
    if (!$dbConn) return;

    // build query statement to retrieve users current aliases
    //
    $query_string = 'select f.' . $mysql_fwd_id_field
        . ' from '  . $mysql_fwd_table . ' f, ' . $mysql_usr_table . ' u ' 
        . ' where f.' . $mysql_forward_field . ' ="' . $username . '"'
        . ' and u.' . $mysql_usr_id_field . ' = f.' . $mysql_fwd_id_field 
        . ' and u.' . $mysql_usr_name_field . ' = "ALIAS"' ;

    // execute query
    //
    $select_result = mysql_query($query_string, $dbConn);


    // make sure the query was OK
    //
    if (!$select_result) {
        echo '<p align=center><b>' . _("Error - Could not retrieve current aliases.")
            . '&nbsp;&nbsp;' . _("Please contact the system administrator.") . '</b></p>';
        return;
    }

    mysql_close($dbConn);

    return $select_result;
}

function get_mysql_alias_max() {

    global $username, $max_alias,
           $mysql_max_table, $mysql_max_field, $mysql_max_id_field;

    // get mysql connection
    //
    $dbConn = open_mysql_connection();
    if (!$dbConn) return;

    // build query statement to retrieve users current aliases
    //
    $query_string = 'select m.' . $mysql_max_field
        . ' from '  . $mysql_max_table . ' m'
        . ' where m.' . $mysql_max_id_field . ' ="' . $username . '"';

    // execute query
    //
    $select_result = mysql_query($query_string, $dbConn);


    // make sure the query was OK
    //
    if (!$select_result) {
        echo '<p align=center><b>' . _("Error - Could not retrieve maximum aliases.")
            . '&nbsp;&nbsp;' . _("Please contact the system administrator.") . '</b></p>';
        return;
    }

    $max_alias = mysql_result($select_result, 0);   

    mysql_close($dbConn);

    return $select_result;
}

function add_mysql_alias_for_user($emlalias) {

    global $username,
           $mysql_fwd_table, $mysql_fwd_id_field, $mysql_forward_field,
           $mysql_usr_table, $mysql_usr_id_field, 
           $mysql_usr_name_field, $mysql_usr_maildir_field, $mailbox_dir;

    // check we have a usable alias
    //
    if (!validate_email($emlalias)) {
        echo '<p align=center><b>' . _("Error") . ' - &nbsp;<i><bdo dir="LTR">' . $emlalias 
           . '</bdo></i>&nbsp;&nbsp;' . _("is not a valid Alias") . '</b></p>';
        return;
    }

    // check the alias is not already in use
    //
    if (!unused_email($emlalias)) {
        echo '<p align=center><b>' . _("Error") . ' - &nbsp;<i>' . $emlalias 
           . '</i>&nbsp;&nbsp;' . _("is already in use and cannot be used as an Alias") . '</b></p>';
        return;
    }

    // get mysql connection
    //
    $dbConn = open_mysql_connection();
    if (!$dbConn) return;

    // decipher the mailbox directory
    //
    $user_maildir = vd_replace($mailbox_dir);

    // build query statements to create a new alias
    //
    $query_ins_usr = 'insert into ' . $mysql_usr_table 
                   . ' set ' . $mysql_usr_id_field . ' = "' . $emlalias . '",' 
                   . $mysql_usr_name_field . ' = "ALIAS",' 
                   . $mysql_usr_maildir_field . ' = "' 
                   . $user_maildir . '"';

    $query_ins_fwd = 'insert into ' . $mysql_fwd_table 
                   . ' set ' . $mysql_fwd_id_field . ' = "' . $emlalias . '",' 
                   . $mysql_forward_field . ' = "' . $username . '"';

    // execute queries
    //
    $select_result1 = mysql_query($query_ins_usr, $dbConn);
    $select_result2 = mysql_query($query_ins_fwd, $dbConn);

    // make sure the inserts were OK
    //
    if (!$select_result1) {
        echo '<p align=center><b>' . _("Error - Could not insert the alias record into the user table.")
           . '&nbsp;&nbsp;' . _("Please contact the system administrator.") . '</b></p>';
        return;
    }
    if (!$select_result2) {
        echo '<p align=center><b>' . _("Error - Could not insert the alias record into the forward table.")
           . '&nbsp;&nbsp;' . _("Please contact the system administrator.") . '</b></p>';
        return;
    }

    mysql_close($dbConn);

    return;
}

function del_mysql_alias_for_user($emlalias) {

    global $username,
           $mysql_fwd_table, $mysql_fwd_id_field, $mysql_forward_field,
           $mysql_usr_table, $mysql_usr_id_field, 
           $mysql_usr_name_field, $mysql_usr_maildir_field;

    // get mysql connection
    //
    $dbConn = open_mysql_connection();
    if (!$dbConn) return;

    // build query statements to remove an alias
    //
    $query_del_fwd = 'delete from ' . $mysql_fwd_table .
                     ' where ' . $mysql_fwd_id_field . ' = "' . $emlalias . '"';

    $query_del_usr = 'delete from ' . $mysql_usr_table .
                     ' where ' . $mysql_usr_id_field . ' = "' . $emlalias . '"';
    
    // execute queries
    //
    $select_result1 = mysql_query($query_del_usr, $dbConn);
    $select_result2 = mysql_query($query_del_fwd, $dbConn);


    // make sure the deletes were OK
    //
    if (!$select_result1) {
        echo '<p align=center><b>' . _("Error - Could not delete the alias record from the user table.")
           . '&nbsp;&nbsp;' . _("Please contact the system administrator.") . '</b></p>';
        return;
    }
    if (!$select_result2) {
        echo '<p align=center><b>' . _("Error - Could not delete the alias record from the forward table.")
           . '&nbsp;&nbsp;' . _("Please contact the system administrator.") . '</b></p>';
        return;
    }

    mysql_close($dbConn);

    return;
}

function validate_email($email) {
    
    global $dom_list, $not_local_part;

    // check for an empty alias
    //    
    if (empty($email)){
       return false;
    }
    
    // check for a valid email format and that the domain is in the domain list
    // regular expression checks adapted from www.weberdev.com/get_example-980.html
    //
    if (eregi("(@.*@)|(\.\.)|(@\.)|(\.@)|(^\.)",$email) || !eregi ("^.+\@(\[?)[-_a-zA-Z0-9\.]+\.([a-zA-Z]{2,3}|[0-9]{1,3})(\]?)$",$email)) {
        return false;
    }
    else {
        list($user, $domain) = explode('@',$email);
        if ((!eregi("^[_a-zA-Z0-9\.\-]+$",$user)) || (!eregi("^[a-zA-Z0-9\.\-]+$",$domain)) || (!strpos($dom_list,$domain)) || (strpos($not_local_part,(':'.$user.':')))) {
            return false;
        }
        else {
            return true;
        }
    }
}

function unused_email($emladd) {

    global $mysql_usr_table, $mysql_usr_id_field;

    // get mysql connection
    //
    $dbConn = open_mysql_connection();
    if (!$dbConn) return false;

    // build query statement to count current users
    // that match the alias
    //
    $query_string = 'select count(*)'
                  . ' from '  . $mysql_usr_table
                  . ' where ' . $mysql_usr_id_field
                  . ' = "' . $emladd . '"';

    // execute query
    //
    $select_result = mysql_query($query_string, $dbConn);

    // make sure the query was OK
    //
    if (!$select_result) {
        echo '<p align=center><b>' . _("Error - Could not retrieve existing users.")
            . '&nbsp;&nbsp;' . _("Please contact the system administrator.") . '</b></p>';
        mysql_close($dbConn);
        return false;
    }

    // check the number of matches
    //
    $count  = mysql_fetch_row($select_result);
    if ($count[0] > 0) {
        mysql_close($dbConn);
        return false;
    }

    mysql_close($dbConn);

    return true;
}

function vd_replace($setting) {

   global $username;
      
   list($user, $domain) = explode('@',$username);
   
   return preg_replace(
      array('/\[DOMAIN\]/','/\[USERNAME\]/'),
      array($domain,$user),
      $setting
   );
}

?>
