<?php

/**
  * SquirrelMail Login Redirect Plugin
  * Copyright (C) 2004-2006 Paul Lesneiwski <paul@squirrelmail.org>
  * Licensed under the GNU GPL. For full terms see the file COPYING.
  *
  * @package plugins
  * @subpackage login_redirect
  *
  */


/**
  * Register this plugin with SquirrelMail 
  *
  */
function squirrelmail_plugin_init_login_redirect() 
{

   global $squirrelmail_plugin_hooks;

   $squirrelmail_plugin_hooks['login_cookie']['login_redirect'] = 'redirect_login';
   $squirrelmail_plugin_hooks['logout_error']['login_redirect'] = 'rl_logout_error';
   $squirrelmail_plugin_hooks['logout']['login_redirect']       = 'rl_signout';


}



/** @ignore */
if (!defined('SM_PATH'))
   define('SM_PATH', '../');



/**
  * Returns info about this plugin
  *
  */
function login_redirect_info()
{

   return array(
                 'english_name' => 'Login Redirect',
                 'version' => '1.2',
                 'required_sm_version' => '1.2.0',
                 'requires_configuration' => 0,
                 'requires_source_patch' => 2,
                 'summary' => 'Force the use of a custom login screen instead of default SquirrelMail login page.',
                 'details' => 'This plugin will force the user to a custom login screen instead of using the default SquirrelMail login page. You can have different login pages for different domains if you use this in combination with the Virtual Host Login (vlogin) plugin.',
               );

}



/**
  * Returns version info about this plugin
  *
  */
function login_redirect_version()
{

   $info = login_redirect_info();
   return $info['version'];

}



/**
  * Pushes user to different login page (custom portal, etc)
  *
  */
function redirect_login() 
{

   include_once(SM_PATH . 'plugins/login_redirect/functions.php');
   redirect_login_do();

}



/**
  * Fixes the login page uri shown for login errors.
  *
  */
function rl_logout_error(&$args)
{

   include_once(SM_PATH . 'plugins/login_redirect/functions.php');
   rl_logout_error_do($args);

}



/**
  * Fixes the login page uri shown for the signout page.
  *
  */
function rl_signout(&$args)
{

   include_once(SM_PATH . 'plugins/login_redirect/functions.php');
   rl_signout_do($args);

}



