<?php

/**
  * SquirrelMail Login Notes Plugin
  * Copyright (c) 2003-2008 Paul Lesniewski <paul@squirrelmail.org>
  * Licensed under the GNU GPL. For full terms see the file COPYING.
  *
  * @package plugins
  * @subpackage login_notes
  *
  */


/**
  * Register this plugin with SquirrelMail
  *
  */
function squirrelmail_plugin_init_login_notes()
{

   global $squirrelmail_plugin_hooks;


   // insert text on top of login screen (1.4.x)
   //
   $squirrelmail_plugin_hooks['login_top']['login_notes']
      = 'insertTop';


   // insert text on top of login screen (1.5.x)
   //
   $squirrelmail_plugin_hooks['template_construct_login.tpl']['login_notes']
      = 'insertTop';


   // insert text on bottom of login screen (1.4.x/1.5.x)
   //
   $squirrelmail_plugin_hooks['login_bottom']['login_notes']
      = 'insertBottom';


   // configuration check
   //
   $squirrelmail_plugin_hooks['configtest']['login_notes']
      = 'login_notes_check_configuration';

}



/**
  * Returns info about this plugin
  *
  */
function login_notes_info()
{

   return array(
                 'english_name' => 'Login Notes',
                 'authors' => array(
                    'Paul Lesniewski' => array(
                       'email' => 'paul@squirrelmail.org',
                       'sm_site_username' => 'pdontthink',
                    ),
                 ),
                 'version' => '1.2',
                 'required_sm_version' => '1.4.0',
                 'requires_configuration' => 1,
                 'required_plugins' => array(),
                 'requires_source_patch' => 0,
                 'summary' => 'Places text and/or images on the top/bottom of the login screen.',
                 'details' => 'This plugin will display extra text, images or any HTML on the top or bottom of the login page.  It should also serve as a good introduction to how a simple SquirrelMail plugin works.',
               ); 
  
} 
  
  

/**
  * Returns version info about this plugin
  *
  */
function login_notes_version()
{  
   $info = login_notes_info();
   return $info['version'];
}  



/**
  * Insert text on top of login screen
  * 
  */
function insertTop() 
{
   include_once(SM_PATH . 'plugins/login_notes/functions.php');
   return insertTop_do();
}



/**
  * Insert text on bottom of login screen
  * 
  */
function insertBottom() 
{
   include_once(SM_PATH . 'plugins/login_notes/functions.php');
   insertBottom_do();
}



/**
  * Validate that this plugin is configured correctly
  *
  * @return boolean Whether or not there was a
  *                 configuration error for this plugin.
  *
  */
function login_notes_check_configuration()
{
   include_once(SM_PATH . 'plugins/login_notes/functions.php');
   return login_notes_check_configuration_do();
}



