<?php

/**
  * SquirrelMail Login Notes Plugin
  * Copyright (c) 2003-2008 Paul Lesniewski <paul@squirrelmail.org>
  * Licensed under the GNU GPL. For full terms see the file COPYING.
  *
  * @package plugins
  * @subpackage login_notes
  *
  */


/**
  * Validate that this plugin is configured correctly
  *
  * @return boolean Whether or not there was a
  *                 configuration error for this plugin.
  *
  */
function login_notes_check_configuration_do()
{

   // make sure base config is available
   //
   if (!login_notes_init())
   {
      do_err('Login Notes plugin is missing its main configuration file', FALSE);
      return TRUE;
   }

}



/**
  * Initialize this plugin (load config values)
  *
  * @return boolean FALSE if no configuration file could be loaded, TRUE otherwise
  *
  */
function login_notes_init()
{

   if (!@include_once(SM_PATH . 'plugins/login_notes/config.php'))
      return FALSE;

   return TRUE;

}



/**
  * Insert text on top of login screen
  *
  */
function insertTop_do() 
{

   global $topText;

   login_notes_init();


   // 1.5.2+ uses templated output
   //
   if (check_sm_version(1, 5, 2))
   {
      global $oTemplate;
      $oTemplate->assign('notes', $topText, FALSE);  // FALSE here allows HTML in the notes, but assumes we can trust that it is clean of possible Bad Stuff
      $output = $oTemplate->fetch('plugins/login_notes/top_notes.tpl');
      return array('login_top' => $output);
   }


   // 1.4.x
   //
   else
   {
      echo $topText;
   }

}



/**
  * Insert text on bottom of login screen
  *
  */
function insertBottom_do() 
{

   global $bottomText;

   login_notes_init();


   // 1.5.2+ uses templated output
   //
   if (check_sm_version(1, 5, 2))
   {
      global $oTemplate;
      $oTemplate->assign('notes', $bottomText, FALSE);  // FALSE here allows HTML in the notes, but assumes we can trust that it is clean of possible Bad Stuff
      $oTemplate->display('plugins/login_notes/bottom_notes.tpl');
   }


   // 1.4.x
   //
   else
   {
      echo $bottomText;
   }

}



