<?php

/**
  * SquirrelMail Login Check Plugin
  * Copyright (c) 2009-2010 Paul Lesniewski <paul@squirrelmail.org>
  * Licensed under the GNU GPL. For full terms see the file COPYING.
  *
  * @package plugins
  * @subpackage login_check
  *
  */



/**
  * Register this plugin with SquirrelMail
  *
  */
function squirrelmail_plugin_init_login_check()
{

   global $squirrelmail_plugin_hooks;


   // if needed, display message on login page
   //
   $squirrelmail_plugin_hooks['login_top']['login_check']
      = 'login_check_warning_stub';


   // 1.4.x
   //
   // check that there are no other users
   // logged in when loading the login page
   //
   $squirrelmail_plugin_hooks['loading_constants']['login_check']
      = 'login_check_stub';


   // 1.5.2+
   //
   // check that there are no other users
   // logged in when loading the login page
   //
//   $squirrelmail_plugin_hooks['prefs_backend']['login_check']
//      = 'login_check_stub';


   // configuration check
   //
   $squirrelmail_plugin_hooks['configtest']['login_check']
      = 'login_check_check_configuration_stub';

}



/**
  * Returns info about this plugin
  *
  */
function login_check_info()
{

   return array(
                 'english_name' => 'Login Check',
                 'authors' => array(
                    'Paul Lesniewski' => array(
                       'email' => 'paul@squirrelmail.org',
                       'sm_site_username' => 'pdontthink',
                    ),
                 ),
                 'version' => '1.0',
                 'required_sm_version' => '1.4.10',
                 'requires_configuration' => 0,
                 'requires_source_patch' => 0,
                 'required_plugins' => array(),
                 'summary' => 'Prevents cross-contamination of user preferences when users log in to SquirrelMail using a browser where another user was already logged in to the same server/domain .',
                 'details' => 'This plugin is intended to avoid cross-contamination of user preferences (and associated security issues) that can happen when users log into SquirrelMail using a browser where another user was already logged in (to the same server/domain).<br /><br />This is a long-standing problem with SquirrelMail that is caused by cookie-based user sessions - only one cookie per browser per domain is possible.  In the future, when SquirrelMail offers other session mechanisms, this plugin will not be necesesary.<br /><br />This plugin is only needed if there is a possibility of users forgetting to log out before another user attempts to log in with the same browser to the same domain.',
               );

}



/**
  * Returns version info about this plugin
  *
  */
function login_check_version()
{
   $info = login_check_info();
   return $info['version'];
}



/**
  * check that there are no other users
  * logged in when loading the login page
  *
  */
function login_check_stub()
{
   include_once(SM_PATH . 'plugins/login_check/functions.php');
   login_check();
}



/**
  * Validate that this plugin is configured correctly
  *
  * @return boolean Whether or not there was a
  *                 configuration error for this plugin.
  *
  */
function login_check_check_configuration_stub()
{
   include_once(SM_PATH . 'plugins/login_check/functions.php');
   return login_check_check_configuration();
}



/**
  * If needed, display message on login page
  *
  */
function login_check_warning_stub()
{
   include_once(SM_PATH . 'plugins/login_check/functions.php');
   login_check_warning();
}



