<?php

/* Initialize the plugin */
function squirrelmail_plugin_init_login_auth()
{
   global $PHP_AUTH_USER, $PHP_AUTH_PW, $PHP_SELF;
   
   if (! isset($PHP_AUTH_USER) || ! isset($PHP_AUTH_PW))
      return;

   if (strstr($PHP_SELF, 'login.php') !== false)
      login_auth_login_php();
   if (strstr($PHP_SELF, 'redirect.php') !== false)
      login_auth_redirect_php();
}

function login_auth_redirect_php()
{
   global $plugins, $login_auth, $login_auth_user, $login_auth_pass,
      $just_logged_in, $login_username, $secretkey;

   if (! isset($login_auth))
      return;
      
   $login_username = $login_auth_user;
   $secretkey = $login_auth_pass;
   $just_logged_in = 1;

   if (in_array('password_forget', $plugins)) {
      $login_username = 'login_auth_user';
      $secretkey = 'login_auth_pass';
   }
}

function login_auth_login_php()
{
   global $PHP_AUTH_USER, $PHP_AUTH_PW, $PHP_SELF,
      $imapServerAddress, $imapPort;
  
   include('../functions/imap.php');
    
   global $onetimepad;
   $onetimepad = OneTimePadCreate(strlen($PHP_AUTH_PW));
   $key = OneTimePadEncrypt($PHP_AUTH_PW, $onetimepad);
   $imapConn = sqimap_login($PHP_AUTH_USER, $key, $imapServerAddress,
      $imapPort, 0);
      
   if ($imapConn) {
      global $login_auth_user, $login_auth_pass, $login_auth;
      $login_auth = true;
      $login_auth_user = $PHP_AUTH_USER;
      $login_auth_pass = $PHP_AUTH_PW;
      session_register('login_auth');
      session_register('login_auth_user');
      session_register('login_auth_pass');
      header('Location: redirect.php?login_username=login_auth');
      exit();
   }
}

?>
