<?php

/**
  * SquirrelMail Login Authentication Plugin
  *
  * Copyright (c) 2004-2012 Paul Lesniewski <paul@squirrelmail.org>,
  * Copyright (c) 2001 Tyler Akins
  *
  * Licensed under the GNU GPL. For full terms see the file COPYING.
  *
  * @package plugins
  * @subpackage login_auth
  *
  */

global $normal_login_behavior, $authenticated_username_location,
       $authenticated_password_location, $external_auth_validation_type,
       $use_alternate_signout_page, $trusted_saml_username, $trusted_saml_password,
       $required_environment_variable, $required_environment_variable_value_type,
       $required_environment_variable_value, $external_session_expiration_relogin_link,
       $authenticated_saml_compress_assertion;


// Should logins using the normal login page be allowed if the user
// has not authenticated already via other means?
//
//    1  =  Yes, allow the user to log in using the standard SquirrelMail login page
//    0  =  No, don't allow webmail-only logins - display error page
//    <address of external login page> = Redirect unauthenticated users
//                                       to external login page; %s in this
//                                       address will be replaced with the
//                                       address of the SquirrelMail login
//                                       page and %e will be replaced with
//                                       with the URL-encoded version
//                                       of the SquirrelMail login address
//
// Normally, it isn't helpful to your users if you set this to 0 since
// it's not clear for them where they need to go to log in.  Examples:
//
// $normal_login_behavior = 'https://example.com/sso/login?return=%e';
// $normal_login_behavior = 0;
//
$normal_login_behavior = 1;



// This plugin provides an alternate landing page for the "Signout" link
// that explains to users that they need to close their browser in order
// to actually sign out.  If this is the case for you (typical for HTTP
// authentication and the like), then you should enable the use of this
// special page.
//
// If you don't use this, it may be prudent if you set the SquirrelMail
// $signout_page configuration variable (or see config/conf.pl -->
// 1. Organization Preferences --> 5. Signout Page) to point to a page
// that actually ends the user's login session (perhaps by logging them
// out of your single sign-on system).
//
// Another option is that you can set this value to point to an external
// logout page (with SquirrelMail's logout address possibly included in
// it - use either the "%s" or "%e" replacement to specify where it
// should be included).
//
//    0  =  Do not use special signout page
//    1  =  Use special signout page
//    <address of external logout page> = Must be a web address of an
//                                        external logout page, %s will
//                                        be replaced in the address
//                                        with the SquirrelMail logout
//                                        address and %e will be replaced
//                                        with the URL-encoded version
//                                        of the SquirrelMail logout address
//
// Here's an example of an external logout page
//
// $use_alternate_signout_page = 'https://example.com/sso/logout?return=%e';
//
$use_alternate_signout_page = 1;



// What are the names of the server environment variables that hold
// the user credentials?  If you'd like to search a list of possibile
// variable names, you may specify these as a list (array), in which
// case the first one in your list that exists in the server environment
// is used.  For example:
//
// $authenticated_username_location = array('REMOTE_USER', 'PHP_AUTH_USER');
//
// NOTE that not all types of external authentication provide both of
// these; in such a case, these are ignored.
//
// An example when using the "authenticated_saml" module:
//
// $authenticated_username_location = 'REMOTE_USER';
// $authenticated_password_location = "MELLON_SAML_RESPONSE";
//
// An example when using the "trusted_saml" module:
//
// $authenticated_username_location = 'uid';
// $authenticated_password_location = 'Shib-Session-ID';
//
// These defaults are typical for HTTP authentication:
//
$authenticated_username_location = 'PHP_AUTH_USER';
$authenticated_password_location = 'PHP_AUTH_PW';



// How should the external authentication be identified and validated?
// What IMAP credentials should be used to access the user's email?
//
// The answers to this question will depend on your external authentication
// system.  The most simple variety is standard HTTP authentication, but
// other possibilities are one of several single sign-on systems, etc.
//
// This plugin provides functionality that knows how to see and use HTTP
// authentication credentials as well as a couple modules that can detect
// and process SAML (single sign-on) assertions.
//
// You can also define your own function tailored to your particular
// needs.  An example of such a function is included herein.
// 
//
//
// Set this to "http_auth" if you use HTTP authentication.  In this case,
// $authenticated_username_location and $authenticated_password_location
// should usually be set to "PHP_AUTH_USER" and "PHP_AUTH_PW" respectively.
//
//
//
// Set this to to "authenticated_saml" to take advantage of the SAML
// single sign-on module that will ask the IMAP server to authenticate
// the SAML assertion in place of password authentication.
//
// This module knows how to find a SAML assertion provided by a
// SAML-compliant authentication module in the web server (such as
// mod_auth_mellon - see https://code.google.com/p/modmellon/ ) and
// pass it to the IMAP server instead of a password.  The IMAP server
// will need to use an authentication mechanism that knows how to
// validate the assertion - one package that provides such mechanisms
// is crudesaml (see http://ftp.espci.fr/pub/crudesaml/README )
// (Note that you must set all this up before using this plugin).
//
// Note that you need to set $authenticated_username_location
// and $authenticated_password_location to the values that correspond
// to the username and the SAML assertion in the server environment.
// For example, if you're using the mod_auth_mellon implementation,
// you'll usually want to set $authenticated_username_location to
// "REMOTE_USER" and $authenticated_password_location to "MELLON_SAML_RESPONSE".
//
//
//
// Set this to "trusted_saml" to take advantage of the SAML single
// sign-on module that treats the presence of a SAML token in the web
// server environment as authoritative (it trusts that the web server
// has properly authenticated the user and that the token would not be
// available if the user were not authenticated).
//
// This module knows how to find a SAML assertion provided by a
// SAML-compliant authentication module in the web server (such as
// Shibboleth - see http://shibboleth.internet2.edu/about.html or
// mod_auth_tkt - see http://www.openfusion.com.au/labs/mod_auth_tkt ),
// after which it will use a shared secret to log the user in to
// the IMAP server.  This requires that the IMAP server support
// the SASL PLAIN login mechanism with the ability to accept separate
// authorization and authentication identities (for Dovecot, refer
// to the "master user" feature:
// http://wiki.dovecot.org/Authentication/MasterUsers and for Cyrus,
// refer to
// http://cyrusimap.web.cmu.edu/docs/cyrus-imapd/2.3.16/install-auth.php
// and http://cyrusimap.web.cmu.edu/docs/cyrus-sasl/2.1.23/sysadmin.php ).
// This also requires that SquirrelMail version 1.4.23 or above and that
// you set SquirrelMail's IMAP authentication mechanism to "plain".  You
// can do that in the main SquirrelMail configuration file or use the
// configuration tool to do so: config/conf.pl ==> 2. Server Settings ==>
// A. Update IMAP Settings ==> 6. Authentication type
//
// Note that you need to set $authenticated_username_location
// and $authenticated_password_location to the values that correspond
// to the username and the SAML assertion in the server environment.
// For example, if you're using the Shibboleth implementation, you'll
// usually want to set $authenticated_username_location to "uid" and
// $authenticated_password_location to "Shib-Session-ID".  In some more
// complex environments, the $authenticated_username_location might
// need to be set to a list, such as (remember, the first one in
// this list that is non-empty is used):
//
// $authenticated_username_location = array('mail', 'eduPersonPrincipalName', 'irisMailMainAddress', 'mail', 'uid');
//
// Some single sign-on implementations may not populate the server
// environment with any SAML data, only providing the authenticated
// user name (mod_auth_tkt?).  In this case, you'll typically want
// to set BOTH $authenticated_username_location AND
// $authenticated_password_location to "REMOTE_USER".  While this may
// seem somehow less secure, it isn't, given the sub-optimal way that
// "trusted_saml" modules work in the first place -- as long as the
// web server module guarantees that the "REMOTE_USER" variable will
// only be supplied when the user is authenticated.
//
//
//
// Any other value is assumed to be the name of a custom function that
// you've defined at the bottom of this file.  That function will be given
// two parameters: the value of the server environment variable for the
// username (whatever was found using $authenticated_username_location)
// and the value of the server environment variable for the password
// (whatever was found using $authenticated_password_location).  The
// function must return FALSE if validation failed, otherwise an array
// containing the username and password to be used for IMAP logins during
// the webmail login session (that could be the same as the parameters
// given to the function or a decoded version thereof or even some static
// value perhaps for the password if you are using some kind of SASL PLAIN
// authentication with a shared secret against the IMAP server, etc.).
//
//
//
// $external_auth_validation_type = 'http_auth';
// $external_auth_validation_type = 'authenticated_saml';
// $external_auth_validation_type = 'trusted_saml';
// $external_auth_validation_type = 'custom_sso_validate'; // see below for example
//
$external_auth_validation_type = 'http_auth';



// When using one of the single sign-on modules, it is strongly
// recommended that you allow this plugin to double check the validity
// of the user's external login session for every page request.  This
// ensures that the SquirrelMail session not outlast the external login
// session and that if a user logs out of the external session and logs
// back in as a different user, SquirrelMail won't show the wrong
// account (and ensuing errors related to cross-polution of user preferences).
//
// $required_environment_variable should be set to the name of the
// web server environment variable that should be checked during each
// page request.  It can be a list of values if need be.  Typically,
// this setting will be exactly the same as $authenticated_username_location
//
// $required_environment_variable_value_type indicates how the variable
// should be checked:
//
//    0  =  It must be the same as what is given for
//          $required_environment_variable_value below
//    1  =  Any value is acceptable, as long as it's not empty
//    2  =  It should match whatever it was when the user first logged in
//
// Usually, this should be 2, which is by far the safest method.
//
// If you don't want to use this feature (CAREFUL!), set
// $required_environment_variable to an empty value ("")
//
// $required_environment_variable = 'REMOTE_USER';
// $required_environment_variable_value_type = 2;
// $required_environment_variable_value = '';
//
$required_environment_variable = '';
$required_environment_variable_value_type = 2;
$required_environment_variable_value = '';



// When the user's external login session expires (per
// $required_environment_variable), the user will be shown a link
// to log in again.  Should that link point to the SquirrelMail
// login page (which itself is subject to the $normal_login_behavior
// setting and thus might itself be redirected)?
//
//    0  =  Use the SquirrelMail login page address
//    <external login address>  =  Must be a web address of an
//                                 external login page, %s will
//                                 be replaced in the address
//                                 with the SquirrelMail login
//                                 address and %e will be replaced
//                                 with the URL-encoded version
//                                 of the SquirrelMail login address
//
// Here's an example of an external login page
//
// $external_session_expiration_relogin_link = 'https://example.com/sso/login?return=%e';
//
$external_session_expiration_relogin_link = 0;



// When using the "trusted_saml" module, you'll need to supply the
// login credentials that can be used as an authentication identity
// when logging in as any user (a "master" credential)
//
$trusted_saml_username = '';
$trusted_saml_password = '';



// When using the "authenticated_saml" modules, you can have the
// SAML assertion zlib-compressed (RFC 1950), which may be necessary
// if the assertion is somewhat large (includes many attributes?)
//
// Note that you'll need to make sure PHP has Zlib support enabled
// (compile with --with-zlib) to use this feature.
// See: http://php.net/manual/en/zlib.installation.php
//
//    0  =  Do not change the SAML assertion
//    1  =  Zlib-compress the SAML assertion before
//          authentication with IMAP server
//
$authenticated_saml_compress_assertion = 0;



/**
  * This is an example of a custom external authentication validation module 
  *
  * @param string $AUTH_USER The username credential from the server environment
  * @param string $AUTH_PW   The password credential from the server environment
  *
  * @return mixed FALSE if validation failed, otherwise an array
  *               containing the username and password to be used
  *               for IMAP logins during the webmail login session
  *
  */
function custom_sso_validate($AUTH_USER, $AUTH_PW)
{

   if (!empty($AUTH_PW)) // you could also validate that $AUTH_USER is not empty
   {
      // maybe you'd want to decode and validate the password
      // (which might be a special token of some sort)
      
      // then you might generate some special password to send
      // to the IMAP server for logging in

      // you may or may not need to make use of the username,
      // which is stored in $AUTH_USER

      return array('<username>', '<password>');
   }

   return FALSE;

}



