<?php
/*  
 *  SquirrelMail Login Alias Plugin
 * 
 *  Copyright (c) 2001 Jay Guerette <JayGuerette_at_pobox.com>
 *  Copyright (c) 2002 David Minor <dave_at_dminor.com>
 *  Copyright (c) 2002-2005 by Paul Lesneiwski <pdontthink@angrynerds.com>
 *  
 *  Thanks to Christian Schneider <schneider_at_uni-dortmund.de> and
 *            Emerson <emereson_at_inetintl.com>
 *  for their contributions.
 *
 *  Please address questions about this plugin to the squirrelmail-plugins
 *  mailing list.
 *
 *  View the README document for information on installing this.  Also view
 *  plugins/README.plugins for more information.
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *  
 *  See the complete text at <../../COPYING>
 *  
 */


/**  
  * Register this plugin with SquirrelMail
  *
  */
function squirrelmail_plugin_init_login_alias() 
{

   global $squirrelmail_plugin_hooks;

   $squirrelmail_plugin_hooks['login_before']['login_alias'] 
      = 'login_alias_lookup_alias';
   $squirrelmail_plugin_hooks['options_personal_inside']['login_alias'] 
      = 'login_alias_options_set';
   $squirrelmail_plugin_hooks['options_personal_save']['login_alias'] 
      = 'login_alias_options_save';

}



if (!defined('SM_PATH'))
   define('SM_PATH', '../');



/**
  * Returns version info about this plugin
  *
  */
function login_alias_version() 
{

   return '2.4';

}



/**
  * Called when logging the user in; check alias list and remap 
  * username if alias is found
  *
  */
function login_alias_lookup_alias() 
{

   include_once(SM_PATH . 'plugins/login_alias/functions.php');
   login_alias_lookup_alias_do();

}



/**
  * Inserts text box on personal options page so user can set an alias
  *
  */
function login_alias_options_set() 
{

   include_once(SM_PATH . 'plugins/login_alias/functions.php');
   login_alias_options_set_do();

}



/**
  * Saves user's alias information
  *
  */
function login_alias_options_save() 
{

   include_once(SM_PATH . 'plugins/login_alias/functions.php');
   login_alias_options_save_do();

}


?>
