<?php

/*
 *  SquirrelMail Login Alias Plugin
 *
 *  Copyright (c) 2001 Jay Guerette <JayGuerette_at_pobox.com>
 *  Copyright (c) 2002 David Minor <dave_at_dminor.com>
 *  Copyright (c) 2002-2005 by Paul Lesneiwski <pdontthink@angrynerds.com>
 *
 *  Thanks to Christian Schneider <schneider_at_uni-dortmund.de> and
 *            Emerson <emereson_at_inetintl.com>
 *  for their contributions.
 *
 *  Please address questions about this plugin to the squirrelmail-plugins
 *  mailing list.
 *
 *  View the README document for information on installing this.  Also view
 *  plugins/README.plugins for more information.
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *  See the complete text at <../../COPYING>
 *
 */


// include compatibility plugin
//
if (defined('SM_PATH'))
   include_once(SM_PATH . 'plugins/compatibility/functions.php');
else if (file_exists('../plugins/compatibility/functions.php'))
   include_once('../plugins/compatibility/functions.php');
else if (file_exists('./plugins/compatibility/functions.php'))
   include_once('./plugins/compatibility/functions.php');



/**
  * Called when logging the user in; check alias list and remap 
  * username if alias is found
  *
  */
function login_alias_lookup_alias_do() 
{

    global $login_username, $$login_username, $plugins, $data_dir, 
           $prefs_are_cached, $prefs_cache, $foundLoginAlias,
           $prefs_dsn;


   // figure out where prefs are stored
   //
   if (isset($prefs_dsn) && !empty($prefs_dsn))
      $prefsInDB = true;
   else
   {
      $prefsInDB = false;

      // auto-create login alias file if needed
      //
      touch(getHashedFile('login_alias', $data_dir, "login_alias.pref"));
   }


    $user=$login_username;
    
    // if password_forget is loaded, use the obfuscated name
    if (in_array('password_forget',$plugins)) {
      if (!isset($$login_username)) compatibility_sqextractGlobalVar($login_username);
      if ($$login_username != '')
        $user=$$login_username;
    }

    // try to grab alias
    //
    $prefs_are_cached = false;
    $prefs_cache = array();
    session_unregister('prefs_are_cached');
    session_unregister('prefs_cache');

    $realname = getPref($data_dir,'login_alias',$user);

    $prefs_are_cached = false;
    $prefs_cache = array();
    session_unregister('prefs_are_cached');
    session_unregister('prefs_cache');

    $foundLoginAlias = 0;

    if (!isset($realname) || $realname=='') return;

    // before we do the reassignment, check if vlogin is installed,
    // if so, check if the alias is in the domain that the user
    // is logging in at (otherwise, ignore the alias)
    //
    if (in_array('vlogin',$plugins)) 
    {
       global $dontUseHostName;

       include_once (SM_PATH . 'plugins/vlogin/data/config.php');
       include_once (SM_PATH . 'plugins/vlogin/functions.php');

       $hostname = determine_user_hostname();

       if (!$dontUseHostName)
       {
          if (strpos($realname, $hostname) === FALSE)
             return;
       }
    }

    $foundLoginAlias = 1;

    // if password_forget is loaded, use the obfuscated name 
    //
    if (in_array('password_forget',$plugins) && $$login_username!='') 
        $$login_username = $realname;
    else 
        $login_username = $realname;

}



/**
  * Inserts text box on personal options page so user can set an alias
  *
  */
function login_alias_options_set_do() 
{

   global $data_dir, $username;

   bindtextdomain ('login_alias', SM_PATH . 'locale');
   textdomain ('login_alias');

   $login_alias = getPref($data_dir, $username, 'login_alias');

   echo '<tr><td align="right">' . _("Login Alias") . ":\n</td><td>\n"
      . "<input size='50' type='text' value='$login_alias' name='login_alias'>\n"
      . "</td>\n</tr>\n"
      . "<tr><td align='right'></td><td>"
      . _("You can use this or your regular account name to log in to your account.")
      . "<br><br>\n"
      . "</td>\n</tr>\n";

   bindtextdomain ('squirrelmail', SM_PATH . 'locale');
   textdomain ('squirrelmail');

}



/**
  * Saves user's alias information
  *
  */
function login_alias_options_save_do() 
{

    global $login_alias, $data_dir, $username, $prefs_are_cached,
           $prefs_cache, $color, $prefs_dsn, $plugins;


    compatibility_sqextractGlobalVar('login_alias');


   // figure out where prefs are stored
   //
   if (isset($prefs_dsn) && !empty($prefs_dsn))
      $prefsInDB = true;
   else
   {
      $prefsInDB = false;

      // auto-create login alias file if needed
      //
      touch(getHashedFile('login_alias', $data_dir, "login_alias.pref"));
   }


    if (isset($login_alias))
        $login_alias = trim($login_alias);
    else 
        return;



    // just go ahead and remove the alias if the user blanked it out
    //
    if (empty($login_alias))
    {

        // clear alias value
        //
	$old_login_alias = getPref($data_dir, $username, 'login_alias');
        removePref($data_dir, $username, 'login_alias');	

        $prefs_are_cached = false;
        $prefs_cache = array();
	session_unregister('prefs_are_cached');
	session_unregister('prefs_cache');

        cachePrefValues($data_dir, 'login_alias');
        removePref($data_dir, 'login_alias', $old_login_alias);	

        $prefs_are_cached = false;
        $prefs_cache = array();
	session_unregister('prefs_are_cached');
	session_unregister('prefs_cache');

        // recache user prefs
        //
        cachePrefValues($data_dir, $username);

        return;
    }


   // do we need to save an alias?
   //
   if (isset($login_alias) && $login_alias != '') 
   {

        $xtra_check = '';

        // check if vlogin is installed, and if so, we also need 
        // to check the proposed alias with domain info tacked on
        // to the end
        //
        if (in_array('vlogin',$plugins)) 
        {
            global $dontUseHostName, $at;

            include_once (SM_PATH . 'plugins/vlogin/data/config.php');
            include_once (SM_PATH . 'plugins/vlogin/functions.php');


            $hostname = determine_user_hostname();


            if (!$dontUseHostName)
            {
               $xtra_check = $login_alias . $at . $hostname;
            }
        }


        // get DB pref for possible real user...
        // 
        if ($prefsInDB)
        {
            
            $userExists = FALSE;

            include_once (SM_PATH . 'functions/db_prefs.php');

            $db = new dbPrefs;
            $db->open();

            $query = sprintf("SELECT %s FROM %s ".
                             "WHERE %s = '%s' AND %s = 'chosen_theme'",
                             $db->val_field,
                             $db->table,
                             $db->user_field,
                             $db->dbh->quoteString($login_alias),
                             $db->key_field);
            $res = $db->dbh->query($query);
            if (DB::isError($res)) 
            {
                $db->failQuery($res);
            }
    
            $row = $res->fetchRow(); 
            if ($row)
            {
                $userExists = TRUE;
            }

            if (!empty($xtra_check))
            {
                $query = sprintf("SELECT %s FROM %s ".
                                 "WHERE %s = '%s' AND %s = 'chosen_theme'",
                                 $db->val_field,
                                 $db->table,
                                 $db->user_field,
                                 $db->dbh->quoteString($xtra_check),
                                 $db->key_field);
                $res = $db->dbh->query($query);
                if (DB::isError($res)) 
                {
                    $db->failQuery($res);
                }
        
                $row = $res->fetchRow();
                if ($row)
                {
                    $userExists = TRUE;
                }
            }
        }


        // check for an alias that clashes with a real
        // username by looking for a prefs file for that
        // user or a DB entry for that user... if we get 
        // something, that means that we can't use this 
        // login alias
        //
        if ( (!$prefsInDB && (!empty($xtra_check) 
            && file_exists(getHashedFile($xtra_check, $data_dir, "$xtra_check.pref"))))
         || ($prefsInDB && $userExists))
        {
            include_once(SM_PATH . '/functions/display_messages.php');
            bindtextdomain ('login_alias', SM_PATH . 'locale');
            textdomain ('login_alias');
            plain_error_message(_("Alias is already in use.  Please select another alias.") 
                                . "<br><br>", $color);	    
            bindtextdomain ('squirrelmail', SM_PATH . 'locale');
            textdomain ('squirrelmail');
            return;
        }


      // Remove duplicated cached prefs for login_alias file 
      //
      $old_login_alias = getPref($data_dir, $username, 'login_alias');

      $prefs_are_cached = false;
      $prefs_cache = array();
      session_unregister('prefs_are_cached');
      session_unregister('prefs_cache');

      $alias_email = getPref($data_dir, 'login_alias', $login_alias);

      $prefs_are_cached = false;
      $prefs_cache = array();
      session_unregister('prefs_are_cached');
      session_unregister('prefs_cache');

	if ( $alias_email != $username && !empty($alias_email) ) {
            include_once(SM_PATH . '/functions/display_messages.php');
            bindtextdomain ('login_alias', SM_PATH . 'locale');
            textdomain ('login_alias');
            plain_error_message(_("Alias is already in use.  Please select another alias.") 
                                . "<br><br>", $color);	    
            bindtextdomain ('squirrelmail', SM_PATH . 'locale');
            textdomain ('squirrelmail');
	} else {

        // change cached prefs for login_alias 
        // file for writing changes                     
        //
        cachePrefValues($data_dir, 'login_alias');
        removePref($data_dir, 'login_alias', $old_login_alias);	
        setPref($data_dir, 'login_alias', $login_alias, $username);

        $prefs_are_cached = false;
        $prefs_cache = array();
	session_unregister('prefs_are_cached');
	session_unregister('prefs_cache');

        cachePrefValues($data_dir, $username);
        setPref($data_dir, $username, 'login_alias', $login_alias);

	}
    
    }
}


?>
