#!/usr/bin/python

"""
fv2smp.py - .forward/.vacation to SquirrelMail Plugin converter

Written August 2007 by Dan Astoorian, University of Toronto

THIS PROGRAM IS UNSUPPORTED, and is provided on an as-is basis.

This is a migration utility for sites where users already have
forwarding and/or autoresponders in place, and want to start using the
SquirrelMail local_autorespond_forward plugin.

This program inspects a user's existing .forward and .vacation.msg
files, and attempts to produce corresponding .forward.fwd,
.vacation.pref, .vacation.sq and .vacation.subj files for the
SquirrelMail local_autorespond_forward plugin.

Usage: ./fv2smp.py username [username...]

If run by the user (rather than by root), the username may be omitted.

"""

import os, sys, errno
import pwd
import re
import getopt
import email.Parser

# These settings should correspond to those in the plugin's config.php
# file.

# Output files:
laf_prefs_file = '.vacation.pref'
sq_vacation_subject_file = '.vacation.subj'
sq_forward_addresses_file = '.forward.fwd'
sq_vacation_file = '.vacation.sq'

# Input files:
vacation_file = '.vacation.msg'
forward_file = '.forward'

# Additional parameters
# domains: a list of domains considered local to this system (so that
# addresses of the form "username@domain" are recognized as keeping a
# local copy rather than forwarding to a remote site)
domains = [ "mydomain.example.com", ]

smfile_mode = 0600	# mode to use when writing new SM plugin config files

# homedir_prefix: should be "/", unless you're using the
# --enable-homedir-prefix= option of the suid backend.
homedir_prefix = "/"

# Construct the list of address formats from the list of domains
address_formats = [
    r"%s", r"\%s"
]
for a in domains:
    address_formats.extend([
	r"%%s@%s" % (a),
	r"\%%s@%s" % (a),
    ])

def writefile(filename, contents):
    fmode = os.O_WRONLY | os.O_CREAT | os.O_TRUNC
    if not opt_force:
	fmode |= os.O_EXCL
    if opt_noop:
	if opt_verbose:
	    sys.stderr.write("Into %s:\n%s\n%s\n%s\n" %
		(filename, "=" * 72, contents, "=" * 72)
	    )
    else:
	fdno = os.open(filename, fmode, smfile_mode)
	fd = os.fdopen(fdno, 'w')
	fd.write(contents)
	fd.close()

def douser(username):
    # Collect information from .forward and .vacation.msg files
    msg = None
    subject = None
    payload = None
    fwdlist = []

    do_autoreply = 0
    do_forward = 0
    no_local_delivery = 1
    identity = 0

    try:
	vacinfd = open(vacation_file, "r")
    except IOError, e:
	if e.errno != errno.ENOENT:
	    raise
    else:
	msg = email.Parser.Parser().parse(vacinfd)
	vacinfd.close()

    if msg is not None:
	# retrieve the subject and body (payload) of the message
	subject = msg.get("subject")
	payload = msg.get_payload()
	# if multipart, extract the first part (and first sub-part,
	# etc.)
	while type(payload) == type([]):
	    payload = payload[0].get_payload()
	# strip the last newline
	if payload[-1] == '\n':
	    payload = payload[:-1]
	    
    my_addresses = [ f % (username) for f in address_formats ]

    try:
	fwdinfd = open(forward_file, "r")
    except IOError, e:
	if e.errno != errno.ENOENT:
	    raise
    else:
	contents = fwdinfd.read()
	addresses = [a.strip() for a in re.split("[,\n]", contents)]
	for a in addresses:
	    if re.match('#', a):
		pass # comment
	    elif a in my_addresses:
		# refers to this account
		no_local_delivery = 0
	    elif re.search(r'\|.*vacation', a):
		# we assume it's a valid invocation of the vacation
		# program
		do_autoreply = 1
	    elif re.search(r'\|', a):
		raise ValueError, \
		    "Cannot handle pipe through program other than vacation"
	    elif a:
		do_forward = 1
		fwdlist.append(a)

    # write collected information into the files the plugin expects to see:
    if subject is not None:
	writefile(sq_vacation_subject_file, subject)
	
    if payload is not None:
	writefile(sq_vacation_file, payload)

    # special case: a .forward with no addresses is treated as if it
    # were absent.
    if len(fwdlist) == 0 and not do_forward and not do_autoreply:
	no_local_delivery = 0

    writefile(sq_forward_addresses_file, "\n".join(fwdlist))

    writefile(laf_prefs_file,
"""# DO NOT EDIT THIS FILE BY HAND
do_autoreply=%d
do_forward=%d
no_local_delivery=%d
identity=0""" % (do_autoreply, do_forward, no_local_delivery))


# mainline
uid = os.getuid()
is_root = (uid == 0)

opt_force = False
opt_verbose = False
opt_noop = False

opts, args = getopt.getopt(sys.argv[1:], "fnv")
for k, v in opts:
    if k == "-f":
	opt_force = True
    elif k == "-v":
	opt_verbose = True
    elif k == "-n":
	opt_noop = True

if len(args) == 0 and not is_root:
    args = [pwd.getpwuid(uid).pw_name]

for arg in args:
    if opt_verbose:
	sys.stderr.write("User %s:\n" % arg);
    os.chdir(homedir_prefix)
    try:
	try:
	    try:
		pwent = pwd.getpwnam(arg)
	    except KeyError:
		sys.stderr.write("User %s does not exist\n" % arg)
		continue
	    if is_root:
		# assume the user's privileges
		os.seteuid(pwent.pw_uid)
	    d = pwent.pw_dir
	    while len(d) > 0 and d[0] == '/':
		d = d[1:]
	    if (len(d)):
		os.chdir(d)
	    douser(arg)
	except Exception, e:
	    sys.stderr.write("User %s: exception: %s\n" % (arg, e))

    finally:
	if is_root:
	    # restore permissions so we can do the next user
	    os.seteuid(0)

