<?php
/**
 * Functions used in Limit Languages plugin
 *
 * Copyright (c) 2005 Tomas Kuliavas <tokul@users.sourceforge.net>
 * This file is part of SquirrelMail Limit Languages plugin.
 *
 * Limit Languages plugin is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Limit Languages plugin is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Limit Languages plugin; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * @copyright (c) 2005 Tomas Kuliavas <tokul@users.sourceforge.net>
 * @version $Id: functions.php,v 1.1 2005/06/22 13:09:03 tokul Exp $
 * @package sm-plugins
 * @subpackage limit_languages
 */

/** @ignore */
if (! defined('SM_PATH')) define('SM_PATH','../../');

/** declare globals */
global $limit_languages;

/** load default configuration */
if (file_exists(SM_PATH . 'plugins/limit_languages/config_default.php')) {
    include_once(SM_PATH . 'plugins/limit_languages/config_default.php');
} else {
    // load failsafe defaults
    $limit_languages = array();
}

/** load site configuration */
if (file_exists(SM_PATH . 'config/limit_languages_config.php')) {
    include_once(SM_PATH . 'config/limit_languages_config.php');
} elseif (file_exists(SM_PATH . 'plugins/limit_languages/config.php')) {
    include_once(SM_PATH . 'plugins/limit_languages/config.php');
}

/**
 * Filters $languages array
 */
function limit_languages_function() {
    global $languages, $limit_languages;

    if (is_array($limit_languages) && ! empty($limit_languages)) {
        $new_langs=array();
        foreach ($languages as $lang_code => $lang_data) {
            // detect language code ($languages['en_US']) that is present in $languages
            if (in_array($lang_code, $limit_languages)) {
                $new_langs[$lang_code]=$lang_data;
            }
            // detect language alias ($languages['en']) that is present in $languages
            if (isset($lang_data['ALIAS']) && in_array($lang_data['ALIAS'], $limit_languages)){
                $new_langs[$lang_code]=$lang_data;
            }
            // detect language alias that is used in plugins configuration ($limit_languages=array('en');)
            if (isset($lang_data['ALIAS']) && in_array($lang_code, $limit_languages)){
                $new_langs[$lang_data['ALIAS']]=$languages[$lang_data['ALIAS']];
            }
        }
        $languages=$new_langs;
    }
}

/**
 * Display warning if plugin is running with default configuration.
 */
function limit_languages_warning_function() {
    global $color;

    // check if configuration files exist
    if (! file_exists(SM_PATH . 'config/limit_languages_config.php') &&
        ! file_exists(SM_PATH . 'plugins/limit_languages/config.php')) {

        // error_box() function
        include_once(SM_PATH . 'functions/display_messages.php');

        bindtextdomain('limit_languages',SM_PATH . 'locale');
        textdomain('limit_languages');
        $error_message = _("Limit Languages plugin is running with default configuration. Check plugin's INSTALL documentation.");
        bindtextdomain('squirrelmail',SM_PATH . 'locale');
        textdomain('squirrelmail');

        // display error message
        error_box($error_message,$color);
    }
}
?>