<?php
   /**
    **  ldifimport_opt.php ver 1.4
    **  (c)2001 Nic Bernstein, for iTech, Inc.
    **  (c)2002 Nic Bernstein, for Onlight, llc.
    **  v. 1.4 modification (c) 2003 Brad Donison
    **
    **  Displays all options relating to importing an LDIF address book
    **
    **/

if (!defined('SM_PATH')) {
   chdir('../');
   define(SM_PATH, '../');
}

// include compatibility plugin
if (file_exists(SM_PATH . 'plugins/compatibility/functions.php'))
   include_once(SM_PATH . 'plugins/compatibility/functions.php');
else if (file_exists('./plugins/compatibility/functions.php'))
      include_once('./plugins/compatibility/functions.php');

if (file_exists(SM_PATH . 'functions/page_header.php'))
   include_once (SM_PATH . 'functions/page_header.php');
else if (file_exists('./functions/page_header.php'))
   include_once ('./functions/page_header.php');
if (file_exists(SM_PATH . 'functions/display_messages.php'))
  include_once (SM_PATH . 'functions/display_messages.php');
else if (file_exists('./functions/display_messages.php'))
  include_once ('./functions/display_messages.php');

if (compatibility_check_sm_version(1, 3)) {
   include_once (SM_PATH . 'include/validate.php');
   include_once (SM_PATH . 'include/load_prefs.php');
} else {
   include_once ('../src/validate.php');
   include_once ('../src/load_prefs.php');
}

   displayPageHeader($color, 'None');

?>
    <br>
    <table width="95%" align="center" border="0" cellpadding="2" cellspacing="0">
      <tr>
        <td bgcolor="<?php echo $color[0] ?>">
          <center>
            <b><?php echo _("Options") ?> - Address Book Import</b>
          </center>
        </td>
      </tr>
    </table>
    <p>
    This page will allow you to import an address book from another 
    e-mail application into <b><?php echo $org_name ?></b>.
    </p>
    <?php echo $GLOBALS['ldiff_infoblurb'] ?>
    <p>
    Use the <b>File / Browse</b> dialog below to select your <b>.ldif</b>
    address book file, and then hit the <b>Submit</b> button to upload and import
    the data into your <b><?php echo $org_name ?></b> Address Book.

    <form action="ldifimport.php" method="post" ENCTYPE="multipart/form-data">
      <table width="100%" cellpadding="0" cellspacing="2" border="0">
        <tr>
            <td align="right" nowrap>&nbsp
            </td>
            <td>
               <b>Address Book Filename</b>
               <input type="file" name="fname" size="48">
            </td>
         </tr>
         <tr>
            <td>&nbsp;
            </td>
            <td>
               <input type="submit" value="Submit" name="submit_ldifimport">
            </td>
         </tr>
      </table>   
    </form>
  </body>
</html>
