<?php

/* LDAP Global Preferences. Change these to your setup. */

$ldap_host = 'ldap.example.net';
$ldap_username = 'cn';
$ldap_base_dn = 'o=organization,c=country';

/* Credentials for the Squirrel Virtual user. If you don't have such a user, go
 * ahead and create him. */
$ldap_bind_dn = "uid=squirrel,ou=Squirrel,ou=Services,o=organization,c=country";
$ldap_bind_pw = "secret";

/* Credentials for the manager - only used when updating the objectclass */
$ldap_manager_dn = "cn=Manager,o=uoa,c=gr";
$ldap_manager_pw = "secret";

/* The object class that has all the squirrelmail attributes */
$ldap_objectclass = 'SquirrelMailUser';

/* The default Attributes' values. These are used if the LDAP value is null.
 * The format is simply:
 * 'squirrelmail_variable_name' => 'Default value'.
 * Consider this as our version of data/default_pref. */

$prefs_default = array (
'trash_folder' => 'INBOX.Trash',
'sent_folder' => 'INBOX.Sent' ,
'draft_folder' => 'INBOX.Drafts' ,
'show_html_default' =>  0,
'chosen_theme' => '../themes/bluesteel_theme.php',
'javascript_setting' =>  2,
'show_num' => 20,
'alt_index_colors' => 0,
'page_selector' => 1,
'page_selector_max' => 10,
'wrap_at' => 86,
'editor_size' => 76,
'include_self_reply_all' => 0,
'show_xmailer_default' => 0,
'attachment_common_show_images' => 0,
'pf_subtle_link' => 1,
'pf_cleandisplay' => 0,
'mdn_user_support' => 1,
'compose_new_win' => 0,
'language' => 'en_US',
'location_of_buttons' => 'between',
'use_signature' => 0,
'prefix_sig' => 1,
'order1' => 1,
'order2' => 2,
'order3' => 3,
'order4' => 5,
'order5' => 4,
'order6' => 6,
'left_size' => 180,
'unseen_notify' => 3, /* 2 */
'unseen_type' => 2, /* 1 */
'collapse_folders' => 1, /* 0 */
'date_format' => 6,
'hour_format' => 1,
'search_memory' => 0,
/* These are for enabling the special status of INBOX.Trash,Sent,Draft folders */
'move_to_trash' => 1,
'move_to_sent' => 1,
'save_as_draft' => 1,
/* Server-side sorting breaks if we do not provide a default */
'sort' => 0,
/* Mailfetch cypher always on */
'mailfetch_cypher' => 'on'
);


/* The schema: LDAP attributes, described in this array as:
   'LDAP attribute names' => 'Squirrelmail variable names' */

$ldap_attributes = array (	/* The first three are not actually
				Squirrelmail-specific attributes. */
'cn' => 'full_name',
'mail' => 'email_address',
'mailhost' => 'imapServerAddress',

/* Some other stuff, more advanced... */

/* 'mailalternateaddress' => 'mailalternateaddress', */

/* On to the squirrelmail specific values which will actually be changed and
 * written back to LDAP. */

'chosentheme' => 'chosen_theme',
'customcss' => 'custom_css',
'language' => 'language',
'javascriptsetting' => 'javascript_setting',
'saveoptionjavascriptautodetect' => 'save_option_javascript_autodetect',
'shownum' => 'show_num',

'usejavascriptaddrbook' => 'use_javascript_addr_book',
'includeselfreplyall' => 'include_self_reply_all',
'mdnusersupport' => 'mdn_user_support',
'composenewwin' => 'compose_new_win',
'trashfolder' => 'trash_folder',
'sentfolder' => 'sent_folder',
'draftfolder' => 'draft_folder',
'locationofbar' => 'location_of_bar',
'leftsize' => 'left_size',
'leftrefresh' => 'left_refresh',
'unseennotify' => 'unseen_notify',
'unseentype' => 'unseen_type',

'highlight0' => 'highlight0',
'highlight1' => 'highlight1',
'highlight2' => 'highlight2',
'highlight3' => 'highlight3',
'highlight4' => 'highlight4',
'highlight5' => 'highlight5',
'highlight6' => 'highlight6',
'highlight7' => 'highlight7',
'highlight8' => 'highlight8',
'highlight9' => 'highlight9',

'order1' => 'order1',
'order2' => 'order2',
'order3' => 'order3',
'order4' => 'order4',
'order5' => 'order5',
'order6' => 'order6', 

'replyto' => 'reply_to',
'signature' => 'signature',
'timezone' => 'timezone', 
'replycitationstyle' => 'reply_citation_style',
'replycitationstart' => 'reply_citation_start',
'replycitationend' => 'reply_citation_end',
'usesignature' => 'use_signature',

'mailpreferred' => 'mailpreferred'

/* Plugin attrs */

/* 'mailfetch' => 'mailfetch' */

);


/* The attributes that have boolean values need special treatment. :-( Repeat
 * them here...
 */

$boolean_attrs = array(
'includeselfreplyall' => 'include_self_reply_all',
'mdnusersupport' => 'mdn_user_support',
'composenewwin' => 'compose_new_win',

'usesignature' => 'use_signature'
);


/* Multivalue attributes */

$multivalue_attrs = array(
'mailfetch' => 'mailfetch'
);


/* Attributes that define allowed mail addresses. These are all multivalue attributes.
Again ldapattr => squirrelmailattr */

$alternatemail_attrs = array(
'mailalternateaddress' => 'alternateemails',
'mailauthorizedaddress' => 'mailauthorizedaddresses'
);

?>
