<?php
    /*
    *  SquirrelMail LDAP User Data Plugin 0.1
    *  By Alexandros Vellis <avel@noc.uoa.gr>
    *  Based on Retrieve User Data Plugin
    *  by Ralf Kraudelt <kraude@wiwi.uni-rostock.de>
    *
    */

require_once('../plugins/ldapuserdata/config.php');

function squirrelmail_plugin_init_ldapuserdata() {
	global $squirrelmail_plugin_hooks;

	// $squirrelmail_plugin_hooks["login_verified"]["ldapuserdata"] = "check_userdata";
	$squirrelmail_plugin_hooks["login_before"]["ldapuserdata"] = "get_userdata";
	$squirrelmail_plugin_hooks["logout"]["ldapuserdata"] = "flush_userdata";
}

/* My convenience function for connecting to the lDAP database.
 * $type is one of 'user', 'squirrel' or 'manager'.
 */

function connect_to_ldap ($type = 'user') {

	global $ldap_host, $username, $ldap_base_dn;
	global $ldap_bind_dn, $ldap_bind_pw, $ldap_manager_dn, $ldap_manager_pw;
	global $cleartext_passwd;

	$ldap_error = 0;

	if (!($ldap = ldap_connect($ldap_host))) {
		$ldap_error = 1;
		print "Could not connect to LDAP!";
		return false;
	}

	switch ($type) {
		case 'manager':
			$bind_result = ldap_bind( $ldap, $ldap_manager_dn, $ldap_manager_pw);
			break;
		case 'squirrel':
			$bind_result = ldap_bind( $ldap, $ldap_bind_dn, $ldap_bind_pw);
			break;
		case 'user':
		default:
			$bind_result = ldap_bind( $ldap, 'uid='.$username.',ou=people,'.$ldap_base_dn, $cleartext_passwd);
			break;
	}

	if (!$bind_result) {
		print "Error while binding to LDAP server as $username";
		return false;
	}
	return $ldap;
}

/*
 *  get user data from LDAP database. 
 */
   
function get_userdata() {
	/* Make these global, otherwise redirect.php won't get a hint about this. */
	global $login_username, $imapServerAddress, $prefs_cache, $prefs_before;
	global $full_name, $email_address;

	/* fill $prefs_cache with data from LDAP. */
	$prefs_cache = retrieve_data($login_username);

	
	/* $prefs_before will remain, for checking if there are any changes to
	 * write in the end. */ 
	$prefs_before = $prefs_cache;

	$imapServerAddress = $prefs_cache['imapServerAddress'];
	$full_name = $prefs_cache['full_name'];
	$email_address = $prefs_cache['email_address'];
	session_register('prefs_cache');
	session_register('prefs_before');
	session_register('imapServerAddress');
	session_register('full_name');
	session_register('email_address');
}


function retrieve_data ($uid) {

	global $ldap_host, $username, $ldap_base_dn, $ldap_bind_dn, $ldap_bind_pw;
	global $ldap_manager_dn, $ldap_manager_pw;
	global $ldap_objectclass, $prefs_default, $ldap_attributes, $boolean_attrs, $multivalue_attrs;
      
	$ldap = connect_to_ldap('squirrel');

	// $ldapattrarray = array_values($ldap_attributes);
	// print "<pre>"; print_r(array_keys($ldap_attributes)); print "</pre>";

	if (!($search_result = ldap_search($ldap, $ldap_base_dn, "UID=$uid",
	array_merge( array_keys($ldap_attributes), array_keys($multivalue_attrs), 'objectclass', 'mailalternateaddress') ))) {
		print "Error while searching for $uid.";
		exit;
	}

	$info = ldap_get_entries($ldap, $search_result);
	//print "<pre>DEBUG INFO array: \n"; print_r($info); print "</pre>";

	if (!is_array($info[0])) {
		print "Sorry, the username and/or password you have provided is incorrect.";
		session_destroy();
		exit;
	}
	      
	/* Check if we have objectClass $ldap_objectclass (default: SquirrelMailUser) */
	while(list($no, $class) = each($info[0]["objectclass"])) {
		if ($class == $ldap_objectclass) {
			$already_member = true;
			break;
		}
	}

	if ($info["count"] == 1) {
		reset($ldap_attributes);
		while(list($ldapattr, $squirrelattr) = each($ldap_attributes)) {
			//print "setting $ldapattr aka $squirrelattr to $info[0][$ldapattr][0] aka ";
			//print $info[0][$ldapattr][0]; print "...<br>"; 
			$prefs[$squirrelattr] = $info[0][$ldapattr][0];
		}
	} else {
		print "Error, more than one $uid found.";
		exit;
	}

	/* Special handling of some multivalue attributes */

	if ($info[0]['mailalternateaddress']['count']) {
		/* for($i = 0; $i < $info['mailalternateaddress']['count']; $i++) {
			$alternateemails[$i] = $info['mailalternateaddress'][$i];
		} */
		$prefs['alternateemails'] = $info[0]['mailalternateaddress'];
	}
	
	//print "info is:<pre>"; print_r($info); print "</pre>";

	if ($info[0]['mailfetch']['count']) {
		$prefs['mailfetch'] = $info[0]['mailfetch'];
	}

	/* Special treatment for POP mail-fetch...
	LDAP: mailfetch[0] = "server:alias:user:pass: etc.
	*/

	if($info[0]['mailfetch']['count'] > 0) {
		$prefs['mailfetch_server_number'] = $info[0]['mailfetch']['count'];

		for ($i=0; $i < $info[0]['mailfetch']['count']; $i++) {
			$fetcharray = explode (":", $prefs['mailfetch'][$i]);
			//print_r($fetcharray);
			$prefs['mailfetch_server_'.$i] = $fetcharray[0];
			$prefs['mailfetch_alias_'.$i] = $fetcharray[1];
			$prefs['mailfetch_user_'.$i] = $fetcharray[2];
			$prefs['mailfetch_pass_'.$i] = $fetcharray[3];
			$prefs['mailfetch_cypher_'.$i] = $fetcharray[4];
			$prefs['mailfetch_lmos_'.$i] = $fetcharray[5];
			$prefs['mailfetch_login_'.$i] = $fetcharray[6];
			$prefs['mailfetch_fref_'.$i] = $fetcharray[7];
			$prefs['mailfetch_subfolder_'.$i] = $fetcharray[8];
			$prefs['mailfetch_uidl_'.$i] = $fetcharray[9];
		}
	}
	ldap_close($ldap);

	/* Some additional thingies for the options:
	move_to_trash, move_to_sent, save_as_draft, which are NOT included in the
	ldap schema. */

	if($prefs['trash_folder'] && $prefs['trash_folder'] != 'none') {
		$prefs['move_to_trash'] = 1;
	} else { 
		$prefs['move_to_trash'] = 0;
	}

	if($prefs['sent_folder'] && $prefs['sent_folder'] != 'none') {
		$prefs['move_to_sent'] = 1;
	} else { 
		$prefs['move_to_sent'] = 0;
	}
	
	if($prefs['draft_folder'] && $prefs['draft_folder'] != 'none') {
		$prefs['save_as_draft'] = 1;
	} else { 
		$prefs['save_as_draft'] = 0;
	}


	/* If first time logged in, add me to the SquirrelMailUser objectclass */

	if(!$already_member) {
		$newinfo = array();
		$newinfo['objectclass'] = array();
		for($i = 0; $i < $info[0]["objectclass"]["count"]; $i++) {
			$newinfo['objectclass'][$i] =  $info[0]["objectclass"][$i];
		}
		// $newinfo["objectclass"][$objectclass[0]["objectclass"]["count"]] = $ldap_objectclass;
		$newinfo["objectclass"][$i] = $ldap_objectclass;
		
		// print "I will modify objectclass as follows:";
		// print "<pre>"; print_r($newinfo); print "</pre>";
		$ldap2 = connect_to_ldap('manager');
		
		if(!ldap_modify($ldap2, "uid=$uid,ou=people,$ldap_base_dn" , $newinfo)) {
			print "<STRONG>Error while updating your objectclass! Could not modify LDAP data.</strong>";
			exit;
		} 
		ldap_close($ldap2);
		// $HTTP_SESSION_VARS['first_time_user'] = 1;
		//session_register($first_time_user);
	} 
	while(list($ldapattr, $squirrelattr) = each($boolean_attrs)) {
		if( array_key_exists($squirrelattr, $prefs) ) {
			if($prefs[$squirrelattr] == "TRUE") {
				$prefs[$squirrelattr] = 1;
			} elseif ($prefs[$squirrelattr] == "FALSE") {
				$prefs[$squirrelattr] = 0;
			}
		}
	}

	return($prefs);

}

   /*
    *  write user data to LDAP database
    */
   
function flush_userdata() {
      include("../plugins/ldapuserdata/config.php");

      global $username, $HTTP_SESSION_VARS;
      global $ldap_host;
      global $ldap_objectclass, $prefs_default, $ldap_attributes, $boolean_attrs;

      global $prefs_cache;

      // prepare data
      $attr_to_write=array();
      
      while(list($ldapattr, $squirrelattr) = each($ldap_attributes)) {
          if( !( ($ldapattr == "cn") || ($ldapattr == "mail") || ($ldapattr == "mailhost")) ) {
	  	
	      if($HTTP_SESSION_VARS['prefs_cache'][$squirrelattr] != $HTTP_SESSION_VARS['prefs_before'][$squirrelattr] )
	      		if ($HTTP_SESSION_VARS['prefs_cache'][$squirrelattr] != "" ) {
	          // print "<br>DEBUG: Checking if ".$HTTP_SESSION_VARS['prefs_cache'][$squirrelattr]." is different than ".$HTTP_SESSION_VARS['prefs_before'][$squirrelattr]."<br>";
		          $attr_to_write[$ldapattr] = $HTTP_SESSION_VARS['prefs_cache'][$squirrelattr];
			} else {
			  $attr_to_del[$ldapattr] = $HTTP_SESSION_VARS['prefs_before'][$squirrelattr];
	      }
	  }
      }

	/* Handle boolean attributes */
	while(list($ldapattr, $squirrelattr) = each($boolean_attrs)) {
		if( array_key_exists($ldapattr, $attr_to_write) ) {
			if($attr_to_write[$ldapattr]) {
				$attr_to_write[$ldapattr] = 'TRUE';
			} else {
				$attr_to_write[$ldapattr] = 'FALSE';
			}
		}
	}

	/* Handle multivalue attributes */
	if($_SESSION['prefs_cache']['mailfetch_server_number'] > 0) {
		//print "putting mailfetch vars";
		
		for ($i=0; $i < $_SESSION['prefs_cache']['mailfetch_server_number']; $i++) {
			//print "writing # $i";

			$newarray[0] = $_SESSION['prefs_cache']['mailfetch_server_'.$i];
			$newarray[1] = $_SESSION['prefs_cache']['mailfetch_alias_'.$i]; 
			$newarray[2] = $_SESSION['prefs_cache']['mailfetch_user_'.$i]; 
			$newarray[3] = $_SESSION['prefs_cache']['mailfetch_pass_'.$i];
			$newarray[4] = $_SESSION['prefs_cache']['mailfetch_cypher_'.$i];
			$newarray[5] = $_SESSION['prefs_cache']['mailfetch_lmos_'.$i]; 
			$newarray[6] = $_SESSION['prefs_cache']['mailfetch_login_'.$i];
			$newarray[7] = $_SESSION['prefs_cache']['mailfetch_fref_'.$i]; 
			$newarray[8] = $_SESSION['prefs_cache']['mailfetch_subfolder_'.$i];
			$newarray[9] = $_SESSION['prefs_cache']['mailfetch_uidl_'.$i]; 
			
			$mailfetchpref[$i] = implode (":", $newarray);
			//print_r($mailfetchpref);
		}

		for($i=0; $i<sizeof($mailfetchpref) ;$i++) {
			if($mailfetchpref[$i] != $_SESSION['prefs_before']['mailfetch'][$i]) {
				$different = true;
			}
		}
		
		if($different) {
			for($i=0; $i<sizeof($mailfetchpref) ;$i++) {
				$attr_to_write['mailfetch'][$i] = $mailfetchpref[$i];
			}
		}

	}

	/*while(list($ldapattr, $squirrelattr) = each($multivalue_attrs)) {
		while( list(
		}
	}*/
	
	/* Now our $attr_to_write and $attr_to_del arrays are ready. */

	 //print "I will write these on LDAP:";
	 //print "<pre>"; print_r($attr_to_write); print "</pre>";
	 //print "I will clear these on LDAP:";
	 //print "<pre>"; print_r($attr_to_del); print "</pre>";

	/* Starting Write Process.  Of course, perform a write on our poor
	 * LDAP, only if there _is_ something different to write. 
	 */
	
	if(!(sizeof($attr_to_write) == 0)) {
		$ldap = connect_to_ldap('manager');


	//	$objarr = array("objectClass");
		/* Check if we have objectClass $ldap_objectclass (default: SquirrelMailUser) */
	//	if (!($sr = ldap_search($ldap, $ldap_base_dn, "UID=$username", array("objectClass")))) {
	//		print "Cound not get objectclass values for $username.";
	//		exit;
	//	}
	//	$objectclassinfo = ldap_get_entries($ldap, $sr);

		// print "DEBUG: I will now execute ldap_modify (ldap,
		// uid=$username,ou=people,$ldap_base_dn , $attr_to_write)";
		
		if(!ldap_modify($ldap, "uid=$username,ou=people,$ldap_base_dn" , $attr_to_write)) {
			print "<STRONG>ERROR: While writing your preferences, an error had
			occured on the LDAP server.</strong><br />
			Please contact your administrator.";
		} 
		if(sizeof($attr_to_del) == 0) {
			ldap_close($ldap);
		}
	}


	if(!(sizeof($attr_to_del) == 0)) {
		if(sizeof($attr_to_write) == 0) {
			$ldap = connect_to_ldap('manager');
		}
		
		if(!ldap_mod_del($ldap, "uid=$username,ou=people,$ldap_base_dn", $attr_to_del)) {
			print "<STRONG>ERROR: While writing your preferences, an error had
			occured on the LDAP server.</strong> (ldap_mod_del)<br />
			Please contact your administrator.";
		}
		ldap_close($ldap);
	}
}

/* $cleartext_password = OneTimePadDecrypt($password, $onetimepad); */

?>
