<?php
/**
 * Contains translatable strings for LDAP cosine schema attributes.
 * RFC1274: Cosine and Internet X.500 schema
 * Data source: OpenLDAP cosine.schema,v 1.15
 * @copyright 2005-2006 The SquirrelMail Project Team
 * @license http://opensource.org/licenses/gpl-license.php GNU Public License
 * @version $Id: cosine.php,v 1.4 2006/03/21 17:21:10 tokul Exp $
 * @package sm-plugins
 * @subpackage ldapquery
 */

/* Make sure that variables are arrays (and hide top comments from translated strings:)) */
if (! is_array($ldq_attrib))
    $ldq_attrib=array();
if (! is_array($ldq_object))
    $ldq_object=array();

$ldq_attrib['textEncodedORAddress']['NAME']=_("Encoded Text or Address");

$ldq_attrib['info']['NAME']=_("Info");

// Favorite drink (noun)
$ldq_attrib['drink']['NAME']=_("Drink");
$ldq_attrib['favouriteDrink']=$ldq_attrib['drink'];

$ldq_attrib['roomNumber']['NAME']=_("Room Number");

$ldq_attrib['photo']['NAME']=_("Photo");

$ldq_attrib['userClass']['NAME']=_("Category of user");

$ldq_attrib['host']['NAME']=_("Host");

$ldq_attrib['manager']['NAME']=_("Manager");

$ldq_attrib['documentIdentifier']['NAME']=_("Document identifier");

$ldq_attrib['documentTitle']['NAME']=_("Document Title");

$ldq_attrib['documentVersion']['NAME']=_("Document version");

$ldq_attrib['documentAuthor']['NAME']=_("Document author");

$ldq_attrib['documentLocation']['NAME']=_("Location of document");

$ldq_attrib['homePhone']['NAME']=_("Home Phone");
$ldq_attrib['homeTelephoneNumber']=$ldq_attrib['homePhone'];

$ldq_attrib['secretary']['NAME']=_("Secretary");

$ldq_attrib['otherMailbox']['NAME']=_("Other Mailbox");

// DNS A record entries
$ldq_attrib['aRecord']['NAME']=_("A Record");

// DNS MD record entries
$ldq_attrib['mDRecord']['NAME']=_("MD Record");

// DNS MX record entries
$ldq_attrib['mXRecord']['NAME']=_("MX Record");

// DNS NS record entries
$lda_attrib['nSRecord']['NAME']=_("NS Record");

// DNS SOA record entries
$ldq_attrib['sOARecord']['NAME']=_("SOA Record");

// DNS CNAME record entries
$ldq_attrib['cNAMERecord']['NAME']=_("CNAME Record");

$ldq_attrib['associatedName']['NAME']=_("Associated Name");

$ldq_attrib['homePostalAddress']['NAME']=_("Home Postal Address");

$ldq_attrib['personalTitle']['NAME']=_("Personal Title");

$ldq_attrib['mobile']['NAME']=_("Mobile Phone Number");
$ldq_attrib['mobileTelephoneNumber']=$ldq_attrib['mobile'];

$ldq_attrib['pager']['NAME']=_("Pager");
$ldq_attrib['pagerTelephoneNumber']=$ldq_attrib['pager'];

$ldq_attrib['co']['NAME']=_("Country");
$ldq_attrib['friendlyCountryName']=$ldq_attrib['co'];

$ldq_attrib['uniqueIdentifier']['NAME']=_("Unique Identifier");

$ldq_attrib['organizationalStatus']['NAME']=_("Organizational status");

// Mail address in rfc733 format
$ldq_attrib['janetMailbox']['NAME']=_("Janet mailbox");

$ldq_attrib['mailPreferenceOption']['NAME']=_("Mail Preference Option");

$ldq_attrib['buildingName']['NAME']=_("Name of building");

$ldq_attrib['dSAQuality']['NAME']=_("DSA Quality");

$ldq_attrib['singleLevelQuality']['NAME']=_("Single Level Quality");

$ldq_attrib['subtreeMinimumQuality']['NAME']=_("Subtree Minimum Quality");

$ldq_attrib['subtreeMaximumQuality']['NAME']=_("Subtree Maximum Quality");

$ldq_attrib['personalSignature']['NAME']=_("Personal Signature");

// Redirection to other entry in directory
$ldq_attrib['dITRedirect']['NAME']=_("DIT Redirect");

$ldq_attrib['audio']['NAME']=_("Audio");

$ldq_attrib['documentPublisher']['NAME']=_("Publisher of document");


$ldq_object['pilotPerson']['NAME']=_("Pilot Person");
$ldq_object['newPilotPerson']=$ldq_object['pilotPerson'];

$ldq_object['account']['NAME']=_("Account");

$ldq_object['document']['NAME']=_("Document");

$ldq_object['room']['NAME']=_("Room");

$ldq_object['documentSeries']['NAME']=_("Document Series");

// can represent dns and nrs domain objects
$ldq_object['domain']['NAME']=_("Domain");

$ldq_object['RFC822localPart']['NAME']=_("RFC822 Local Part");

$ldq_object['dNSDomain']['NAME']=_("DNS Domain");

$ldq_object['domainRelatedObject']['NAME']=_("Object related to domain");

$ldq_object['friendlyCountry']['NAME']=_("Friendly Country");

$ldq_object['pilotOrganization']['NAME']=_("Pilot Organisation");

$ldq_object['pilotDSA']['NAME']=_("Pilot DSA");

$ldq_object['qualityLabelledData']['NAME']=_("Quality Labelled Data");
?>