<?php
/**
 * ldapquery options
 * @copyright 2001-2004 Brent Bice <bbice@persistence.com>
 * @copyright 2004-2006 The SquirrelMail Project Team
 * @license http://opensource.org/licenses/gpl-license.php GNU Public License
 * @version $Id: options.php,v 1.12 2006/03/21 17:21:10 tokul Exp $
 * @package sm-plugins
 * @subpackage ldapquery
 */

/** 
 * SM_PATH define
 * @ignore 
 */
define('SM_PATH','../../');

/** Including required squirrelmail files */
include_once (SM_PATH . 'include/validate.php');
/** needed for sqm_baseuri() */
include_once (SM_PATH . 'functions/display_messages.php');

/** display page header */
displayPageHeader($color, "None");

// switch to ldapquery domain
bindtextdomain('ldapquery',SM_PATH . 'locale');
textdomain('ldapquery');

$ldq_check = ldq_check_setup();
if (! empty($ldq_check)) {
    bindtextdomain('squirrelmail',SM_PATH . 'locale');
    textdomain('squirrelmail');
    error_box($ldq_check,$color);
    exit('</body></html>');
}

$ldq_loaded_schemas=ldq_load_schemas();

echo "<br />\n"
. '<table width="95%" align="center" border="0" cellpadding="2" cellspacing="0">'
. '<tr><td bgcolor="' . $color[0] . '">'
. '<center><b>' . _("Options - Directory Preferences") . '</b></center>'
. '</td></tr></table>';

// add identation
echo "<blockquote>\n";

echo '<p>' . _("Output types can be:") . "</p>\n";
   
echo '<dl>'
. '<dt><b>' . _("One Table") . "</b></dt>\n"
. '<dd>' . _("One big table with one row per record found and each selected attribute as a separate column.") . "</dd>\n"
. '<dt><b>' . _("Multiple Tables") . "</b></dt>\n"
. '<dd>' . _("One table per record found with 2 columns for each table. One column contains attribute names and the 2nd column shows values for each attribute.  This format is best if you have many attributes selected or if the values for some of the attributes you have selected can be very long with no spaces (like labeledurl).") . "</dd>\n"
. "</dl>\n";

echo '<form action="' . sqm_baseuri().'src/options.php' . '" method="post">';
echo '<table border="0" cellpadding="0" cellspacing="2">'
. '<tr><th align="right" nowrap>' . _("Select Output Type:") . '</th>'
. '<td><select name="ldapquery_output_type">';
ldapquery_ShowOption('output_type', 'OneTable', _("One Table"));
ldapquery_ShowOption('output_type', 'MultiTable', _("Multiple Tables"));
echo '</select>'
. '</td></tr>'
. '<tr><td colspan="2">&nbsp;</td></tr>'
. '<tr><th colspan="2" align="left">'
. _("Select Displayed Fields") . "</th></tr>\n";
ldapquery_ShowCheckboxes ($ldq_attributes);
echo '</td></tr>'
. '<tr>'
. '<td>&nbsp;</td>'
. '<td>'
. '<input type="hidden" name="optmode" value="submit">'
. '<input type="hidden" name="optpage" value="ldapquery">'
. '<input type="submit" value="' . _("Submit") . '" name="submit_ldapquery">'
. '</td>'
. '</tr>'
. '</table>'
. '</form>';
?>
</blockquote>
</body></html>
