<?php
/**
 * Script controls address addition to address book
 * @copyright 2006 The SquirrelMail Project Team
 * @license http://opensource.org/licenses/gpl-license.php GNU Public License
 * @version $Id: addressbook.php,v 1.3 2006/03/21 17:21:10 tokul Exp $
 * @package sm-plugins
 * @subpackage ldapquery
 */

/** @ignore */
define('SM_PATH','../../');
/** main SquirrelMail functions */
include_once(SM_PATH . 'include/validate.php');
/** address book functions */
include_once(SM_PATH . 'functions/addressbook.php');
/** own functions */
include_once(SM_PATH . 'plugins/ldapquery/functions.php');

/**
 * get address book entry from POST
 * set array key to empty value, if it is missing.
 * $addaddr - address book form data. array with 5 fields.
 * Array
 * (
 *   [nickname] => unique (equal to email, if missing)
 *   [email] => required
 *   [firstname] => firstname+lastname should not be empty
 *   [lastname] => firstname+lastname should not be empty
 *   [label] => optional
 * )
 */
if (! sqgetGlobalVar('addaddr',$addaddr,SQ_POST) || ! is_array($addaddr)) {
    $addaddr=array();
}

/* fill addaddr array */
if (!isset($addaddr['email'])) $addaddr['email']='';
if (!isset($addaddr['firstname'])) $addaddr['firstname']='';
if (!isset($addaddr['lastname'])) $addaddr['lastname']='';
if (!isset($addaddr['nickname'])) $addaddr['nickname'] = $addaddr['email'];
if (!isset($addaddr['label'])) $addaddr['label'] = '';

/* trim array entries */
array_walk($addaddr,'ldq_arraytrim');

/* standard page header */
displayPageHeader($color,'none');

/*
 * don't display address book init errors (we will handle errors) 
 * and don't init ldap backends (we need only personal address book)
 */
$abook=addressbook_init(false,true);

// switch to ldapquery domain
bindtextdomain('ldapquery',SM_PATH . 'locale');
textdomain('ldapquery');

/* check if address book is initialized */
if($abook->error) {
    ldq_error_box($abook->error);
} elseif ($abook->localbackend == 0) {
    $error_msg = _("Personal address book is not available.");
    ldq_error_box($error_msg);
} else {
    $error_msg = '';

    if (empty($addaddr['email']) ) {
        // checked email field
        $error_msg = _("Email address is not set or empty.");
    } elseif (empty($addaddr['firstname']) && empty($addaddr['lastname'])) {
        // checked both name fields
        $error_msg = _("Name is not set or empty.");
    }
    
    if (empty($error_msg)) {
        // If you use $abook->error, check gettext domain
        if ($abook->lookup($addaddr['nickname'])) {
            $error_msg = sprintf(_("Nickname %s is already in use."),htmlspecialchars($addaddr['nickname']));
        } elseif (! $abook->add($addaddr,$abook->localbackend)) {
            $error_msg = _("Can't create address book entry.");
        }
    }
    
    if (!empty($error_msg)) {
        ldq_error_box($error_msg);
        
        echo '<br />'
            .addForm('addressbook.php')
            .ldq_hidden_search_fields()
            .html_tag('table',
                html_tag('tr',
                    html_tag('td',_("Nickname: "),'right').
                    html_tag('td',addInput("addaddr[nickname]",$addaddr['nickname']))).
                html_tag('tr',
                    html_tag('td',_("First name: "),'right').
                    html_tag('td',addInput("addaddr[firstname]",$addaddr['firstname']))).
                html_tag('tr',
                    html_tag('td',_("Last name: "),'right').
                    html_tag('td',addInput("addaddr[lastname]",$addaddr['lastname']))).
                html_tag('tr',
                    html_tag('td',_("E-mail: "),'right').
                    html_tag('td',addInput("addaddr[email]",$addaddr['email']))).
                html_tag('tr',
                    html_tag('td',_("Info: "),'right').
                    html_tag('td',addInput("addaddr[label]",$addaddr['label']))).
                html_tag('tr',
                    html_tag('td',addSubmit(_("Add address")),'center','','colspan="2"')),
            'center')
            .'</form>';
    } else {
        echo html_tag('p',_("Address book entry is saved."),'center');
    }
}

echo '<br /><center>'
    .addForm('ldapquery.php')
    .ldq_hidden_search_fields()
    .addSubmit(_("Return to search results"))
    .'</form></center>';
?>
</body></html>
