<?php
/**
 * ldapquery plugin - setup script
 * @copyright 2001-2004 Brent Bice <bbice@persistence.com>
 * @copyright 2004 SquirrelMail Development Team
 * @version $Id: setup.php,v 1.3 2004/10/24 12:08:20 tokul Exp $
 * @package plugins
 * @subpackage ldapquery
 */

/**
 * SM_PATH define
 * @ignore
 */
if (!defined('SM_PATH'))  {
    define('SM_PATH','../../');
}

/**
 * Init plugin
 */
function squirrelmail_plugin_init_ldapquery() {
  global $squirrelmail_plugin_hooks;

  $squirrelmail_plugin_hooks['menuline']['ldapquery'] = 'ldapquery_menuline';
  $squirrelmail_plugin_hooks['optpage_register_block']['ldapquery'] = 'ldapquery_options';
  $squirrelmail_plugin_hooks['options_save']['ldapquery'] = 'ldapquery_save';
  $squirrelmail_plugin_hooks['optpage_set_loadinfo']['ldapquery'] = 'ldapquery_set_loadinfo';
  $squirrelmail_plugin_hooks['loading_prefs']['ldapquery'] = 'ldapquery_prefs';
}

/**
 * Add meniu line
 */
function ldapquery_menuline () {
   displayInternalLink ("plugins/ldapquery/ldapquery.php", _("Directory"), "right");
   echo "&nbsp;&nbsp;\n";
}

/**
 * Add options block
 */
function ldapquery_options() {
    global $optpage_blocks;

    $optpage_blocks[] = array(
        'name' => _("Directory Preferences"),
        'url'  => SM_PATH . 'plugins/ldapquery/options.php',
        'desc' => _("These settings control what type of output you will see when you use the Directory link to search Directory Services."),
        'js'   => false
        );
}

/**
 * Save options
 */
function ldapquery_save() {
    global $username, $data_dir;
    global $ldq_attributes;

    include_once (SM_PATH . 'plugins/ldapquery/config.php');

    if (sqgetGlobalVar('submit_ldapquery',$ldq_submit,SQ_POST)) {
        if (! sqgetGlobalVar('ldapquery_output_type',$ldapquery_output_type,SQ_POST))
            $ldapquery_output_type='OneTable';

        foreach ($ldq_attributes as $attr) {
            $Var = 'ldapquery_showattr_'.$attr;
            if (! sqgetGlobalVar($Var,$$Var,SQ_POST))
                $$Var = "off";

            setPref($data_dir, $username, $Var, $$Var);
        }

        setPref($data_dir, $username, 'ldapquery_output_type',$ldapquery_output_type);
    }
}

/**
 * Set optpage_name displayed when settings are saved
 */
function ldapquery_set_loadinfo() {
    global $optpage, $optpage_name;
    if ($optpage=='ldapquery') {
        $optpage_name = _("Directory Preferences");
    }
}

/**
 * Load plugin preferences
 */
function ldapquery_prefs() {
    global $username, $data_dir;
    global $ldq_attributes;
    include_once (SM_PATH . 'plugins/ldapquery/config.php');

    global $ldapquery_output_type;
    $ldapquery_output_type = getPref($data_dir, $username, 'ldapquery_output_type','OneTable');

    foreach ($ldq_attributes as $attr) {
        $Var = "ldapquery_showattr_" . $attr;
        global $$Var;
        $$Var = getPref($data_dir, $username,$Var,'on');
    }
}
?>