<?php
/**
 * ldapquery plugin - main query script
 *
 * @copyright 2001-2004 Brent Bice <bbice@persistence.com>
 * @copyright 2004 SquirrelMail Development Team
 * @version $Id: ldapquery.php,v 1.5 2004/10/24 12:16:45 tokul Exp $
 * @package plugins
 * @subpackage ldapquery
 */

/** 
 * SM_PATH define
 * @ignore 
 */
define('SM_PATH','../../');

/** Including required squirrelmail files */
include_once (SM_PATH . 'include/validate.php');

/** Including site config */
include_once (SM_PATH . 'plugins/ldapquery/config.php');

/**
 * compare attributes for sorting results
 * @param mixed $left
 * @param mixed $right
 * @return mixed
 */
function ldapquery_compattrs ($left, $right) {
    return strcasecmp($left,$right);
}

/** 
 * Convert a string with a name in it in firstname first
 * format to a lastname first formatted string
 * @param mixed $fnf
 * @return mixed
 */
function ldapquery_lnf ($fnf) {
    $name = explode(" ", $fnf);
    if (count($name) > 1)
        $lnf = $name[count($name)-1];
    else
        $lnf = "";
    for ($i = 0; $i < count($name)-1; $i++)
        $lnf .= $name[$i];
    return $lnf;
}

/**
 * compare cn attributes for sorting results by lastname
 * This is a bit of a hack for those of us who don't have surname
 * attributes in our LDAP records (so we can't just select it in
 * "sort by".
 * @param mixed $left
 * @param mixed $right
 * @return mixed
 */
function ldapquery_compcns ($left, $right) {
    // find last names and put it at start of strings
    $left_lnf = ldapquery_lnf ($left);
    $right_lnf = ldapquery_lnf ($right);
    
    return strcasecmp($left_lnf,$right_lnf);
}

/**
 * ldapquery_dispresultsMulti - display HTML results from an LDAP query
 *   takes the list of attributes that were searched for and the
 *   returned results as parameters
 * @param mixed $attributes
 * @param mixed $entry
 * @param mixed $sortby
 * @return mixed
 */
function ldapquery_dispresultsMulti ($attributes, $entry, $sortby) {
    // sort the entries. First, build an array with the sortby as the key
    // and the entry index as the value
    global $compose_new_win, $base_uri;
    if ($entry["count"] > 0) {
        for ($i=0 ; $i < $entry["count"]; $i++) {
            $Val = $entry[$i][$sortby][0] . $i;
            $sorted[$Val] = $i;
        }
        if ($sortby == "cn")
            uksort ($sorted, "ldapquery_compcns");
        else
            uksort ($sorted, "ldapquery_compattrs");

        foreach ($sorted as $key=>$i) {
            echo '<table border="border">';
   
            foreach ($attributes as $attr_full=>$attr) {
                $Var = "ldapquery_showattr_" . $attr;
                global $$Var;
                if ($$Var == "on") {
                    if (isset($entry[$i][$attr])) {
                        for ($x=0 ; $x < $entry[$i][$attr]["count"] ; $x++) {
                            // print one row of table of attr/value pairs
                            // print attribute cell
                            echo "<tr>\n";
                            echo "<td>$attr_full</td><td>";

                            // print value cell
                            // separate and print multi-line values
                            // For labeledurl attribs, make the first part a link
      
                            switch ($attr) {
                            case "labeledurl":
                                // split up url and label parts
                                $val = $entry[$i][$attr][$x] . " <END>";
                                $isfirsttoken = true;
                                for ($token = strtok($val, " "); $token != "<END>";
                                     $token = strtok(" "))
                                    {
                                        if ($isfirsttoken) {
                                            echo "<a href=\"$token\">";
                                        }
                                        echo "$token";
                                        if ($isfirsttoken) {
                                            echo '</a> ';
                                            $isfirsttoken = false;
                                        }
                                    }
                                break;
                            case "mail":
                                $val = $entry[$i][$attr][$x];
                                if ($compose_new_win == '1') {
                                    print ("<a href=$base_uri/src/compose.php".
                                           "?send_to=$val target=\"compose_window\" ".
                                           "onClick=\"comp_in_new()\">$val</a>\n");
                                } else {
                                    displayInternalLink ("src/compose.php?send_to=$val",
                                                         "$val", "right");
                                }
                                break;
                            default:
                                $val = $entry[$i][$attr][$x] . "$<END>";
                                for ($token = strtok($val, "\$");
                                     $token != "<END>"; $token = strtok("\$"))
                                    {
                                        echo "$token<br />";
                                    }
                                echo "</td>\n";
                                echo "</tr>\n";
                            }
                        }
                    } else {
                        echo "<tr>\n";
                        echo "<td>$attr_full</td>";
                        echo "<td>&nbsp;</td></tr>";
                    }
                }
            }
            echo "</table>\n";

            echo '<hr />';
        }
    } else {
        echo _("No records found") . "<br />\n";
    }
}

/**
 * display HTML results from an LDAP query
 *   with each record being one row in a single table
 *   takes the list of attributes that were searched for and the
 *   returned results as parameters
 */
function ldapquery_dispresultsSingle ($attributes, $entry, $sortby) {
    // sort the entries. First, build an array with the sortby as the key
    // and the entry index as the value
    if ($entry["count"] > 0) {
        for ($i=0 ; $i < $entry["count"]; $i++) {
            $Val = $entry[$i][$sortby][0] . $i;
            $sorted[$Val] = $i;
        }
        if ($sortby == "cn")
            uksort ($sorted, "ldapquery_compcns");
        else
            uksort ($sorted, "ldapquery_compattrs");

        echo '<table border="border">';

        // print table headers
        echo '<tr>';
        foreach ($attributes as $attr_full=>$attr) {
            $Var = "ldapquery_showattr_" . $attr;
            global $$Var;
            if ($$Var == "on") {
                echo "<td><b>$attr_full</b></td>";
            }
        }
        echo "</tr>\n";

        foreach ($sorted as $key=>$i) {
            foreach ($attributes as $attr) {
                $Var = "ldapquery_showattr_" . $attr;
                global $$Var;
                if ($$Var == "on") {
                    echo "<td>";

                    if (!isset( $entry[$i][$attr]) || $entry[$i][$attr]["count"] == 0) {
                        echo "<br />\n";  // to avoid totally empty cells
                    }

                    if (isset($entry[$i][$attr])) {
                        for ($x=0 ; $x < $entry[$i][$attr]["count"] ; $x++) {
                            // Since there might be multiple values per attribute,
                            // prefix each one with <p> so they're on separate lines
                            // within the cell
                            echo "<p>";

                            switch ($attr) {
                            case "labeledurl":
                                // split up url and label parts
                                $val = $entry[$i][$attr][$x] . " <END>";
                                $isfirsttoken = true;
                                for ($token = strtok($val, " "); $token != "<END>";
                                 $token = strtok(" "))
                                    {
                                        if ($isfirsttoken) {
                                            echo "<a href=\"$token\">";
                                        }
                                        echo "$token";
                                        if ($isfirsttoken) {
                                            echo "</a> ";
                                            $isfirsttoken = false;
                                        }
                                    }
                                break;
                            case "mail":
                                $val = $entry[$i][$attr][$x];
                                displayInternalLink ("src/compose.php?send_to=$val",
                                                     "$val", "right");
                                break;
                            default:
                                $val = $entry[$i][$attr][$x] . "$<END>";
                                for ($token = strtok($val, "\$");
                                     $token != "<END>"; $token = strtok("\$"))
                                    {
                                        echo "$token<br />";
                                    }
                            }
                        }
                    }
                    echo '</td>';
                }
            }

            echo "</tr>\n";
        }
        echo "</table>\n";
    } else {
        echo _("No records found") . "<br />\n";
    }
}

/** Load post vars */
sqgetGlobalVar('ldq_searchfor',$ldq_searchfor,SQ_POST);
sqgetGlobalVar('ldq_searchby',$ldq_searchby,SQ_POST);
if (! sqgetGlobalVar('ldq_comparetype',$ldq_comparetype,SQ_POST))
     $ldq_comparetype='Contains';
sqgetGlobalVar('ldq_querystr',$ldq_querystr,SQ_POST);
sqgetGlobalVar('ldq_sortby',$ldq_sortby,SQ_POST);

sqgetGlobalVar('ldq_rdn',$ldq_rdn,SQ_POST);
sqgetGlobalVar('ldq_pass',$ldq_pass,SQ_POST);

displayPageHeader($color, "None");

echo "<!-- start ldapquery search form -->\n";
echo '<form action="' . $PHP_SELF . '" method="post">' . "\n";

if ($ldq_authreqd) {
    // Get the userdn to authenticate with
    echo '<b>' . _("User DN:") . '</b> ';
    echo '<input type="text" name="ldq_rdn" value="' . (isset($ldq_rdn) ? $ldq_rdn : '') . "\">\n";
   
    // Get the user password
    echo '<b>' . _("Password:") . '</b> ';
    echo '<input type="password" name="ldq_pass" value="">'. "\n";
    echo "<br />\n";
}

// Get the objectclass the user wants to search for
echo '<b>' . _("Search For:") . '</b> ';
echo '<select name="ldq_searchfor">'. "\n";
foreach ($ldq_searchobjs as $ldq_full=>$ldq_short) {
    echo '<option';
    if (isset($ldq_searchfor) && $ldq_full == $ldq_searchfor)
        echo ' selected';
    echo '">' . $ldq_full . "</option>\n";
}
echo "</select>\n";


// Get the attribute the user wants to search by
echo '<b>' . _("By:") . '</b> ';
echo '<select name="ldq_searchby">' . "\n";
foreach ($ldq_searchattrs as $ldq_full=>$ldq_short) {
    echo '<option';
    if (isset($ldq_searchby) && $ldq_full == $ldq_searchby)
        echo ' selected';
    echo '>' . $ldq_full . "</option>\n";
}
echo "</select>\n";
   
// Get type of search
echo '<select name="ldq_comparetype">' . "\n";
if ($ldq_comparetype == "Contains") 
     echo '<option value="Contains" selected>' . _("Contains") . "</option>\n";
     else
     echo '<option value="Contains">' . _("Contains") . "</option>\n";
if ($ldq_comparetype == "Is") 
     echo '<option value="Is" selected>' . _("Is") . "</option>\n";
     else
     echo '<option value="Is">' . _("Is") . "</option>\n";
echo "</select>\n";

// Get search name from user
echo '<input type="text" name="ldq_querystr" ';
echo 'value="' . (isset($ldq_querystr) ? $ldq_querystr : '') ."\">\n";
echo "<br />\n";

// Sort By menu
echo '<b>' . _("Sort By:") . '</b> ';
echo '<select name="ldq_sortby">' . "\n";
foreach ($ldq_attributes as $ldq_full=>$ldq_short) {
    echo '<option';
    if (isset($ldq_sortby) && $ldq_full == $ldq_sortby)
        echo ' selected';
    echo '>' . $ldq_full . "</option>\n";
}
echo "</select>\n";

// Submit button
echo '<input type="submit" name="Submit_Button" ';
echo 'value="' . _("Search") . "\">\n";

// End seach form
echo "</form>\n";
echo "<!-- end ldapquery search form -->\n";

if (isset($ldq_querystr) && $ldq_querystr != "") {
    echo '<h3>' . _("Search Results") . "</h3>\n";

    // setup search filter
    if (isset($ldq_debug))
        echo 'Comparetype is ' . htmlspecialchars($ldq_comparetype) . "<br>\n";

    switch ($ldq_comparetype) {
    case "Contains":
        $ldq_tfilter = "*$ldq_querystr*";
        break;
    case "Is":
        $ldq_tfilter = $ldq_querystr;
        break;
    default:   // assume it's a contains search
        $ldq_tfilter = "*$ldq_querystr*";
    }
    if ($ldq_tfilter == "***")
        $ldq_tfilter = "*";
    $ldq_filter = $ldq_searchattrs[$ldq_searchby] . "=$ldq_tfilter";

    // Now take the filter and "AND" in the objectclass restriction if any
    $ldq_filter = "(&(objectclass=" . $ldq_searchobjs[$ldq_searchfor] .
        ")(" . $ldq_filter . "))";

    if (isset($ldq_debug))
        echo 'QUERY is ' . htmlspecialchars($ldq_filter) . "<br>\n";

    // Perform search for each LDAP server configured in squirrel
    for ($ldq_lds=0 ; $ldq_lds < count($ldap_server) ; $ldq_lds++) {
        // Get the data for this Directory Server
        $ldq_Server = $ldap_server[$ldq_lds]["host"];
        $ldq_Port = (isset($ldap_server[$ldq_lds]["port"]) ? $ldap_server[$ldq_lds]["port"] : 389);
        $ldq_base = $ldap_server[$ldq_lds]["base"];

        // Get binddn and password (SM 1.5.0+ and 1.4.3+)
        if (isset($ldap_server[$ldq_lds]['binddn'])) {
            $ldq_binddn=$ldap_server[$ldq_lds]['binddn'];
            $ldq_bindpw= (isset($ldap_server[$ldq_lds]['bindpw']) ? $ldap_server[$ldq_lds]['bindpw'] : '');
            $ldq_internal_bind=true;
        } else {
            $ldq_internal_bind=false;
        }
        // Get bind protocol (SM 1.5.0+ and 1.4.3+)
        if (isset($ldap_server[$ldq_lds]['protocol']))
            $ldq_protocol = $ldap_server[$ldq_lds]['protocol'];

        print ("<hr />\n");

        // I usually just use these for debugging
        if (isset($ldq_debug)) echo "<i>Querying: $ldq_Server on port $ldq_Port with base $ldq_base</i><br>\n";

        print ("<i>" . $ldap_server[$ldq_lds]["name"] . "</i><br /><br />\n");
   
        // connect to LDAP server
        if (!($ldq_ldap=@ldap_connect($ldq_Server,$ldq_Port))) {
            echo sprintf(_("Could not connect to LDAP server %s"),$ldq_Server);
            continue;
        }

        if (isset($ldq_protocol))
            @ldap_set_option($ldq_ldap, LDAP_OPT_PROTOCOL_VERSION, $ldq_protocol);
   
        //attempt to bind to LDAP server
        if ($ldq_internal_bind) {
            if (!@ldap_bind($ldq_ldap, $ldq_binddn, $ldq_bindpw)) {
                echo _("Unable to bind to LDAP server") . "<br>\n";
                continue;
            }
        } elseif ($ldq_authreqd) {
            if (!@ldap_bind($ldq_ldap, $ldq_rdn . ", " . $ldq_base, $ldq_pass)) {
                echo _("Unable to bind to LDAP server") . "<br />\n";
                continue;
            }
        } else {
            if (!@ldap_bind($ldq_ldap)) {
                echo _("Unable to bind to LDAP server") . "<br />\n";
                continue;
            }
        }

        foreach ($ldq_attributes as $attr) {
            $ldq_tattr[] = $attr;
        }

        // perform search
        if (!($ldq_result = ldap_search($ldq_ldap, $ldq_base, $ldq_filter, $ldq_tattr))) {
            echo _("Nothing found!") . "<br />\n";
            continue;
        }
   
        // Get all the entries
        $ldq_entry = ldap_get_entries ($ldq_ldap, $ldq_result);

        if (isset($ldq_debug)) {
            echo '<b>' . sprintf(_("output type is %s"),htmlspecialchars($ldapquery_output_type)) . "</b><br>\n";
            echo '<b>' . sprintf(_("output sorted by %s"),htmlspecialchars($ldq_sortby)) . "</b><br />\n";
        }

        switch ($ldapquery_output_type) {
        case "OneTable":
            ldapquery_dispresultsSingle ($ldq_attributes, $ldq_entry,
                                         $ldq_attributes[$ldq_sortby]);
            break;
        case "MultiTable":
        default:
            ldapquery_dispresultsMulti ($ldq_attributes, $ldq_entry,
                                        $ldq_attributes[$ldq_sortby]);
        }
 
        // close connection
        ldap_close($ldq_ldap);
    }
}
?>
</body></html>
