#!/bin/sh
# Script to change an image into an alpha-enabled PNG for jsclock.
# Requirements: ppmtogif, giftopnm, pnmcut, pnmtopng from netpbm.
# NOTE: The version of pnmtoppng that comes with RedHat is BROKEN.
# Get the one at: http://www.libpng.org/pub/png/apps/pnmtopng.html
# And point to it.
#
#  Remove this line and the next three to enable.
echo "Please move this shell script out of here so that is isn't accidentally"
echo "executed by your web server and edit it to enabled it."
exit 0
#
set -a
pnmtopng=/usr/local/bin/pnmtopng


abortchk() {
  r=$?
  if [ $r != 0 ]; then
    echo "$1, exit code=$r" >&2
    exit $r
  fi
}
remove=""
cleanup() {
  echo "Cleanup: $remove"
  rm -f $remove
}
trap cleanup 0 2 3 15
usage() {
  echo "Usage: $0 inputimage.{gif|ppm|pgm} [color]" >&2
  echo >&2
  echo "Color examples: rgb:ff/ff/ff, blue, #45bc34.   Default is \"black\""
  exit 1
}
input=$1
color="rgb:00/00/00"
[ "$2" != "" ] && color="$2"
[ ! -f "$input" ] && usage
ext=`echo $input|sed 's/\(.*\)\(...$\)/\2/'|tr "[A-Z]" "[a-z]"`
base=`echo $input|sed 's/....$//'`
pgm=${base}.pgm
case "$ext" in
  pgm ) pgm=$input ;;
  ppm ) 
    ppmtopgm $input >$pgm
    abortchk "ppmtopgm"
    remove="$remove $pgm"
    ;;
  gif )
    giftopnm $input >${base}.pnm
    abortchk "giftopnm"
    remove="$remove ${base}.pnm"
    ppmtopgm ${base}.pnm >$pgm
    remove="$remove ${base}.pgm"
    abortchk "ppmtopgm"
    ;;
  * ) usage ;;
esac
dimensions="`pnmfile $pgm|cut -d, -f2- |awk '{print $1,$3}'`"
width=`echo $dimensions|cut -d" " -f1`
height=`echo $dimensions|cut -d" " -f2`
if [ "$width" = "" -o "$height" = "" ]; then
  echo "Can't figure out dimensions for $pgm" >&2
  exit 1
fi
echo "Input dimensions are: ${width}x${height}"
n=temp
top=0
bottom=`expr $height - 1`
left=0
right=`expr $width - 1`
pnminvert $pgm >inverted.pgm
abortchk "pnminvert"
remove="$remove inverted.pgm"
ppmmake "$color" $width $height >color.ppm
abortchk "ppmmake"
remove="$remove color.ppm"
$pnmtopng -alpha inverted.pgm color.ppm > ${base}.png
abortchk "pnmtopng"
