#!/bin/sh
# Script to extract digits for jsclock.
# Input image like this-> 0123456789:.
# Requirements: ppmtogif, giftopnm, pnmcut, pnmtopng from netpbm.
# NOTE: The version of pnmtopng that comes with RedHat is BROKEN.
# Get the one at: http://www.libpng.org/pub/png/apps/pnmtopng.html
# And point to it.
#
#  Remove this line and the next three to enable.
echo "Please move this shell script out of here so that is isn't accidentally"
echo "executed by your web server and edit it to enabled it."
exit 0
#
set -a
pnmtopng=/usr/local/bin/pnmtopng


abortchk() {
  r=$?
  if [ $r != 0 ]; then
    echo "$1, exit code=$r" >&2
    exit $r
  fi
}
remove=""
cleanup() {
  echo "Cleanup: $remove"
  rm -f $remove
}
trap cleanup 0 2 3 15
usage() {
  echo "Usage: $0 inputimage.{gif|ppm|pgm} [color]" >&2
  echo >&2
  echo "The input image should look like this: \"0123456789:.\" (Black on white)"
  echo "Color examples: rgb:ff/ff/ff, blue, #45bc34.   Default is \"black\""
  exit 1
}
input=$1
color="rgb:00/00/00"
[ "$2" != "" ] && color="$2"
[ ! -f "$input" ] && usage
ext=`echo $input|sed 's/\(.*\)\(...$\)/\2/'|tr "[A-Z]" "[a-z]"`
base=`echo $input|sed 's/....$//'`
pgm=${base}.pgm
case "$ext" in
  pgm ) pgm=$input ;;
  ppm ) 
    ppmtopgm $input >$pgm
    abortchk "ppmtopgm"
    remove="$remove $pgm"
    ;;
  gif )
    giftopnm $input >${base}.pnm
    abortchk "giftopnm"
    remove="$remove ${base}.pnm"
    ppmtopgm ${base}.pnm >$pgm
    remove="$remove ${base}.pgm"
    abortchk "ppmtopgm"
    ;;
  * ) usage ;;
esac
echo -n "Got PGM: "
ls -l $pgm


dimensions="`head -2 <$pgm |tail -1`"
width=`echo $dimensions|cut -d" " -f1`
height=`echo $dimensions|cut -d" " -f2`
if [ "$width" = "" -o "$height" = "" ]; then
  echo "Can't figure out dimensions for $pgm" >&2
  exit 1
fi
echo "Input dimensions are: ${width}x${height}"
if [ `expr $width % 12` != 0 ]; then
  echo "Input width is not a multiple of 12 (Should look like \"0123456789:.\"." >&2
  exit 1
fi
digitwidth=`expr $width / 12`
digitheight=$height
echo "Digit dimensions will be: ${digitwidth}x${digitheight}"
d=0
while [ $d -lt 12 ]; do
  n=$d
  case $d in
    10 ) n=colon;;
    11 ) n=period;;
  esac
  top=0
  bottom=`expr $digitheight - 1`
  left=`expr $d \* $digitwidth`
  right=`expr $d \* $digitwidth + $digitwidth - 1`
  pnmcut -left $left -right $right -top $top -bottom $bottom \
         $pgm > ${n}.pnm
  abortchk "pnmcut"
  remove="$remove ${n}.pnm"
  anytopnm ${n}.pnm > ${n}.ppm
  abortchk "anytopnm"
  remove="$remove ${n}.ppm"
  ppmtopgm ${n}.ppm >${n}.alpha.pgm
  abortchk "ppmtopgm"
  remove="$remove ${n}.alpha.pgm"
  pnminvert ${n}.alpha.pgm >${n}.alpha.inverted.pgm
  abortchk "pnminvert"
  remove="$remove ${n}.alpha.inverted.pgm"
  ppmmake "$color" $digitwidth $digitheight >color.ppm
  abortchk "ppmmake"
  remove="$remove color.ppm"
  $pnmtopng -alpha ${n}.alpha.inverted.pgm color.ppm > ${n}.png
  abortchk "pnmtopng"
  d=`expr $d + 1`
done
