<?php

/**
  * SquirrelMail Japanese Input Plugin
  * Copyright (c) 2004-2007 Paul Lesniewski <paul@squirrelmail.org>
  * Licensed under the GNU GPL. For full terms see the file COPYING.
  *
  * The bulk of this plugin relies upon JavaScript Japanese Input 
  * Module written in 2004 by Kitya Karlson, GPL.  See:
  * http://www.karlson.ru/jstoys/index.php?module=input_ja
  *
  * @package plugins
  * @subpackage japanese_input
  *
  */


/**
  * Register this plugin with SquirrelMail
  *
  */
function squirrelmail_plugin_init_japanese_input() 
{

   global $squirrelmail_plugin_hooks;


   // SquirrelMail 1.4.x
   //
   $squirrelmail_plugin_hooks['optpage_loadhook_display']['japanese_input'] 
      = 'ji_options_14';
   $squirrelmail_plugin_hooks['compose_button_row']['japanese_input'] 
      = 'ji_show_button';


   // SquirrelMail 1.5.x
   //
   $squirrelmail_plugin_hooks['optpage_loadhook_compose']['japanese_input'] 
      = 'ji_options_15';
   $squirrelmail_plugin_hooks['template_construct_compose_buttons.tpl']['japanese_input'] 
      = 'ji_show_button';

}


/** @ignore */
if (!defined('SM_PATH'))
   define('SM_PATH', '../');


/**
  * Display the "Japanese" button on the compose screen
  *
  */
function ji_show_button() 
{

   include_once(SM_PATH . 'plugins/japanese_input/functions.php');
   return ji_show_button_do();

}


/**
  * Display plugin option widgets for SquirrelMail 1.4.x
  *
  */
function ji_options_14() 
{

   include_once(SM_PATH . 'plugins/japanese_input/functions.php');
   ji_options_14_do();

}


/**
  * Display plugin option widgets for SquirrelMail 1.5.x
  *
  */
function ji_options_15() 
{

   include_once(SM_PATH . 'plugins/japanese_input/functions.php');
   ji_options_15_do();

}


/**
  * Returns info about this plugin
  *
  */
function japanese_input_info()
{

   return array(
                 'english_name' => 'Japanese Input',
                 'version' => '1.1',
                 'required_sm_version' => '1.2',
                 'requires_configuration' => 0,
                 'requires_source_patch' => 0,
                 'required_plugins' => array(),
                 'summary' => 'Allows emails to be composed in Japanese.',
                 'details' => 'This plugin allows users to compose emails using Japanese characters, even when they are using a computer that does not have a Japanese input system. This is a simplified input system and is no replacement for an O/S that facilitates Japanese input, but is handy when you need to compose Japanese emails on a system that doesn\'t have such support.',
               );

}



/**
  * Returns version info about this plugin
  *
  */
function japanese_input_version()
{

   $info = japanese_input_info();
   return $info['version'];

}



