<?php

/**
  * SquirrelMail Japanese Input Plugin
  * Copyright (c) 2004-2007 Paul Lesniewski <paul@squirrelmail.org>
  * Licensed under the GNU GPL. For full terms see the file COPYING.
  *
  * The bulk of this plugin relies upon JavaScript Japanese Input
  * Module written in 2004 by Kitya Karlson, GPL.  See:
  * http://www.karlson.ru/jstoys/index.php?module=input_ja
  *
  * @package plugins
  * @subpackage japanese_input
  *
  */


/**
  * Display the "Japanese" button on the compose screen 
  *
  */
function ji_show_button_do() 
{

   global $data_dir, $username, $base_uri;
   $base_uri = sqm_baseuri();
   $japanese_input_show_button = getPref($data_dir, $username, 'japanese_input_show_button', 0);   
   if ($japanese_input_show_button)
   {

      bindtextdomain('japanese_input', SM_PATH . 'locale');
      textdomain('japanese_input');

      // SquirrelMail 1.5
      //
      if (check_sm_version(1, 5, 2))
      {

         global $oTemplate;
         $nbsp = $oTemplate->fetch('non_breaking_space.tpl');
         $output = addButton(_("Japanese"), 'japanese_input', 
                             array('onclick' => 'window.open(\''
                                              . $base_uri 
                                              . 'plugins/japanese_input/input_ja/special_characters_jp.php\', \'japanese_input\',\'left=\'+(screen.availWidth-405)+\',top=\'+(screen.availHeight-180)+\',width=405,height=180,toolbar=no,location=no,directories=no,status=no,menubar=no,scrollbars=no,resizable=no\'); ')) . $nbsp;

         return array('compose_button_row' => $output);

      }


      // SquirrelMail 1.4.x
      //
      else
      {

         echo '<input type="button" onclick="window.open(\''
            . $base_uri . 'plugins/japanese_input/input_ja/special_characters_jp.php\', \'japanese_input\',\'left=\'+(screen.availWidth-405)+\',top=\'+(screen.availHeight-180)+\',width=405,height=180,toolbar=no,location=no,directories=no,status=no,menubar=no,scrollbars=no,resizable=no\')" name="japanese_input" value="' . _("Japanese") . '" />&nbsp;';

      }

      bindtextdomain('squirrelmail', SM_PATH . 'locale');
      textdomain('squirrelmail');

   }

}



/**
  * Display plugin option widgets for SquirrelMail 1.4.x
  *
  */
function ji_options_14_do()
{

   // SquirrelMail 1.5?  bail.
   //
   if (check_sm_version(1, 5, 2))
      return;

   global $data_dir, $username;
   $japanese_input_show_button = getPref($data_dir, $username, 'japanese_input_show_button', 0);   

   bindtextdomain('japanese_input', SM_PATH . 'locale');
   textdomain('japanese_input');

   global $optpage_data;
   $optpage_data['vals'][2][] = array(
      'name'          => 'japanese_input_show_button',
      'caption'       => _("Show Japanese Input Button"),
      'type'          => SMOPT_TYPE_BOOLEAN,
      'initial_value' => $japanese_input_show_button,
      'refresh'       => SMOPT_REFRESH_NONE,
   );

   bindtextdomain('squirrelmail', SM_PATH . 'locale');
   textdomain('squirrelmail');

}



/**
  * Display plugin option widgets for SquirrelMail 1.5.x
  *
  */
function ji_options_15_do()
{

   // SquirrelMail 1.4?  bail.
   //
   if (!check_sm_version(1, 5, 2))
      return;

   global $data_dir, $username;
   $japanese_input_show_button = getPref($data_dir, $username, 'japanese_input_show_button', 0);   

   bindtextdomain('japanese_input', SM_PATH . 'locale');
   textdomain('japanese_input');

   global $optpage_data;
   $optpage_data['vals'][0][] = array(
      'name'          => 'japanese_input_show_button',
      'caption'       => _("Show Japanese Input Button"),
      'type'          => SMOPT_TYPE_BOOLEAN,
      'initial_value' => $japanese_input_show_button,
      'refresh'       => SMOPT_REFRESH_NONE,
   );

   bindtextdomain('squirrelmail', SM_PATH . 'locale');
   textdomain('squirrelmail');

}



